/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.complextypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.complextypes.ComplexQueryType;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.DataTypeUtil;

public class ArrayQueryType
extends ComplexQueryType
implements GenericQueryType {
    private GenericQueryType children;

    public ArrayQueryType(String name, String parentName, int columnIndex) {
        super(name, parentName, columnIndex);
    }

    @Override
    public void addChildren(GenericQueryType children) {
        if (this.getName().equals(children.getParentName())) {
            this.children = children;
        } else {
            this.children.addChildren(children);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public void parseBlocksAndReturnComplexColumnByteArray(DimensionRawColumnChunk[] rawColumnChunks, DimensionColumnPage[][] dimensionColumnPages, int rowNumber, int pageNumber, DataOutputStream dataOutputStream) throws IOException {
        byte[] input = this.copyBlockDataChunk(rawColumnChunks, dimensionColumnPages, rowNumber, pageNumber);
        ByteBuffer byteArray = ByteBuffer.wrap(input);
        int dataLength = byteArray.getInt();
        dataOutputStream.writeInt(dataLength);
        if (dataLength > 0) {
            int dataOffset = byteArray.getInt();
            for (int i = 0; i < dataLength; ++i) {
                this.children.parseBlocksAndReturnComplexColumnByteArray(rawColumnChunks, dimensionColumnPages, dataOffset++, pageNumber, dataOutputStream);
            }
        }
    }

    @Override
    public int getColsCount() {
        return this.children.getColsCount() + 1;
    }

    @Override
    public void fillRequiredBlockData(RawBlockletColumnChunks blockChunkHolder) throws IOException {
        this.readBlockDataChunk(blockChunkHolder);
        this.children.fillRequiredBlockData(blockChunkHolder);
    }

    @Override
    public Object getDataBasedOnDataType(ByteBuffer dataBuffer) {
        Object[] data = this.fillData(dataBuffer);
        if (data == null) {
            return null;
        }
        return DataTypeUtil.getDataTypeConverter().wrapWithGenericArrayData(data);
    }

    protected Object[] fillData(ByteBuffer dataBuffer) {
        int dataLength = dataBuffer.getInt();
        if (dataLength == -1) {
            return null;
        }
        Object[] data = new Object[dataLength];
        for (int i = 0; i < dataLength; ++i) {
            data[i] = this.children.getDataBasedOnDataType(dataBuffer);
        }
        return data;
    }

    @Override
    public Object getDataBasedOnColumn(ByteBuffer dataBuffer, CarbonDimension parent, CarbonDimension child) {
        throw new UnsupportedOperationException("Operation Unsupported for ArrayType");
    }

    @Override
    public Object getDataBasedOnColumnList(Map<CarbonDimension, ByteBuffer> childBuffer, CarbonDimension presentColumn) {
        throw new UnsupportedOperationException("Operation Unsupported for ArrayType");
    }
}

