/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.complextypes;

import java.io.IOException;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;

public class ComplexQueryType {
    protected String name;
    protected String parentName;
    protected int columnIndex;

    public ComplexQueryType(String name, String parentName, int columnIndex) {
        this.name = name;
        this.parentName = parentName;
        this.columnIndex = columnIndex;
    }

    protected byte[] copyBlockDataChunk(DimensionRawColumnChunk[] rawColumnChunks, DimensionColumnPage[][] dimensionColumnPages, int rowNumber, int pageNumber) {
        byte[] data = this.getDecodedDimensionPage(dimensionColumnPages, rawColumnChunks[this.columnIndex], pageNumber).getChunkData(rowNumber);
        byte[] output = new byte[data.length];
        System.arraycopy(data, 0, output, 0, output.length);
        return output;
    }

    protected void readBlockDataChunk(RawBlockletColumnChunks blockChunkHolder) throws IOException {
        if (null == blockChunkHolder.getDimensionRawColumnChunks()[this.columnIndex]) {
            blockChunkHolder.getDimensionRawColumnChunks()[this.columnIndex] = blockChunkHolder.getDataBlock().readDimensionChunk(blockChunkHolder.getFileReader(), this.columnIndex);
        }
    }

    private DimensionColumnPage getDecodedDimensionPage(DimensionColumnPage[][] dimensionColumnPages, DimensionRawColumnChunk dimensionRawColumnChunk, int pageNumber) {
        if (dimensionColumnPages == null || null == dimensionColumnPages[this.columnIndex]) {
            return dimensionRawColumnChunk.decodeColumnPage(pageNumber);
        }
        return dimensionColumnPages[this.columnIndex][pageNumber];
    }
}

