/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.complextypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.complextypes.ComplexQueryType;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public class PrimitiveQueryType
extends ComplexQueryType
implements GenericQueryType {
    private String name;
    private String parentName;
    private DataType dataType;
    private boolean isDirectDictionary;

    public PrimitiveQueryType(String name, String parentName, int columnIndex, DataType dataType, boolean isDirectDictionary) {
        super(name, parentName, columnIndex);
        this.dataType = dataType;
        this.name = name;
        this.parentName = parentName;
        this.isDirectDictionary = isDirectDictionary;
    }

    @Override
    public void addChildren(GenericQueryType children) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public int getColsCount() {
        return 1;
    }

    @Override
    public void parseBlocksAndReturnComplexColumnByteArray(DimensionRawColumnChunk[] rawColumnChunks, DimensionColumnPage[][] dimensionColumnPages, int rowNumber, int pageNumber, DataOutputStream dataOutputStream) throws IOException {
        byte[] currentVal = this.copyBlockDataChunk(rawColumnChunks, dimensionColumnPages, rowNumber, pageNumber);
        if (!this.isDirectDictionary) {
            if (DataTypeUtil.isByteArrayComplexChildColumn(this.dataType)) {
                dataOutputStream.writeInt(currentVal.length);
            } else {
                dataOutputStream.writeShort(currentVal.length);
            }
        }
        dataOutputStream.write(currentVal);
    }

    @Override
    public void fillRequiredBlockData(RawBlockletColumnChunks blockChunkHolder) throws IOException {
        this.readBlockDataChunk(blockChunkHolder);
    }

    @Override
    public Object getDataBasedOnDataType(ByteBuffer dataBuffer) {
        return this.getDataObject(dataBuffer, -1);
    }

    @Override
    public Object getDataBasedOnColumn(ByteBuffer dataBuffer, CarbonDimension parent, CarbonDimension child) {
        if (parent.getOrdinal() != child.getOrdinal() || null == dataBuffer || !dataBuffer.hasRemaining()) {
            return null;
        }
        int size = !DataTypeUtil.isFixedSizeDataType(child.getDataType()) ? dataBuffer.array().length : (child.getDataType() == DataTypes.TIMESTAMP ? DataTypes.LONG.getSizeInBytes() : child.getDataType().getSizeInBytes());
        Object actualData = this.getDataObject(dataBuffer, size);
        return actualData;
    }

    private Object getDataObject(ByteBuffer dataBuffer, int size) {
        Object actualData;
        if (this.isDirectDictionary) {
            byte[] data = new byte[4];
            dataBuffer.get(data);
            actualData = ByteUtil.convertBytesToInt(data);
        } else {
            if (size == -1) {
                size = DataTypeUtil.isByteArrayComplexChildColumn(this.dataType) ? dataBuffer.getInt() : (int)dataBuffer.getShort();
            }
            byte[] value = new byte[size];
            dataBuffer.get(value, 0, size);
            if (this.dataType == DataTypes.DATE) {
                if (value.length == 0) {
                    actualData = null;
                } else {
                    DirectDictionaryGenerator directDictGenForDate = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(DataTypes.DATE);
                    actualData = directDictGenForDate.getValueFromSurrogate(ByteUtil.toXorInt(value, 0, 4));
                }
            } else {
                actualData = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(value, this.dataType);
            }
        }
        return actualData;
    }

    @Override
    public Object getDataBasedOnColumnList(Map<CarbonDimension, ByteBuffer> childBuffer, CarbonDimension presentColumn) {
        return this.getDataBasedOnColumn(childBuffer.get(presentColumn), presentColumn, presentColumn);
    }
}

