/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.complextypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.complextypes.ComplexQueryType;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.DataTypeUtil;

public class StructQueryType
extends ComplexQueryType
implements GenericQueryType {
    private List<GenericQueryType> children = new ArrayList<GenericQueryType>();
    private String name;
    private String parentName;

    public StructQueryType(String name, String parentName, int columnIndex) {
        super(name, parentName, columnIndex);
        this.name = name;
        this.parentName = parentName;
    }

    @Override
    public void addChildren(GenericQueryType newChild) {
        if (this.getName().equals(newChild.getParentName())) {
            this.children.add(newChild);
        } else {
            for (GenericQueryType child : this.children) {
                child.addChildren(newChild);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public int getColsCount() {
        int colsCount = 1;
        for (int i = 0; i < this.children.size(); ++i) {
            colsCount += this.children.get(i).getColsCount();
        }
        return colsCount;
    }

    @Override
    public void parseBlocksAndReturnComplexColumnByteArray(DimensionRawColumnChunk[] dimensionColumnDataChunks, DimensionColumnPage[][] dimensionColumnPages, int rowNumber, int pageNumber, DataOutputStream dataOutputStream) throws IOException {
        byte[] input = this.copyBlockDataChunk(dimensionColumnDataChunks, dimensionColumnPages, rowNumber, pageNumber);
        ByteBuffer byteArray = ByteBuffer.wrap(input);
        int childElement = byteArray.getShort();
        dataOutputStream.writeShort(childElement);
        if (childElement > 0) {
            for (int i = 0; i < childElement; ++i) {
                this.children.get(i).parseBlocksAndReturnComplexColumnByteArray(dimensionColumnDataChunks, dimensionColumnPages, rowNumber, pageNumber, dataOutputStream);
            }
        }
    }

    @Override
    public void fillRequiredBlockData(RawBlockletColumnChunks blockChunkHolder) throws IOException {
        this.readBlockDataChunk(blockChunkHolder);
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).fillRequiredBlockData(blockChunkHolder);
        }
    }

    @Override
    public Object getDataBasedOnDataType(ByteBuffer dataBuffer) {
        int childLength = dataBuffer.getShort();
        Object[] fields = new Object[childLength];
        for (int i = 0; i < childLength; ++i) {
            fields[i] = this.children.get(i).getDataBasedOnDataType(dataBuffer);
        }
        return DataTypeUtil.getDataTypeConverter().wrapWithGenericRow(fields);
    }

    @Override
    public Object getDataBasedOnColumn(ByteBuffer dataBuffer, CarbonDimension parent, CarbonDimension child) {
        if (parent.getOrdinal() < child.getOrdinal()) {
            int childLength = parent.getNumberOfChild();
            Object[] fields = new Object[childLength];
            for (int i = 0; i < childLength; ++i) {
                fields[i] = this.children.get(i).getDataBasedOnColumn(dataBuffer, parent.getListOfChildDimensions().get(i), child);
            }
            return DataTypeUtil.getDataTypeConverter().wrapWithGenericRow(fields);
        }
        if (parent.getOrdinal() > child.getOrdinal()) {
            return null;
        }
        Object field = this.getDataBasedOnDataType(dataBuffer);
        return field;
    }

    @Override
    public Object getDataBasedOnColumnList(Map<CarbonDimension, ByteBuffer> childBuffer, CarbonDimension presentColumn) {
        if (childBuffer.get(presentColumn) != null) {
            if (presentColumn.getNumberOfChild() > 0) {
                Object field = this.getDataBasedOnDataType(childBuffer.get(presentColumn));
                return field;
            }
            Object field = this.children.get(0).getDataBasedOnColumn(childBuffer.get(presentColumn), presentColumn, presentColumn);
            return field;
        }
        int childLength = presentColumn.getNumberOfChild();
        Object[] fields = new Object[childLength];
        for (int i = 0; i < childLength; ++i) {
            fields[i] = this.children.get(i).getDataBasedOnColumnList(childBuffer, presentColumn.getListOfChildDimensions().get(i));
        }
        return DataTypeUtil.getDataTypeConverter().wrapWithGenericRow(fields);
    }
}

