/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.executor.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.block.AbstractIndex;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletDataRefNode;
import org.apache.carbondata.core.indexstore.blockletindex.IndexWrapper;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.executor.impl.QueryExecutorProperties;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public abstract class AbstractQueryExecutor<E>
implements QueryExecutor<E> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)AbstractQueryExecutor.class.getName());
    protected QueryExecutorProperties queryProperties;
    private boolean freeUnsafeMemory;
    protected CarbonIterator queryIterator;

    public AbstractQueryExecutor(Configuration configuration) {
        ThreadLocalSessionInfo.setConfigurationToCurrentThread(configuration);
        this.queryProperties = new QueryExecutorProperties();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.queryProperties.executorService = executorService;
    }

    protected void initQuery(QueryModel queryModel) throws IOException {
        LOGGER.info((Object)("Query will be executed on table: " + queryModel.getAbsoluteTableIdentifier().getCarbonTableIdentifier().getTableName()));
        this.freeUnsafeMemory = queryModel.isFreeUnsafeMemory();
        this.queryProperties.queryStatisticsRecorder = queryModel.getStatisticsRecorder();
        if (null == this.queryProperties.queryStatisticsRecorder) {
            this.queryProperties.queryStatisticsRecorder = CarbonTimeStatisticsFactory.createExecutorRecorder(queryModel.getQueryId());
            queryModel.setStatisticsRecorder(this.queryProperties.queryStatisticsRecorder);
        }
        QueryStatistic queryStatistic = new QueryStatistic();
        Collections.sort(queryModel.getTableBlockInfos());
        this.queryProperties.dataBlocks = this.getDataBlocks(queryModel);
        queryStatistic.addStatistics("Time taken to load the Block(s) In Executor", System.currentTimeMillis());
        this.queryProperties.queryStatisticsRecorder.recordStatistics(queryStatistic);
        this.queryProperties.filterMeasures = new HashSet<CarbonMeasure>();
        this.queryProperties.complexFilterDimension = new HashSet<CarbonDimension>();
        if (queryModel.getIndexFilter() != null) {
            QueryUtil.getAllFilterDimensionsAndMeasures(queryModel.getIndexFilter().getResolver(), this.queryProperties.complexFilterDimension, this.queryProperties.filterMeasures);
        }
        queryStatistic = new QueryStatistic();
        queryStatistic.addStatistics("Time taken to load the Dictionary In Executor", System.currentTimeMillis());
        this.queryProperties.queryStatisticsRecorder.recordStatistics(queryStatistic);
    }

    private List<AbstractIndex> getDataBlocks(QueryModel queryModel) throws IOException {
        LinkedHashMap<String, ArrayList<TableBlockInfo>> listMap = new LinkedHashMap<String, ArrayList<TableBlockInfo>>();
        HashMap<String, DataFileFooter> filePathToFileFooterMapping = new HashMap<String, DataFileFooter>();
        HashMap<String, SegmentProperties> filePathToSegmentPropertiesMap = new HashMap<String, SegmentProperties>();
        for (TableBlockInfo blockInfo : queryModel.getTableBlockInfos()) {
            ArrayList<TableBlockInfo> tableBlockInfos = (ArrayList<TableBlockInfo>)listMap.get(blockInfo.getFilePath());
            if (tableBlockInfos == null) {
                tableBlockInfos = new ArrayList<TableBlockInfo>();
                listMap.put(blockInfo.getFilePath(), tableBlockInfos);
            }
            SegmentProperties segmentProperties = (SegmentProperties)filePathToSegmentPropertiesMap.get(blockInfo.getFilePath());
            BlockletDetailInfo blockletDetailInfo = blockInfo.getDetailInfo();
            if (null == blockletDetailInfo || blockletDetailInfo.getBlockletInfo() == null || blockletDetailInfo.isUseMinMaxForPruning()) {
                if (null != blockletDetailInfo) {
                    blockInfo.setBlockOffset(blockletDetailInfo.getBlockFooterOffset());
                }
                DataFileFooter fileFooter = (DataFileFooter)filePathToFileFooterMapping.get(blockInfo.getFilePath());
                if (null != blockInfo.getDataFileFooter()) {
                    fileFooter = blockInfo.getDataFileFooter();
                }
                if (null == fileFooter) {
                    blockInfo.setDetailInfo(null);
                    fileFooter = CarbonUtil.readMetadataFile(blockInfo);
                    if (!queryModel.getTable().isTransactionalTable()) {
                        QueryUtil.updateColumnUniqueIdForNonTransactionTable(fileFooter.getColumnInTable());
                    }
                    filePathToFileFooterMapping.put(blockInfo.getFilePath(), fileFooter);
                    if (null == blockletDetailInfo) {
                        blockletDetailInfo = QueryUtil.getBlockletDetailInfo(fileFooter, blockInfo);
                    }
                    blockInfo.setDetailInfo(blockletDetailInfo);
                }
                if (null == segmentProperties) {
                    segmentProperties = new SegmentProperties(fileFooter.getColumnInTable());
                    this.createFilterExpression(queryModel, segmentProperties);
                    this.updateColumns(queryModel, fileFooter.getColumnInTable(), blockInfo.getFilePath());
                    filePathToSegmentPropertiesMap.put(blockInfo.getFilePath(), segmentProperties);
                }
                this.readAndFillBlockletInfo(tableBlockInfos, blockInfo, blockletDetailInfo, fileFooter);
                continue;
            }
            if (null == segmentProperties) {
                segmentProperties = new SegmentProperties(blockInfo.getDetailInfo().getColumnSchemas());
                this.createFilterExpression(queryModel, segmentProperties);
                this.updateColumns(queryModel, blockInfo.getDetailInfo().getColumnSchemas(), blockInfo.getFilePath());
                filePathToSegmentPropertiesMap.put(blockInfo.getFilePath(), segmentProperties);
            }
            tableBlockInfos.add(blockInfo);
        }
        ArrayList<AbstractIndex> indexList = new ArrayList<AbstractIndex>();
        for (ArrayList<TableBlockInfo> tableBlockInfos : listMap.values()) {
            indexList.add(new IndexWrapper(tableBlockInfos, (SegmentProperties)filePathToSegmentPropertiesMap.get(((TableBlockInfo)tableBlockInfos.get(0)).getFilePath())));
        }
        return indexList;
    }

    private void updateColumns(QueryModel queryModel, List<ColumnSchema> columnsInTable, String filePath) throws IOException {
        int index;
        if (queryModel.getTable().isTransactionalTable()) {
            return;
        }
        boolean sameColumnSchemaList = BlockletIndexUtil.isSameColumnAndDifferentDatatypeInSchema(columnsInTable, queryModel.getTable().getTableInfo().getFactTable().getListOfColumns());
        if (!sameColumnSchemaList) {
            LOGGER.error((Object)("Datatype of the common columns present in " + filePath + " doesn't match withthe column's datatype in table schema"));
            throw new IOException("All common columns present in the files doesn't have same datatype. Unsupported operation on nonTransactional table. Check logs.");
        }
        List<ProjectionDimension> dimensions = queryModel.getProjectionDimensions();
        List<ProjectionMeasure> measures = queryModel.getProjectionMeasures();
        ArrayList<ProjectionDimension> updatedDims = new ArrayList<ProjectionDimension>();
        ArrayList<ProjectionMeasure> updatedMsrs = new ArrayList<ProjectionMeasure>();
        for (ProjectionDimension dimension : dimensions) {
            index = columnsInTable.indexOf(dimension.getDimension().getColumnSchema());
            if (index > -1) {
                if (!columnsInTable.get(index).isDimensionColumn()) {
                    ProjectionMeasure measure = new ProjectionMeasure(new CarbonMeasure(columnsInTable.get(index), dimension.getDimension().getOrdinal(), dimension.getDimension().getSchemaOrdinal()));
                    measure.setOrdinal(dimension.getOrdinal());
                    updatedMsrs.add(measure);
                    continue;
                }
                updatedDims.add(dimension);
                continue;
            }
            updatedDims.add(dimension);
        }
        for (ProjectionMeasure measure : measures) {
            index = columnsInTable.indexOf(measure.getMeasure().getColumnSchema());
            if (index > -1) {
                if (columnsInTable.get(index).isDimensionColumn()) {
                    ProjectionDimension dimension = new ProjectionDimension(new CarbonDimension(columnsInTable.get(index), measure.getMeasure().getOrdinal(), -1, measure.getMeasure().getSchemaOrdinal()));
                    dimension.setOrdinal(measure.getOrdinal());
                    updatedDims.add(dimension);
                    continue;
                }
                updatedMsrs.add(measure);
                continue;
            }
            updatedMsrs.add(measure);
        }
        dimensions.clear();
        dimensions.addAll(updatedDims);
        measures.clear();
        measures.addAll(updatedMsrs);
    }

    private void createFilterExpression(QueryModel queryModel, SegmentProperties properties) {
        if (queryModel.getIndexFilter() != null && !queryModel.getIndexFilter().isResolvedOnSegment(properties)) {
            IndexFilter expression = new IndexFilter(properties, queryModel.getTable(), queryModel.getIndexFilter().getExpression());
            queryModel.setIndexFilter(expression);
        }
    }

    private void readAndFillBlockletInfo(List<TableBlockInfo> tableBlockInfos, TableBlockInfo blockInfo, BlockletDetailInfo blockletDetailInfo, DataFileFooter fileFooter) {
        List<BlockletInfo> blockletList = fileFooter.getBlockletList();
        if (blockletDetailInfo.getBlockletId() != -1) {
            BlockletInfo blockletInfo = blockletList.get(blockletDetailInfo.getBlockletId().shortValue());
            this.fillBlockletInfoToTableBlock(tableBlockInfos, blockInfo, fileFooter, blockletInfo, blockletDetailInfo.getBlockletId());
        } else {
            short count = 0;
            for (BlockletInfo blockletInfo : blockletList) {
                this.fillBlockletInfoToTableBlock(tableBlockInfos, blockInfo, fileFooter, blockletInfo, count);
                count = (short)(count + 1);
            }
        }
    }

    private void fillBlockletInfoToTableBlock(List<TableBlockInfo> tableBlockInfos, TableBlockInfo blockInfo, DataFileFooter fileFooter, BlockletInfo blockletInfo, short blockletId) {
        TableBlockInfo info = blockInfo.copy();
        BlockletDetailInfo detailInfo = info.getDetailInfo();
        detailInfo.setColumnSchemas(fileFooter.getColumnInTable());
        detailInfo.setRowCount(blockletInfo.getNumberOfRows());
        byte[][] maxValues = blockletInfo.getBlockletIndex().getMinMaxIndex().getMaxValues();
        byte[][] minValues = blockletInfo.getBlockletIndex().getMinMaxIndex().getMinValues();
        blockletInfo.getBlockletIndex().getMinMaxIndex().setMaxValues(maxValues);
        blockletInfo.getBlockletIndex().getMinMaxIndex().setMinValues(minValues);
        detailInfo.setBlockletInfo(blockletInfo);
        detailInfo.setBlockletId(blockletId);
        detailInfo.setPagesCount((short)blockletInfo.getNumberOfPages());
        tableBlockInfos.add(info);
    }

    protected List<BlockExecutionInfo> getBlockExecutionInfos(QueryModel queryModel) throws IOException {
        this.initQuery(queryModel);
        ArrayList<BlockExecutionInfo> blockExecutionInfoList = new ArrayList<BlockExecutionInfo>();
        ReusableDataBuffer[] dimensionReusableDataBuffers = null;
        ReusableDataBuffer[] measureReusableDataBuffers = null;
        for (int i = 0; i < this.queryProperties.dataBlocks.size(); ++i) {
            AbstractIndex abstractIndex = this.queryProperties.dataBlocks.get(i);
            BlockletDataRefNode dataRefNode = (BlockletDataRefNode)abstractIndex.getDataRefNode();
            BlockExecutionInfo blockExecutionInfoForBlock = this.getBlockExecutionInfoForBlock(queryModel, abstractIndex, dataRefNode.numberOfNodes(), dataRefNode.getBlockInfos().get(0).getFilePath(), dataRefNode.getBlockInfos().get(0).getDeletedDeltaFilePath(), dataRefNode.getBlockInfos().get(0).getSegment());
            if (null == dimensionReusableDataBuffers || null == measureReusableDataBuffers) {
                dimensionReusableDataBuffers = blockExecutionInfoForBlock.getDimensionReusableDataBuffer();
                measureReusableDataBuffers = blockExecutionInfoForBlock.getMeasureReusableDataBuffer();
            } else {
                if (dimensionReusableDataBuffers.length == blockExecutionInfoForBlock.getDimensionReusableDataBuffer().length) {
                    blockExecutionInfoForBlock.setDimensionReusableDataBuffer(dimensionReusableDataBuffers);
                }
                if (measureReusableDataBuffers.length == blockExecutionInfoForBlock.getMeasureReusableDataBuffer().length) {
                    blockExecutionInfoForBlock.setMeasureReusableDataBuffer(measureReusableDataBuffers);
                }
            }
            blockExecutionInfoList.add(blockExecutionInfoForBlock);
        }
        if (null != queryModel.getStatisticsRecorder()) {
            QueryStatistic queryStatistic = new QueryStatistic();
            queryStatistic.addCountStatistic("The num of blocks scanned", blockExecutionInfoList.size());
            queryModel.getStatisticsRecorder().recordStatistics(queryStatistic);
        }
        return blockExecutionInfoList;
    }

    private BlockExecutionInfo getBlockExecutionInfoForBlock(QueryModel queryModel, AbstractIndex blockIndex, int numberOfBlockletToScan, String filePath, String[] deleteDeltaFiles, Segment segment) {
        BlockExecutionInfo blockExecutionInfo = new BlockExecutionInfo();
        SegmentProperties segmentProperties = blockIndex.getSegmentProperties();
        RestructureUtil.actualProjectionOfSegment(blockExecutionInfo, queryModel, segmentProperties);
        List<ProjectionDimension> projectDimensions = RestructureUtil.createDimensionInfoAndGetCurrentBlockQueryDimension(blockExecutionInfo, blockExecutionInfo.getActualQueryDimensions(), segmentProperties.getDimensions(), segmentProperties.getComplexDimensions(), blockExecutionInfo.getActualQueryMeasures().length, queryModel.getTable().getTableInfo().isTransactionalTable());
        boolean isStandardTable = CarbonUtil.isStandardCarbonTable(queryModel.getTable());
        String blockId = CarbonUtil.getBlockId(queryModel.getAbsoluteTableIdentifier(), filePath, segment.getSegmentNo(), queryModel.getTable().getTableInfo().isTransactionalTable(), isStandardTable, queryModel.getTable().isHivePartitionTable());
        if (!isStandardTable) {
            blockExecutionInfo.setBlockId(CarbonTablePath.getShortBlockIdForPartitionTable(blockId));
        } else {
            blockExecutionInfo.setBlockId(CarbonTablePath.getShortBlockId(blockId));
        }
        blockExecutionInfo.setDeleteDeltaFilePath(deleteDeltaFiles);
        blockExecutionInfo.setStartBlockletIndex(0);
        blockExecutionInfo.setNumberOfBlockletToScan(numberOfBlockletToScan);
        blockExecutionInfo.setProjectionDimensions(projectDimensions.toArray(new ProjectionDimension[0]));
        List<ProjectionMeasure> projectionMeasures = RestructureUtil.createMeasureInfoAndGetCurrentBlockQueryMeasures(blockExecutionInfo, blockExecutionInfo.getActualQueryMeasures(), segmentProperties.getMeasures(), queryModel.getTable().getTableInfo().isTransactionalTable());
        blockExecutionInfo.setProjectionMeasures(projectionMeasures.toArray(new ProjectionMeasure[projectionMeasures.size()]));
        blockExecutionInfo.setDataBlock(blockIndex);
        blockExecutionInfo.setRawRecordDetailQuery(queryModel.isForcedDetailRawQuery());
        blockExecutionInfo.setTotalNumberDimensionToRead(segmentProperties.getDimensionOrdinalToChunkMapping().size());
        blockExecutionInfo.setReadOnlyDelta(queryModel.isReadOnlyDelta());
        if (queryModel.isReadPageByPage()) {
            blockExecutionInfo.setPrefetchBlocklet(false);
            LOGGER.info((Object)"Query prefetch is: false, read page by page");
        } else {
            LOGGER.info((Object)("Query prefetch is: " + queryModel.isPreFetchData()));
            blockExecutionInfo.setPrefetchBlocklet(queryModel.isPreFetchData());
        }
        boolean fgIndexPathPresent = false;
        for (TableBlockInfo blockInfo : queryModel.getTableBlockInfos()) {
            fgIndexPathPresent = blockInfo.getIndexWriterPath() != null;
            if (!fgIndexPathPresent) continue;
            queryModel.setDirectVectorFill(false);
            break;
        }
        blockExecutionInfo.setDirectVectorFill(queryModel.isDirectVectorFill());
        blockExecutionInfo.setTotalNumberOfMeasureToRead(segmentProperties.getMeasuresOrdinalToChunkMapping().size());
        blockExecutionInfo.setComplexDimensionInfoMap(QueryUtil.getComplexDimensionsMap(projectDimensions, segmentProperties.getDimensionOrdinalToChunkMapping(), this.queryProperties.complexFilterDimension));
        if (null != queryModel.getIndexFilter()) {
            FilterResolverIntf filterResolverIntf = !filePath.startsWith(queryModel.getTable().getTablePath()) ? queryModel.getIndexFilter().getExternalSegmentResolver() : queryModel.getIndexFilter().getResolver();
            blockExecutionInfo.setFilterExecuterTree(FilterUtil.getFilterExecuterTree(filterResolverIntf, segmentProperties, blockExecutionInfo.getComlexDimensionInfoMap(), false));
        }
        ArrayList<CarbonMeasure> expressionMeasures = new ArrayList<CarbonMeasure>(16);
        int numberOfElementToConsider = 0;
        LinkedHashSet<Integer> allProjectionListDimensionIdexes = new LinkedHashSet<Integer>();
        Set<CarbonDimension> currentBlockFilterDimensions = this.getCurrentBlockFilterDimensions(this.queryProperties.complexFilterDimension, segmentProperties);
        int[] dimensionChunkIndexes = QueryUtil.getDimensionChunkIndexes(projectDimensions, segmentProperties.getDimensionOrdinalToChunkMapping(), currentBlockFilterDimensions, allProjectionListDimensionIdexes);
        ReusableDataBuffer[] dimensionBuffer = new ReusableDataBuffer[projectDimensions.size()];
        for (int i = 0; i < dimensionBuffer.length; ++i) {
            dimensionBuffer[i] = new ReusableDataBuffer();
        }
        blockExecutionInfo.setDimensionReusableDataBuffer(dimensionBuffer);
        int numberOfColumnToBeReadInOneIO = Integer.parseInt(CarbonProperties.getInstance().getProperty("number.of.column.to.read.in.io", "10"));
        if (dimensionChunkIndexes.length > 0) {
            numberOfElementToConsider = dimensionChunkIndexes[dimensionChunkIndexes.length - 1] == segmentProperties.getBlockTodimensionOrdinalMapping().size() - 1 ? dimensionChunkIndexes.length - 1 : dimensionChunkIndexes.length;
            blockExecutionInfo.setAllSelectedDimensionColumnIndexRange(CarbonUtil.getRangeIndex(dimensionChunkIndexes, numberOfElementToConsider, numberOfColumnToBeReadInOneIO));
        } else {
            blockExecutionInfo.setAllSelectedDimensionColumnIndexRange(new int[0][0]);
        }
        Set<CarbonMeasure> filterMeasures = this.getCurrentBlockFilterMeasures(this.queryProperties.filterMeasures, segmentProperties);
        ArrayList<Integer> allProjectionListMeasureIndexes = new ArrayList<Integer>();
        int[] measureChunkIndexes = QueryUtil.getMeasureChunkIndexes(projectionMeasures, expressionMeasures, segmentProperties.getMeasuresOrdinalToChunkMapping(), filterMeasures, allProjectionListMeasureIndexes);
        ReusableDataBuffer[] measureBuffer = new ReusableDataBuffer[allProjectionListMeasureIndexes.size()];
        for (int i = 0; i < measureBuffer.length; ++i) {
            measureBuffer[i] = new ReusableDataBuffer();
        }
        blockExecutionInfo.setMeasureReusableDataBuffer(measureBuffer);
        if (measureChunkIndexes.length > 0) {
            numberOfElementToConsider = measureChunkIndexes[measureChunkIndexes.length - 1] == segmentProperties.getMeasures().size() - 1 ? measureChunkIndexes.length - 1 : measureChunkIndexes.length;
            blockExecutionInfo.setAllSelectedMeasureIndexRange(CarbonUtil.getRangeIndex(measureChunkIndexes, numberOfElementToConsider, numberOfColumnToBeReadInOneIO));
        } else {
            blockExecutionInfo.setAllSelectedMeasureIndexRange(new int[0][0]);
        }
        blockExecutionInfo.setProjectionListDimensionIndexes(ArrayUtils.toPrimitive((Integer[])allProjectionListDimensionIdexes.toArray(new Integer[allProjectionListDimensionIdexes.size()])));
        blockExecutionInfo.setProjectionListMeasureIndexes(ArrayUtils.toPrimitive((Integer[])allProjectionListMeasureIndexes.toArray(new Integer[allProjectionListMeasureIndexes.size()])));
        blockExecutionInfo.setFixedLengthKeySize(this.getKeySize(projectDimensions, segmentProperties));
        ArrayList<Integer> dictionaryColumnChunkIndex = new ArrayList<Integer>();
        ArrayList<Integer> noDictionaryColumnChunkIndex = new ArrayList<Integer>();
        QueryUtil.fillQueryDimensionChunkIndexes(projectDimensions, segmentProperties.getDimensionOrdinalToChunkMapping(), dictionaryColumnChunkIndex, noDictionaryColumnChunkIndex);
        int[] queryDictionaryColumnChunkIndexes = ArrayUtils.toPrimitive((Integer[])dictionaryColumnChunkIndex.toArray(new Integer[dictionaryColumnChunkIndex.size()]));
        if (!queryModel.isForcedDetailRawQuery()) {
            Arrays.sort(queryDictionaryColumnChunkIndexes);
        }
        blockExecutionInfo.setDictionaryColumnChunkIndex(queryDictionaryColumnChunkIndexes);
        blockExecutionInfo.setNoDictionaryColumnChunkIndexes(ArrayUtils.toPrimitive((Integer[])noDictionaryColumnChunkIndex.toArray(new Integer[noDictionaryColumnChunkIndex.size()])));
        blockExecutionInfo.setComplexColumnParentBlockIndexes(this.getComplexDimensionParentBlockIndexes(projectDimensions));
        blockExecutionInfo.setVectorBatchCollector(queryModel.isVectorReader());
        DataTypeUtil.setDataTypeConverter(queryModel.getConverter());
        blockExecutionInfo.setRequiredRowId(queryModel.isRequiredRowId());
        return blockExecutionInfo;
    }

    private int getKeySize(List<ProjectionDimension> queryDimension, SegmentProperties blockMetadataInfo) {
        HashSet<Integer> fixedLengthDimensionOrdinal = new HashSet<Integer>(16);
        int counter = 0;
        while (counter < queryDimension.size()) {
            if (queryDimension.get(counter).getDimension().getNumberOfChild() > 0) {
                counter += queryDimension.get(counter).getDimension().getNumberOfChild();
                continue;
            }
            if (queryDimension.get(counter).getDimension().getDataType() != DataTypes.DATE) {
                ++counter;
                continue;
            }
            fixedLengthDimensionOrdinal.add(blockMetadataInfo.getDimensionOrdinalToChunkMapping().get(queryDimension.get(counter).getDimension().getOrdinal()));
            ++counter;
        }
        int[] dictionaryColumnOrdinal = ArrayUtils.toPrimitive((Integer[])fixedLengthDimensionOrdinal.toArray(new Integer[fixedLengthDimensionOrdinal.size()]));
        if (blockMetadataInfo.getNumberOfDictDimensions() > 0) {
            int[] eachColumnValueSize = blockMetadataInfo.createDimColumnValueLength();
            int keySize = 0;
            for (int i = 0; i < dictionaryColumnOrdinal.length; ++i) {
                keySize += eachColumnValueSize[dictionaryColumnOrdinal[i]];
            }
            return keySize;
        }
        return 0;
    }

    private int[] getComplexDimensionParentBlockIndexes(List<ProjectionDimension> queryDimensions) {
        ArrayList<Integer> parentBlockIndexList = new ArrayList<Integer>();
        for (ProjectionDimension queryDimension : queryDimensions) {
            if (!queryDimension.getDimension().getDataType().isComplexType()) continue;
            if (null != queryDimension.getDimension().getComplexParentDimension()) {
                if (queryDimension.getDimension().isComplex().booleanValue()) {
                    parentBlockIndexList.add(queryDimension.getDimension().getOrdinal());
                    continue;
                }
                parentBlockIndexList.add(queryDimension.getParentDimension().getOrdinal());
                continue;
            }
            parentBlockIndexList.add(queryDimension.getDimension().getOrdinal());
        }
        return ArrayUtils.toPrimitive((Integer[])parentBlockIndexList.toArray(new Integer[parentBlockIndexList.size()]));
    }

    private Set<CarbonMeasure> getCurrentBlockFilterMeasures(Set<CarbonMeasure> queryFilterMeasures, SegmentProperties segmentProperties) {
        if (!queryFilterMeasures.isEmpty()) {
            HashSet<CarbonMeasure> updatedFilterMeasures = new HashSet<CarbonMeasure>(queryFilterMeasures.size());
            for (CarbonMeasure queryMeasure : queryFilterMeasures) {
                CarbonMeasure measureFromCurrentBlock = segmentProperties.getMeasureFromCurrentBlock(queryMeasure);
                if (null == measureFromCurrentBlock) continue;
                updatedFilterMeasures.add(measureFromCurrentBlock);
            }
            return updatedFilterMeasures;
        }
        return queryFilterMeasures;
    }

    private Set<CarbonDimension> getCurrentBlockFilterDimensions(Set<CarbonDimension> queryFilterDimensions, SegmentProperties segmentProperties) {
        if (!queryFilterDimensions.isEmpty()) {
            HashSet<CarbonDimension> updatedFilterDimensions = new HashSet<CarbonDimension>(queryFilterDimensions.size());
            for (CarbonDimension queryDimension : queryFilterDimensions) {
                CarbonDimension dimensionFromCurrentBlock = segmentProperties.getDimensionFromCurrentBlock(queryDimension);
                if (null == dimensionFromCurrentBlock) continue;
                updatedFilterDimensions.add(dimensionFromCurrentBlock);
            }
            return updatedFilterDimensions;
        }
        return queryFilterDimensions;
    }

    @Override
    public void finish() throws QueryExecutionException {
        CarbonUtil.clearBlockCache(this.queryProperties.dataBlocks);
        Throwable exceptionOccurred = null;
        if (null != this.queryIterator) {
            try {
                this.queryIterator.close();
            }
            catch (Throwable e) {
                exceptionOccurred = e;
            }
        }
        if (this.freeUnsafeMemory) {
            UnsafeMemoryManager.INSTANCE.freeMemoryAll(ThreadLocalTaskInfo.getCarbonTaskInfo().getTaskId());
            ThreadLocalTaskInfo.clearCarbonTaskInfo();
        }
        if (null != this.queryProperties.executorService) {
            this.queryProperties.executorService.shutdownNow();
        }
        if (null != exceptionOccurred) {
            throw new QueryExecutionException(exceptionOccurred);
        }
        DataTypeUtil.clearFormatter();
    }
}

