/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.executor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.complextypes.ArrayQueryType;
import org.apache.carbondata.core.scan.complextypes.ComplexQueryType;
import org.apache.carbondata.core.scan.complextypes.MapQueryType;
import org.apache.carbondata.core.scan.complextypes.PrimitiveQueryType;
import org.apache.carbondata.core.scan.complextypes.StructQueryType;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.format.PresenceMeta;
import org.apache.commons.lang3.ArrayUtils;

public class QueryUtil {
    public static int[] getDimensionChunkIndexes(List<ProjectionDimension> queryDimensions, Map<Integer, Integer> dimensionOrdinalToChunkMapping, Set<CarbonDimension> filterDimensions, Set<Integer> allProjectionListDimensionIndexes) {
        HashSet<Integer> dimensionChunkIndex = new HashSet<Integer>();
        Set<Integer> filterDimensionOrdinal = QueryUtil.getFilterDimensionOrdinal(filterDimensions);
        int chunkIndex = 0;
        for (int i = 0; i < queryDimensions.size(); ++i) {
            if (queryDimensions.get(i).getDimension().hasEncoding(Encoding.IMPLICIT)) continue;
            Integer dimensionOrdinal = queryDimensions.get(i).getDimension().getOrdinal();
            allProjectionListDimensionIndexes.add(dimensionOrdinalToChunkMapping.get(dimensionOrdinal));
            if (queryDimensions.get(i).getDimension().getNumberOfChild() > 0) {
                QueryUtil.addChildrenBlockIndex(allProjectionListDimensionIndexes, queryDimensions.get(i).getDimension());
            }
            if (filterDimensionOrdinal.contains(dimensionOrdinal)) continue;
            chunkIndex = dimensionOrdinalToChunkMapping.get(dimensionOrdinal);
            dimensionChunkIndex.add(chunkIndex);
            if (queryDimensions.get(i).getDimension().getNumberOfChild() <= 0) continue;
            QueryUtil.addChildrenBlockIndex(dimensionChunkIndex, queryDimensions.get(i).getDimension());
        }
        int[] dimensionIndex = ArrayUtils.toPrimitive((Integer[])dimensionChunkIndex.toArray(new Integer[dimensionChunkIndex.size()]));
        Arrays.sort(dimensionIndex);
        return dimensionIndex;
    }

    private static void addChildrenBlockIndex(Set<Integer> blockIndexes, CarbonDimension dimension) {
        for (int i = 0; i < dimension.getNumberOfChild(); ++i) {
            QueryUtil.addChildrenBlockIndex(blockIndexes, dimension.getListOfChildDimensions().get(i));
            blockIndexes.add(dimension.getListOfChildDimensions().get(i).getOrdinal());
        }
    }

    public static int[] getMeasureChunkIndexes(List<ProjectionMeasure> queryMeasures, List<CarbonMeasure> expressionMeasure, Map<Integer, Integer> ordinalToBlockIndexMapping, Set<CarbonMeasure> filterMeasures, List<Integer> allProjectionListMeasureIdexes) {
        int i;
        HashSet<Integer> measureChunkIndex = new HashSet<Integer>();
        Set<Integer> filterMeasureOrdinal = QueryUtil.getFilterMeasureOrdinal(filterMeasures);
        for (i = 0; i < queryMeasures.size(); ++i) {
            Integer measureOrdinal = queryMeasures.get(i).getMeasure().getOrdinal();
            allProjectionListMeasureIdexes.add(measureOrdinal);
            if (filterMeasureOrdinal.contains(measureOrdinal)) continue;
            measureChunkIndex.add(ordinalToBlockIndexMapping.get(measureOrdinal));
        }
        for (i = 0; i < expressionMeasure.size(); ++i) {
            measureChunkIndex.add(ordinalToBlockIndexMapping.get(expressionMeasure.get(i).getOrdinal()));
        }
        int[] measureIndexes = ArrayUtils.toPrimitive((Integer[])measureChunkIndex.toArray(new Integer[measureChunkIndex.size()]));
        Arrays.sort(measureIndexes);
        return measureIndexes;
    }

    public static byte[] getSortDimensionIndexes(List<ProjectionDimension> sortedDimensions, List<ProjectionDimension> queryDimensions) {
        byte[] sortedDims = new byte[queryDimensions.size()];
        int indexOf = 0;
        for (int i = 0; i < sortedDims.length; ++i) {
            indexOf = sortedDimensions.indexOf(queryDimensions.get(i));
            if (indexOf <= -1) continue;
            sortedDims[i] = 1;
        }
        return sortedDims;
    }

    public static boolean searchInArray(int[] data, int key) {
        for (int i = 0; i < data.length; ++i) {
            if (key != data[i]) continue;
            return true;
        }
        return false;
    }

    public static byte[] getMaskedKey(byte[] data, byte[] maxKey, int[] maskByteRanges, int byteCount) {
        byte[] maskedKey = new byte[byteCount];
        int counter = 0;
        int byteRange = 0;
        for (int i = 0; i < byteCount; ++i) {
            byteRange = maskByteRanges[i];
            if (byteRange == -1) continue;
            maskedKey[counter++] = (byte)(data[byteRange] & maxKey[byteRange]);
        }
        return maskedKey;
    }

    public static void fillQueryDimensionChunkIndexes(List<ProjectionDimension> projectDimensions, Map<Integer, Integer> columnOrdinalToChunkIndexMapping, List<Integer> dictionaryDimensionChunkIndex, List<Integer> noDictionaryDimensionChunkIndex) {
        for (ProjectionDimension queryDimension : projectDimensions) {
            if (queryDimension.getDimension().getDataType() == DataTypes.DATE) {
                dictionaryDimensionChunkIndex.add(columnOrdinalToChunkIndexMapping.get(queryDimension.getDimension().getOrdinal()));
                continue;
            }
            if (CarbonUtil.hasEncoding(queryDimension.getDimension().getEncoder(), Encoding.IMPLICIT) || queryDimension.getDimension().getNumberOfChild() != 0) continue;
            noDictionaryDimensionChunkIndex.add(columnOrdinalToChunkIndexMapping.get(queryDimension.getDimension().getOrdinal()));
        }
    }

    public static Map<Integer, GenericQueryType> getComplexDimensionsMap(List<ProjectionDimension> queryDimensions, Map<Integer, Integer> dimensionToBlockIndexMap, Set<CarbonDimension> filterDimensions) {
        HashMap<Integer, GenericQueryType> complexTypeMap = new HashMap<Integer, GenericQueryType>();
        for (ProjectionDimension dimension : queryDimensions) {
            CarbonDimension actualDimension;
            CarbonDimension complexDimension = null;
            if (null != dimension.getDimension().getComplexParentDimension()) {
                actualDimension = dimension.getParentDimension();
                if (dimension.getDimension().isComplex().booleanValue()) {
                    complexDimension = dimension.getDimension();
                }
            } else {
                actualDimension = dimension.getDimension();
            }
            if (actualDimension.getNumberOfChild() == 0) continue;
            if (complexDimension != null) {
                QueryUtil.fillParentDetails(dimensionToBlockIndexMap, complexDimension, complexTypeMap);
            }
            QueryUtil.fillParentDetails(dimensionToBlockIndexMap, actualDimension, complexTypeMap);
        }
        if (null != filterDimensions) {
            for (CarbonDimension filterDimension : filterDimensions) {
                if (filterDimension.hasEncoding(Encoding.IMPLICIT) || filterDimension.getNumberOfChild() == 0) continue;
                QueryUtil.fillParentDetails(dimensionToBlockIndexMap, filterDimension, complexTypeMap);
            }
        }
        return complexTypeMap;
    }

    private static void fillParentDetails(Map<Integer, Integer> dimensionToBlockIndexMap, CarbonDimension dimension, Map<Integer, GenericQueryType> complexTypeMap) {
        ComplexQueryType parentQueryType;
        int parentBlockIndex = dimensionToBlockIndexMap.get(dimension.getOrdinal());
        if (DataTypes.isArrayType(dimension.getDataType())) {
            parentQueryType = new ArrayQueryType(dimension.getColName(), dimension.getColName(), parentBlockIndex);
        } else if (DataTypes.isStructType(dimension.getDataType())) {
            parentQueryType = new StructQueryType(dimension.getColName(), dimension.getColName(), dimensionToBlockIndexMap.get(dimension.getOrdinal()));
        } else if (DataTypes.isMapType(dimension.getDataType())) {
            parentQueryType = new MapQueryType(dimension.getColName(), dimension.getColName(), parentBlockIndex);
        } else {
            throw new UnsupportedOperationException(dimension.getDataType().getName() + " is not supported");
        }
        complexTypeMap.put(dimension.getOrdinal(), (GenericQueryType)((Object)parentQueryType));
        QueryUtil.fillChildrenDetails(parentBlockIndex, dimension, parentQueryType);
    }

    private static int fillChildrenDetails(int parentColumnIndex, CarbonDimension dimension, GenericQueryType parentQueryType) {
        for (int i = 0; i < dimension.getNumberOfChild(); ++i) {
            DataType dataType = dimension.getListOfChildDimensions().get(i).getDataType();
            if (DataTypes.isArrayType(dataType)) {
                parentQueryType.addChildren(new ArrayQueryType(dimension.getListOfChildDimensions().get(i).getColName(), dimension.getColName(), ++parentColumnIndex));
            } else if (DataTypes.isStructType(dataType)) {
                parentQueryType.addChildren(new StructQueryType(dimension.getListOfChildDimensions().get(i).getColName(), dimension.getColName(), ++parentColumnIndex));
            } else if (DataTypes.isMapType(dataType)) {
                parentQueryType.addChildren(new MapQueryType(dimension.getListOfChildDimensions().get(i).getColName(), dimension.getColName(), ++parentColumnIndex));
            } else {
                boolean isDirectDictionary = CarbonUtil.hasEncoding(dimension.getListOfChildDimensions().get(i).getEncoder(), Encoding.DIRECT_DICTIONARY);
                parentQueryType.addChildren(new PrimitiveQueryType(dimension.getListOfChildDimensions().get(i).getColName(), dimension.getColName(), ++parentColumnIndex, dimension.getListOfChildDimensions().get(i).getDataType(), isDirectDictionary));
            }
            if (dimension.getListOfChildDimensions().get(i).getNumberOfChild() <= 0) continue;
            parentColumnIndex = QueryUtil.fillChildrenDetails(parentColumnIndex, dimension.getListOfChildDimensions().get(i), parentQueryType);
        }
        return parentColumnIndex;
    }

    public static void getAllFilterDimensionsAndMeasures(FilterResolverIntf filterResolverTree, Set<CarbonDimension> filterDimensions, Set<CarbonMeasure> filterMeasure) {
        if (null == filterResolverTree) {
            return;
        }
        ArrayList dimensionResolvedInfos = new ArrayList();
        Expression filterExpression = filterResolverTree.getFilterExpression();
        QueryUtil.addColumnDimensions(filterExpression, filterDimensions, filterMeasure);
        for (ColumnExpression info : dimensionResolvedInfos) {
            if (!info.isDimension() || info.getDimension().getNumberOfChild() <= 0) continue;
            filterDimensions.add(info.getDimension());
        }
    }

    private static void addColumnDimensions(Expression expression, Set<CarbonDimension> filterDimensions, Set<CarbonMeasure> filterMeasure) {
        if (null != expression && expression instanceof ColumnExpression) {
            if (((ColumnExpression)expression).isDimension()) {
                filterDimensions.add(((ColumnExpression)expression).getDimension());
            } else {
                filterMeasure.add((CarbonMeasure)((ColumnExpression)expression).getCarbonColumn());
            }
            return;
        }
        if (null != expression) {
            for (Expression child : expression.getChildren()) {
                QueryUtil.addColumnDimensions(child, filterDimensions, filterMeasure);
            }
        }
    }

    private static Set<Integer> getFilterMeasureOrdinal(Set<CarbonMeasure> filterMeasures) {
        HashSet<Integer> filterMeasuresOrdinal = new HashSet<Integer>();
        for (CarbonMeasure filterMeasure : filterMeasures) {
            filterMeasuresOrdinal.add(filterMeasure.getOrdinal());
        }
        return filterMeasuresOrdinal;
    }

    private static Set<Integer> getFilterDimensionOrdinal(Set<CarbonDimension> filterDimensions) {
        HashSet<Integer> filterDimensionsOrdinal = new HashSet<Integer>();
        for (CarbonDimension filterDimension : filterDimensions) {
            filterDimensionsOrdinal.add(filterDimension.getOrdinal());
            QueryUtil.getChildDimensionOrdinal(filterDimension, filterDimensionsOrdinal);
        }
        return filterDimensionsOrdinal;
    }

    private static void getChildDimensionOrdinal(CarbonDimension queryDimensions, Set<Integer> filterDimensionsOrdinal) {
        for (int j = 0; j < queryDimensions.getNumberOfChild(); ++j) {
            CarbonDimension dimension = queryDimensions.getListOfChildDimensions().get(j);
            if (dimension.getNumberOfChild() > 0) {
                QueryUtil.getChildDimensionOrdinal(queryDimensions.getListOfChildDimensions().get(j), filterDimensionsOrdinal);
                continue;
            }
            if (dimension.getDataType() == DataTypes.DATE) continue;
            filterDimensionsOrdinal.add(queryDimensions.getListOfChildDimensions().get(j).getOrdinal());
        }
    }

    public static BitSet getNullBitSet(PresenceMeta presentMetadataThrift, Compressor compressor) {
        byte[] present_bit_stream = presentMetadataThrift.getPresent_bit_stream();
        if (null != present_bit_stream) {
            return BitSet.valueOf(compressor.unCompressByte(present_bit_stream));
        }
        return new BitSet(1);
    }

    public static void updateColumnUniqueIdForNonTransactionTable(List<ColumnSchema> columnSchemas) {
        for (ColumnSchema columnSchema : columnSchemas) {
            int index = columnSchema.getColumnName().lastIndexOf(".");
            if (index >= 0) {
                columnSchema.setColumnUniqueId(columnSchema.getColumnName().substring(index + 1, columnSchema.getColumnName().length()));
                continue;
            }
            columnSchema.setColumnUniqueId(columnSchema.getColumnName());
        }
    }

    public static void putDataToVector(CarbonColumnVector vector, byte[] value, int vectorRow, int length) {
        DataType dt = vector.getType();
        if (dt != DataTypes.STRING && length == 0 || ByteUtil.UnsafeComparer.INSTANCE.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, 0, CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length, value, 0, length)) {
            vector.putNull(vectorRow);
        } else if (dt == DataTypes.STRING) {
            vector.putByteArray(vectorRow, 0, length, value);
        } else if (dt == DataTypes.BOOLEAN) {
            vector.putBoolean(vectorRow, ByteUtil.toBoolean(value[0]));
        } else if (dt == DataTypes.BYTE) {
            vector.putByte(vectorRow, value[0]);
        } else if (dt == DataTypes.SHORT) {
            vector.putShort(vectorRow, ByteUtil.toXorShort(value, 0, length));
        } else if (dt == DataTypes.INT) {
            vector.putInt(vectorRow, ByteUtil.toXorInt(value, 0, length));
        } else if (dt == DataTypes.LONG) {
            vector.putLong(vectorRow, DataTypeUtil.getDataBasedOnRestructuredDataType(value, vector.getBlockDataType(), 0, length));
        } else if (dt == DataTypes.TIMESTAMP) {
            vector.putLong(vectorRow, ByteUtil.toXorLong(value, 0, length) * 1000L);
        }
    }

    public static BlockletDetailInfo getBlockletDetailInfo(DataFileFooter fileFooter, TableBlockInfo blockInfo) {
        BlockletDetailInfo detailInfo = new BlockletDetailInfo();
        detailInfo.setBlockletInfoBinary(new byte[0]);
        detailInfo.setColumnSchemas(fileFooter.getColumnInTable());
        detailInfo.setBlockletId((short)-1);
        detailInfo.setRowCount((int)fileFooter.getNumberOfRows());
        detailInfo.setSchemaUpdatedTimeStamp(fileFooter.getSchemaUpdatedTimeStamp());
        detailInfo.setBlockFooterOffset(blockInfo.getBlockOffset());
        detailInfo.setBlockSize(blockInfo.getBlockLength());
        detailInfo.setUseMinMaxForPruning(true);
        detailInfo.setVersionNumber(blockInfo.getVersion().number());
        return detailInfo;
    }
}

