/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.executor.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.executor.infos.DimensionInfo;
import org.apache.carbondata.core.scan.executor.infos.MeasureInfo;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.commons.lang3.ArrayUtils;

public class RestructureUtil {
    public static List<ProjectionDimension> createDimensionInfoAndGetCurrentBlockQueryDimension(BlockExecutionInfo blockExecutionInfo, ProjectionDimension[] queryDimensions, List<CarbonDimension> tableBlockDimensions, List<CarbonDimension> tableComplexDimension, int measureCount, boolean isTransactionalTable) {
        ArrayList<ProjectionDimension> presentDimension = new ArrayList<ProjectionDimension>(16);
        boolean[] isDimensionExists = new boolean[queryDimensions.length];
        Object[] defaultValues = new Object[queryDimensions.length];
        DimensionInfo dimensionInfo = new DimensionInfo(isDimensionExists, defaultValues);
        dimensionInfo.dataType = new DataType[queryDimensions.length + measureCount];
        int newDictionaryColumnCount = 0;
        int newNoDictionaryColumnCount = 0;
        int dimIndex = 0;
        for (ProjectionDimension queryDimension : queryDimensions) {
            if (queryDimension.getDimension().hasEncoding(Encoding.IMPLICIT)) {
                presentDimension.add(queryDimension);
                isDimensionExists[dimIndex] = true;
                dimensionInfo.dataType[queryDimension.getOrdinal()] = queryDimension.getDimension().getDataType();
            } else {
                ProjectionDimension currentBlockDimension;
                for (CarbonDimension tableDimension : tableBlockDimensions) {
                    if (!RestructureUtil.isColumnMatches(isTransactionalTable, queryDimension.getDimension(), tableDimension)) continue;
                    currentBlockDimension = new ProjectionDimension(tableDimension);
                    tableDimension.getColumnSchema().setPrecision(queryDimension.getDimension().getColumnSchema().getPrecision());
                    tableDimension.getColumnSchema().setScale(queryDimension.getDimension().getColumnSchema().getScale());
                    tableDimension.getColumnSchema().setDefaultValue(queryDimension.getDimension().getDefaultValue());
                    currentBlockDimension.setOrdinal(queryDimension.getOrdinal());
                    presentDimension.add(currentBlockDimension);
                    isDimensionExists[dimIndex] = true;
                    dimensionInfo.dataType[currentBlockDimension.getOrdinal()] = currentBlockDimension.getDimension().getDataType();
                    break;
                }
                if (isDimensionExists[dimIndex]) {
                    ++dimIndex;
                    continue;
                }
                for (CarbonDimension tableDimension : tableComplexDimension) {
                    if (!RestructureUtil.isColumnMatches(isTransactionalTable, queryDimension.getDimension(), tableDimension)) continue;
                    currentBlockDimension = null;
                    currentBlockDimension = null != queryDimension.getDimension().getComplexParentDimension() ? new ProjectionDimension(queryDimension.getDimension()) : new ProjectionDimension(tableDimension);
                    currentBlockDimension.setOrdinal(queryDimension.getOrdinal());
                    presentDimension.add(currentBlockDimension);
                    isDimensionExists[dimIndex] = true;
                    dimensionInfo.dataType[currentBlockDimension.getOrdinal()] = currentBlockDimension.getDimension().getDataType();
                    break;
                }
                if (!isDimensionExists[dimIndex]) {
                    defaultValues[dimIndex] = RestructureUtil.validateAndGetDefaultValue(queryDimension.getDimension());
                    blockExecutionInfo.setRestructuredBlock(true);
                    if (queryDimension.getDimension().getDataType() == DataTypes.DATE) {
                        dimensionInfo.setDictionaryColumnAdded(true);
                        ++newDictionaryColumnCount;
                    } else {
                        dimensionInfo.setNoDictionaryColumnAdded(true);
                        ++newNoDictionaryColumnCount;
                    }
                }
            }
            ++dimIndex;
        }
        dimensionInfo.setNewDictionaryColumnCount(newDictionaryColumnCount);
        dimensionInfo.setNewNoDictionaryColumnCount(newNoDictionaryColumnCount);
        blockExecutionInfo.setDimensionInfo(dimensionInfo);
        return presentDimension;
    }

    public static boolean isColumnMatches(boolean isTransactionalTable, CarbonColumn queryColumn, CarbonColumn tableColumn) {
        if (tableColumn.getDataType().isComplexType() && tableColumn.getDataType().getId() != 11) {
            if (tableColumn.getColumnId().equalsIgnoreCase(queryColumn.getColumnId()) || tableColumn.isColmatchBasedOnId(queryColumn)) {
                return true;
            }
            return RestructureUtil.isColumnMatchesStruct(tableColumn, queryColumn);
        }
        return tableColumn.getColumnId().equalsIgnoreCase(queryColumn.getColumnId()) || !isTransactionalTable && tableColumn.getColName().equalsIgnoreCase(queryColumn.getColName()) || tableColumn.isColmatchBasedOnId(queryColumn);
    }

    private static boolean isColumnMatchesStruct(CarbonColumn tableColumn, CarbonColumn queryColumn) {
        if (tableColumn instanceof CarbonDimension) {
            List<CarbonDimension> parentDimension = ((CarbonDimension)tableColumn).getListOfChildDimensions();
            CarbonDimension carbonDimension = null;
            String[] colSplits = queryColumn.getColName().split("\\.");
            StringBuffer tempColName = new StringBuffer(colSplits[0]);
            for (String colSplit : colSplits) {
                if (!tempColName.toString().equalsIgnoreCase(colSplit)) {
                    tempColName = tempColName.append(".").append(colSplit);
                }
                if ((carbonDimension = CarbonTable.getCarbonDimension(tempColName.toString(), parentDimension)) == null) continue;
                if (carbonDimension.getColumnSchema().getColumnUniqueId().equalsIgnoreCase(queryColumn.getColumnId()) || carbonDimension.getColumnSchema().getColumnUniqueId().equalsIgnoreCase(carbonDimension.getColName()) && carbonDimension.getColName().equalsIgnoreCase(queryColumn.getColName())) {
                    return true;
                }
                if (carbonDimension.getListOfChildDimensions() == null) continue;
                parentDimension = carbonDimension.getListOfChildDimensions();
            }
        }
        return false;
    }

    public static Object validateAndGetDefaultValue(CarbonDimension queryDimension) {
        byte[] defaultValue = queryDimension.getDefaultValue();
        Object defaultValueToBeConsidered = null;
        defaultValueToBeConsidered = queryDimension.getDataType() == DataTypes.DATE ? RestructureUtil.getDirectDictionaryDefaultValue(queryDimension.getDataType(), queryDimension.getDefaultValue()) : RestructureUtil.getNoDictionaryDefaultValue(queryDimension.getDataType(), defaultValue);
        return defaultValueToBeConsidered;
    }

    public static Object getDirectDictionaryDefaultValue(DataType dataType, byte[] defaultValue) {
        DirectDictionaryGenerator directDictionaryGenerator;
        Object directDictionaryDefaultValue = null;
        if (!RestructureUtil.isDefaultValueNull(defaultValue) && (directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(dataType)) != null) {
            String value = new String(defaultValue, Charset.forName("UTF-8"));
            directDictionaryDefaultValue = directDictionaryGenerator.getValueFromSurrogate(Integer.parseInt(value));
        }
        return directDictionaryDefaultValue;
    }

    private static Object getNoDictionaryDefaultValue(DataType datatype, byte[] defaultValue) {
        Object noDictionaryDefaultValue = null;
        String value = null;
        if (!RestructureUtil.isDefaultValueNull(defaultValue)) {
            if (datatype == DataTypes.INT) {
                value = new String(defaultValue, Charset.forName("UTF-8"));
                noDictionaryDefaultValue = Integer.parseInt(value);
            } else if (datatype == DataTypes.LONG) {
                value = new String(defaultValue, Charset.forName("UTF-8"));
                noDictionaryDefaultValue = Long.parseLong(value);
            } else if (datatype == DataTypes.TIMESTAMP) {
                long timestampValue = ByteUtil.toXorLong(defaultValue, 0, defaultValue.length);
                noDictionaryDefaultValue = timestampValue * 1000L;
            } else {
                noDictionaryDefaultValue = DataTypeUtil.getDataTypeConverter().convertFromByteToUTF8Bytes(defaultValue);
            }
        }
        return noDictionaryDefaultValue;
    }

    private static boolean isDefaultValueNull(byte[] defaultValue) {
        return null == defaultValue;
    }

    public static Object getMeasureDefaultValue(ColumnSchema columnSchema, byte[] defaultValue) {
        Comparable<Short> measureDefaultValue = null;
        if (!RestructureUtil.isDefaultValueNull(defaultValue)) {
            DataType dataType = columnSchema.getDataType();
            if (dataType == DataTypes.SHORT) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Short.valueOf(value);
            } else if (dataType == DataTypes.LONG) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Long.parseLong(value);
            } else if (dataType == DataTypes.INT) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Integer.parseInt(value);
            } else if (dataType == DataTypes.BOOLEAN) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Boolean.valueOf(value);
            } else if (DataTypes.isDecimal(dataType)) {
                BigDecimal decimal = DataTypeUtil.byteToBigDecimal(defaultValue);
                if (columnSchema.getScale() > decimal.scale()) {
                    decimal = decimal.setScale(columnSchema.getScale(), RoundingMode.HALF_UP);
                }
                measureDefaultValue = decimal;
            } else {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                Double parsedValue = Double.valueOf(value);
                if (!Double.isInfinite(parsedValue) && !Double.isNaN(parsedValue)) {
                    measureDefaultValue = parsedValue;
                }
            }
        }
        return measureDefaultValue;
    }

    public static Object getMeasureDefaultValueByType(ColumnSchema columnSchema, byte[] defaultValue) {
        Comparable<Short> measureDefaultValue = null;
        if (!RestructureUtil.isDefaultValueNull(defaultValue)) {
            DataType dataType = columnSchema.getDataType();
            if (dataType == DataTypes.SHORT) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Short.parseShort(value);
            } else if (dataType == DataTypes.INT) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Integer.parseInt(value);
            } else if (dataType == DataTypes.LONG) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Long.parseLong(value);
            } else if (dataType == DataTypes.BOOLEAN) {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                measureDefaultValue = Boolean.valueOf(value);
            } else if (DataTypes.isDecimal(dataType)) {
                BigDecimal decimal = DataTypeUtil.byteToBigDecimal(defaultValue);
                if (columnSchema.getScale() > decimal.scale()) {
                    decimal = decimal.setScale(columnSchema.getScale(), RoundingMode.HALF_UP);
                }
                measureDefaultValue = decimal;
            } else {
                String value = new String(defaultValue, Charset.forName("UTF-8"));
                Double parsedValue = Double.valueOf(value);
                if (!Double.isInfinite(parsedValue) && !Double.isNaN(parsedValue)) {
                    measureDefaultValue = parsedValue;
                }
            }
        }
        return measureDefaultValue;
    }

    public static List<ProjectionMeasure> createMeasureInfoAndGetCurrentBlockQueryMeasures(BlockExecutionInfo blockExecutionInfo, ProjectionMeasure[] queryMeasures, List<CarbonMeasure> currentBlockMeasures, boolean isTransactionalTable) {
        MeasureInfo measureInfo = new MeasureInfo();
        ArrayList<ProjectionMeasure> presentMeasure = new ArrayList<ProjectionMeasure>(queryMeasures.length);
        int numberOfMeasureInQuery = queryMeasures.length;
        ArrayList<Integer> measureOrdinalList = new ArrayList<Integer>(numberOfMeasureInQuery);
        Object[] defaultValues = new Object[numberOfMeasureInQuery];
        boolean[] measureExistsInCurrentBlock = new boolean[numberOfMeasureInQuery];
        DataType[] measureDataTypes = new DataType[numberOfMeasureInQuery];
        int index = 0;
        for (ProjectionMeasure queryMeasure : queryMeasures) {
            for (CarbonMeasure carbonMeasure : currentBlockMeasures) {
                if (!RestructureUtil.isColumnMatches(isTransactionalTable, queryMeasure.getMeasure(), carbonMeasure)) continue;
                ProjectionMeasure currentBlockMeasure = new ProjectionMeasure(carbonMeasure);
                carbonMeasure.getColumnSchema().setDataType(queryMeasure.getMeasure().getDataType());
                carbonMeasure.getColumnSchema().setPrecision(queryMeasure.getMeasure().getPrecision());
                carbonMeasure.getColumnSchema().setScale(queryMeasure.getMeasure().getScale());
                carbonMeasure.getColumnSchema().setDefaultValue(queryMeasure.getMeasure().getDefaultValue());
                currentBlockMeasure.setOrdinal(queryMeasure.getOrdinal());
                presentMeasure.add(currentBlockMeasure);
                measureOrdinalList.add(carbonMeasure.getOrdinal());
                measureExistsInCurrentBlock[index] = true;
                measureDataTypes[index] = carbonMeasure.getDataType();
                break;
            }
            if (!measureExistsInCurrentBlock[index]) {
                defaultValues[index] = RestructureUtil.getMeasureDefaultValue(queryMeasure.getMeasure().getColumnSchema(), queryMeasure.getMeasure().getDefaultValue());
                measureDataTypes[index] = queryMeasure.getMeasure().getDataType();
                blockExecutionInfo.setRestructuredBlock(true);
            }
            ++index;
        }
        int[] measureOrdinals = ArrayUtils.toPrimitive((Integer[])measureOrdinalList.toArray(new Integer[measureOrdinalList.size()]));
        measureInfo.setDefaultValues(defaultValues);
        measureInfo.setMeasureOrdinals(measureOrdinals);
        measureInfo.setMeasureExists(measureExistsInCurrentBlock);
        measureInfo.setMeasureDataTypes(measureDataTypes);
        blockExecutionInfo.setMeasureInfo(measureInfo);
        return presentMeasure;
    }

    public static void actualProjectionOfSegment(BlockExecutionInfo blockExecutionInfo, QueryModel queryModel, SegmentProperties segmentProperties) {
        List<ProjectionDimension> projectionDimensions = queryModel.getProjectionDimensions();
        List<ProjectionMeasure> projectionMeasures = queryModel.getProjectionMeasures();
        if (queryModel.getTable().hasColumnDrift()) {
            List<CarbonMeasure> tableBlockMeasures = segmentProperties.getMeasures();
            ArrayList<ProjectionMeasure> updatedProjectionMeasures = new ArrayList<ProjectionMeasure>(projectionMeasures.size() + tableBlockMeasures.size());
            updatedProjectionMeasures.addAll(projectionMeasures);
            ArrayList<ProjectionDimension> updatedProjectionDimensions = new ArrayList<ProjectionDimension>(projectionDimensions.size());
            for (ProjectionDimension projectionDimension : projectionDimensions) {
                CarbonMeasure carbonMeasure = null;
                for (CarbonMeasure tableBlockMeasure : tableBlockMeasures) {
                    if (!RestructureUtil.isColumnMatches(queryModel.getTable().isTransactionalTable(), projectionDimension.getDimension(), tableBlockMeasure)) continue;
                    carbonMeasure = tableBlockMeasure;
                    break;
                }
                if (carbonMeasure != null) {
                    ProjectionMeasure projectionMeasure = new ProjectionMeasure(carbonMeasure);
                    projectionMeasure.setOrdinal(projectionDimension.getOrdinal());
                    updatedProjectionMeasures.add(projectionMeasure);
                    continue;
                }
                updatedProjectionDimensions.add(projectionDimension);
            }
            blockExecutionInfo.setActualQueryDimensions(updatedProjectionDimensions.toArray(new ProjectionDimension[updatedProjectionDimensions.size()]));
            blockExecutionInfo.setActualQueryMeasures(updatedProjectionMeasures.toArray(new ProjectionMeasure[updatedProjectionMeasures.size()]));
        } else {
            blockExecutionInfo.setActualQueryDimensions(projectionDimensions.toArray(new ProjectionDimension[projectionDimensions.size()]));
            blockExecutionInfo.setActualQueryMeasures(projectionMeasures.toArray(new ProjectionMeasure[projectionMeasures.size()]));
        }
    }

    public static boolean hasColumnDriftOnSegment(CarbonTable table, SegmentProperties segmentProperties) {
        for (CarbonDimension queryColumn : table.getColumnDrift()) {
            for (CarbonMeasure tableColumn : segmentProperties.getMeasures()) {
                if (!RestructureUtil.isColumnMatches(table.isTransactionalTable(), queryColumn, tableColumn)) continue;
                return true;
            }
        }
        return false;
    }
}

