/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.LeafExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class ColumnExpression
extends LeafExpression {
    private static final long serialVersionUID = 1L;
    private String columnName;
    private boolean isDimension;
    private boolean isMeasure;
    private int colIndex = -1;
    private DataType dataType;
    private CarbonDimension dimension;
    private CarbonMeasure measure;
    private CarbonColumn carbonColumn;

    public ColumnExpression(String columnName, DataType dataType) {
        this.columnName = columnName;
        this.dataType = dataType;
    }

    public CarbonDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(CarbonDimension dimension) {
        this.dimension = dimension;
    }

    public CarbonMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(CarbonMeasure measure) {
        this.measure = measure;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public void setDimension(boolean isDimension) {
        this.isDimension = isDimension;
    }

    public boolean isMeasure() {
        return this.isMeasure;
    }

    public void setMeasure(boolean isMeasure) {
        this.isMeasure = isMeasure;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(int colIndex) {
        this.colIndex = colIndex;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void reset() {
        this.dimension = null;
        this.measure = null;
        this.isDimension = false;
        this.isMeasure = false;
        this.carbonColumn = null;
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) {
        return new ExpressionResult(this.dataType, null == value ? null : value.getVal(this.colIndex));
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return null;
    }

    @Override
    public String getString() {
        return "ColumnExpression(" + this.columnName + ')';
    }

    @Override
    public String getStatement() {
        return this.columnName;
    }

    public CarbonColumn getCarbonColumn() {
        return this.carbonColumn;
    }

    public void setCarbonColumn(CarbonColumn carbonColumn) {
        this.carbonColumn = carbonColumn;
    }

    @Override
    public void findAndSetChild(Expression oldExpr, Expression newExpr) {
    }
}

