/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.util.CarbonUtil;

public class ExpressionResult
implements Comparable<ExpressionResult> {
    protected DataType dataType;
    protected Object value;
    private List<ExpressionResult> expressionResults;
    private boolean isLiteral = false;

    public ExpressionResult(DataType dataType, Object value) {
        this.dataType = dataType;
        this.value = value;
    }

    public ExpressionResult(DataType dataType, Object value, boolean isLiteral) {
        this(dataType, value);
        this.isLiteral = isLiteral;
    }

    public ExpressionResult(List<ExpressionResult> expressionResults) {
        this.expressionResults = expressionResults;
    }

    public void set(DataType dataType, Object value) {
        this.dataType = dataType;
        this.value = value;
        this.expressionResults = null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Integer getInt() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                try {
                    return Integer.parseInt(this.value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FilterIllegalMemberException(e);
                }
            }
            if (dataType == DataTypes.SHORT) {
                return ((Short)this.value).intValue();
            }
            if (dataType == DataTypes.INT || dataType == DataTypes.DOUBLE) {
                if (this.value instanceof Double) {
                    return ((Double)this.value).intValue();
                }
                if (this.value instanceof Long) {
                    return ((Long)this.value).intValue();
                }
                return (Integer)this.value;
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return (int)((Date)this.value).getTime();
                }
                return (Integer)this.value;
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof Timestamp) {
                    return (int)((Timestamp)this.value).getTime();
                }
                if (this.isLiteral) {
                    Long l = (Long)this.value / 1000L;
                    return l.intValue();
                }
                return (Integer)this.value;
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to integer type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Integer type value");
        }
    }

    public Short getShort() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                try {
                    return Short.parseShort(this.value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FilterIllegalMemberException(e);
                }
            }
            if (dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.DOUBLE) {
                if (this.value instanceof Double) {
                    return ((Double)this.value).shortValue();
                }
                if (this.value instanceof Integer) {
                    return ((Integer)this.value).shortValue();
                }
                return (Short)this.value;
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return (short)((Date)this.value).getTime();
                }
                return (Short)this.value;
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof Timestamp) {
                    return (short)((Timestamp)this.value).getTime();
                }
                if (this.isLiteral) {
                    Long l = (Long)this.value / 1000L;
                    return l.shortValue();
                }
                return (Short)this.value;
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to integer type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Integer type value");
        }
    }

    public String getString() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.DATE || dataType == DataTypes.TIMESTAMP) {
                String format = CarbonUtil.getFormatFromProperty(this.getDataType());
                SimpleDateFormat parser = new SimpleDateFormat(format);
                if (this.getDataType() == DataTypes.DATE) {
                    parser.setTimeZone(TimeZone.getTimeZone("GMT"));
                }
                if (this.value instanceof Timestamp) {
                    return parser.format((Timestamp)this.value);
                }
                if (this.value instanceof Date) {
                    return parser.format((Date)this.value);
                }
                if (this.value instanceof Long) {
                    if (this.isLiteral) {
                        return parser.format(new Timestamp((Long)this.value / 1000L));
                    }
                    return parser.format(new Timestamp((Long)this.value));
                }
                if (this.value instanceof Integer) {
                    long date = (long)((Integer)this.value).intValue() * 86400000L;
                    return parser.format(new Date(date));
                }
                return this.value.toString();
            }
            return this.value.toString();
        }
        catch (Exception e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to String type value");
        }
    }

    public Double getDouble() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                try {
                    return Double.parseDouble(this.value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FilterIllegalMemberException(e);
                }
            }
            if (dataType == DataTypes.SHORT) {
                return ((Short)this.value).doubleValue();
            }
            if (dataType == DataTypes.INT) {
                return ((Integer)this.value).doubleValue();
            }
            if (dataType == DataTypes.LONG) {
                return ((Long)this.value).doubleValue();
            }
            if (dataType == DataTypes.DOUBLE) {
                return (Double)this.value;
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return ((Date)this.value).getTime();
                }
                return (Double)this.value;
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof Timestamp) {
                    return ((Timestamp)this.value).getTime();
                }
                if (this.isLiteral) {
                    Long l = (Long)this.value / 1000L;
                    return l.doubleValue();
                }
                return (Double)this.value;
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to double type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Double type value");
        }
    }

    public Long getLong() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                try {
                    return Long.parseLong(this.value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FilterIllegalMemberException(e);
                }
            }
            if (dataType == DataTypes.SHORT) {
                return ((Short)this.value).longValue();
            }
            if (dataType == DataTypes.INT) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.LONG) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.DOUBLE) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return ((Date)this.value).getTime();
                }
                return (Long)this.value;
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof Timestamp) {
                    return ((Timestamp)this.value).getTime();
                }
                return (Long)this.value;
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Long type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException(e.getMessage() + " Cannot convert" + this.getDataType().getName() + " to Long type value");
        }
    }

    public BigDecimal getDecimal() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                try {
                    return new BigDecimal(this.value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FilterIllegalMemberException(e);
                }
            }
            if (dataType == DataTypes.SHORT) {
                return new BigDecimal(((Short)this.value).shortValue());
            }
            if (dataType == DataTypes.INT) {
                return new BigDecimal((Integer)this.value);
            }
            if (dataType == DataTypes.LONG) {
                return new BigDecimal((Long)this.value);
            }
            if (dataType == DataTypes.DOUBLE || DataTypes.isDecimal(dataType)) {
                return new BigDecimal(this.value.toString());
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return new BigDecimal(((Date)this.value).getTime());
                }
                return new BigDecimal((Long)this.value);
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof Timestamp) {
                    return new BigDecimal(((Timestamp)this.value).getTime());
                }
                if (this.isLiteral) {
                    return new BigDecimal((Long)this.value / 1000L);
                }
                return new BigDecimal((Long)this.value);
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Decimal type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Decimal type value");
        }
    }

    public Long getTime() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    java.util.Date dateToStr = parser.parse(this.value.toString());
                    return dateToStr.getTime();
                }
                catch (ParseException e) {
                    throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Time type value");
                }
            }
            if (dataType == DataTypes.SHORT) {
                return ((Short)this.value).longValue();
            }
            if (dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.DOUBLE) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return ((java.util.Date)this.value).getTime();
                }
                return (Long)this.value;
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof Timestamp) {
                    return ((Timestamp)this.value).getTime();
                }
                if (this.isLiteral) {
                    return (Long)this.value / 1000L;
                }
                return (Long)this.value;
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Time type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Time type value");
        }
    }

    public Long getTimeAsMillisecond() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    java.util.Date dateToStr = parser.parse(this.value.toString());
                    return dateToStr.getTime();
                }
                catch (ParseException e) {
                    throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Time type value");
                }
            }
            if (dataType == DataTypes.SHORT) {
                return ((Short)this.value).longValue();
            }
            if (dataType == DataTypes.INT || dataType == DataTypes.LONG) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.DOUBLE) {
                return (Long)this.value;
            }
            if (dataType == DataTypes.DATE) {
                if (this.value instanceof Date) {
                    return ((java.util.Date)this.value).getTime();
                }
                return (Long)this.value;
            }
            if (dataType == DataTypes.TIMESTAMP) {
                if (this.value instanceof java.util.Date) {
                    return ((java.util.Date)this.value).getTime();
                }
                if (this.value instanceof Timestamp) {
                    return ((Timestamp)this.value).getTime();
                }
                return (Long)this.value;
            }
            throw new FilterIllegalMemberException("Cannot convert " + this.getDataType().getName() + " to Time type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert " + this.getDataType().getName() + " to Time type value");
        }
    }

    public Boolean getBoolean() throws FilterIllegalMemberException {
        if (this.value == null) {
            return null;
        }
        try {
            DataType dataType = this.getDataType();
            if (dataType == DataTypes.STRING) {
                try {
                    return Boolean.parseBoolean(this.value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FilterIllegalMemberException(e);
                }
            }
            if (dataType == DataTypes.BOOLEAN) {
                return Boolean.parseBoolean(this.value.toString());
            }
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to boolean type value");
        }
        catch (ClassCastException e) {
            throw new FilterIllegalMemberException("Cannot convert" + this.getDataType().getName() + " to Boolean type value");
        }
    }

    public List<ExpressionResult> getList() {
        if (null == this.expressionResults) {
            ArrayList<ExpressionResult> a = new ArrayList<ExpressionResult>(20);
            a.add(new ExpressionResult(this.dataType, this.value, this.isLiteral));
            return a;
        }
        return this.expressionResults;
    }

    public List<String> getListAsString() throws FilterIllegalMemberException {
        ArrayList<String> evaluateResultListFinal = new ArrayList<String>(20);
        List<ExpressionResult> evaluateResultList = this.getList();
        for (ExpressionResult result : evaluateResultList) {
            String resultString = result.getString();
            if (resultString == null) {
                evaluateResultListFinal.add("@NU#LL$!");
                continue;
            }
            evaluateResultListFinal.add(resultString);
        }
        return evaluateResultListFinal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = null != this.expressionResults ? 31 * result + this.expressionResults.hashCode() : (null != this.value ? 31 * result + this.value.toString().hashCode() : 31 * result + "".hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpressionResult)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionResult objToCompare = (ExpressionResult)obj;
        boolean result = false;
        if (this.value == objToCompare.value) {
            return true;
        }
        if (this.isNull() || objToCompare.isNull()) {
            return false;
        }
        DataType dataType = null;
        dataType = objToCompare.getDataType().getPrecedenceOrder() < this.getDataType().getPrecedenceOrder() ? this.getDataType() : objToCompare.getDataType();
        try {
            if (dataType == DataTypes.STRING) {
                result = this.getString().equals(objToCompare.getString());
            } else if (dataType == DataTypes.SHORT) {
                result = this.getShort().equals(objToCompare.getShort());
            } else if (dataType == DataTypes.INT) {
                result = this.getInt().equals(objToCompare.getInt());
            } else if (dataType == DataTypes.LONG || dataType == DataTypes.DATE || dataType == DataTypes.TIMESTAMP) {
                result = this.getLong().equals(objToCompare.getLong());
            } else if (dataType == DataTypes.DOUBLE) {
                result = this.getDouble().equals(objToCompare.getDouble());
            } else if (DataTypes.isDecimal(dataType)) {
                result = this.getDecimal().equals(objToCompare.getDecimal());
            }
        }
        catch (FilterIllegalMemberException ex) {
            return false;
        }
        return result;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public int compareTo(ExpressionResult o) {
        try {
            DataType type = o.dataType;
            if (type == DataTypes.SHORT || type == DataTypes.INT || type == DataTypes.LONG || type == DataTypes.DOUBLE) {
                Double d1 = this.getDouble();
                Double d2 = o.getDouble();
                return d1.compareTo(d2);
            }
            if (DataTypes.isDecimal(type)) {
                BigDecimal val1 = this.getDecimal();
                BigDecimal val2 = o.getDecimal();
                return val1.compareTo(val2);
            }
            if (type == DataTypes.DATE || type == DataTypes.TIMESTAMP) {
                String format = CarbonUtil.getFormatFromProperty(o.dataType);
                SimpleDateFormat parser = new SimpleDateFormat(format);
                java.util.Date date1 = parser.parse(this.getString());
                java.util.Date date2 = parser.parse(o.getString());
                return date1.compareTo(date2);
            }
            return this.getString().compareTo(o.getString());
        }
        catch (ParseException | FilterIllegalMemberException e) {
            return -1;
        }
    }
}

