/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.LeafExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class LiteralExpression
extends LeafExpression {
    private static final long serialVersionUID = 1L;
    private Object value;
    private DataType dataType;

    public LiteralExpression(Object value, DataType dataType) {
        this.value = value;
        this.dataType = dataType;
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) {
        return new ExpressionResult(this.dataType, this.value, true);
    }

    public ExpressionResult getExpressionResult() {
        return new ExpressionResult(this.dataType, this.value, true);
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.LITERAL;
    }

    @Override
    public String getString() {
        return "LiteralExpression(" + this.value + ')';
    }

    @Override
    public String getStatement() {
        return this.value == null ? null : this.value.toString();
    }

    public DataType getLiteralExpDataType() {
        return this.dataType;
    }

    public Object getLiteralExpValue() {
        return this.value;
    }

    @Override
    public void findAndSetChild(Expression oldExpr, Expression newExpr) {
    }
}

