/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression;

import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

@InterfaceAudience.Internal
public class MatchExpression
extends Expression {
    private String queryString;
    private int maxDoc;

    public MatchExpression(String queryString) {
        this.queryString = queryString;
        this.maxDoc = -1;
    }

    public MatchExpression(String queryString, int maxDoc) {
        this.queryString = queryString;
        this.maxDoc = maxDoc;
    }

    public int getMaxDoc() {
        return this.maxDoc;
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) {
        return new ExpressionResult(DataTypes.BOOLEAN, true);
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.TEXT_MATCH;
    }

    @Override
    public void findAndSetChild(Expression oldExpr, Expression newExpr) {
    }

    @Override
    public String getString() {
        return this.queryString;
    }

    @Override
    public String getStatement() {
        return "TEXT_MATCH('" + this.queryString + "')";
    }
}

