/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.FilterModificationNode;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.core.scan.expression.logical.RangeExpression;
import org.apache.carbondata.core.scan.expression.logical.TrueExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.log4j.Logger;

public class RangeExpressionEvaluator {
    private static final Logger LOG = LogServiceFactory.getLogService((String)RangeExpressionEvaluator.class.getName());
    private Expression expr;
    private Expression srcNode;
    private Expression tarNode;
    private Expression tarParentNode;

    public RangeExpressionEvaluator(Expression expr) {
        this.expr = expr;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public void setExpr(Expression expr) {
        this.expr = expr;
    }

    private Expression getSrcNode() {
        return this.srcNode;
    }

    private void setTarNode(Expression expr) {
        this.tarNode = expr;
    }

    private void setTarParentNode(Expression expr) {
        this.tarParentNode = expr;
    }

    public void rangeExpressionEvaluatorMapBased() {
        Map<String, List<FilterModificationNode>> filterExpressionMap = this.convertFilterTreeToMap();
        this.replaceWithRangeExpression(filterExpressionMap);
        filterExpressionMap.clear();
    }

    public void replaceWithRangeExpression(Map<String, List<FilterModificationNode>> filterExpressionMap) {
        ArrayList<FilterModificationNode> deleteExp = new ArrayList<FilterModificationNode>();
        Iterator<Map.Entry<String, List<FilterModificationNode>>> iterator = filterExpressionMap.entrySet().iterator();
        Map.Entry<String, List<FilterModificationNode>> nextEntry = null;
        while (iterator.hasNext()) {
            nextEntry = iterator.next();
            List<FilterModificationNode> filterExp = nextEntry.getValue();
            if (filterExp.size() <= 1) continue;
            FilterModificationNode startMin = null;
            FilterModificationNode endMax = null;
            for (FilterModificationNode exp : filterExp) {
                ExpressionResult tarExpResult;
                ExpressionResult srcExpResult;
                LiteralExpression tarLiteral;
                LiteralExpression srcLiteral;
                if (!(exp.getExpType() != ExpressionType.GREATERTHAN && exp.getExpType() != ExpressionType.GREATERTHAN_EQUALTO || null != endMax && !this.checkLiteralValue(exp.getCurrentExp(), endMax.getCurrentExp()))) {
                    if (null == startMin) {
                        startMin = exp;
                    } else {
                        srcLiteral = this.getChildLiteralExpression(startMin.getCurrentExp());
                        tarLiteral = this.getChildLiteralExpression(exp.getCurrentExp());
                        srcExpResult = srcLiteral.evaluate(null);
                        if (srcExpResult.compareTo(tarExpResult = tarLiteral.evaluate(null)) < 0) {
                            deleteExp.add(startMin);
                            startMin = exp;
                        }
                    }
                }
                if (exp.getExpType() != ExpressionType.LESSTHAN && exp.getExpType() != ExpressionType.LESSTHAN_EQUALTO || null != startMin && !this.checkLiteralValue(exp.getCurrentExp(), startMin.getCurrentExp())) continue;
                if (null == endMax) {
                    endMax = exp;
                    continue;
                }
                srcLiteral = this.getChildLiteralExpression(endMax.getCurrentExp());
                tarLiteral = this.getChildLiteralExpression(exp.getCurrentExp());
                srcExpResult = srcLiteral.evaluate(null);
                if (srcExpResult.compareTo(tarExpResult = tarLiteral.evaluate(null)) <= 0) continue;
                deleteExp.add(endMax);
                endMax = exp;
            }
            if (null == startMin || null == endMax) continue;
            LOG.info((Object)("GreaterThan and LessThan Filter Expression changed to Range Expression for column " + nextEntry.getKey()));
            Expression n1 = startMin.getCurrentExp();
            Expression n2 = endMax.getCurrentExp();
            RangeExpression rangeTree = new RangeExpression(n1, n2);
            Expression srcParentNode = startMin.getParentExp();
            Expression tarParentNode = endMax.getParentExp();
            srcParentNode.findAndSetChild(startMin.getCurrentExp(), rangeTree);
            tarParentNode.findAndSetChild(endMax.getCurrentExp(), new TrueExpression(null));
            if (deleteExp.size() <= 0) continue;
            for (FilterModificationNode trueExp : deleteExp) {
                trueExp.getParentExp().findAndSetChild(trueExp.getCurrentExp(), new TrueExpression(null));
            }
        }
    }

    private Map<String, List<FilterModificationNode>> convertFilterTreeToMap() {
        HashMap<String, List<FilterModificationNode>> filterExpressionMap = new HashMap<String, List<FilterModificationNode>>(16);
        this.fillExpressionMap(filterExpressionMap, null, null);
        return filterExpressionMap;
    }

    private void evaluateOrExpression(Expression currentNode, Expression orExpChild) {
        HashMap<String, List<FilterModificationNode>> filterExpressionMapNew = new HashMap<String, List<FilterModificationNode>>(16);
        this.fillExpressionMap(filterExpressionMapNew, orExpChild, currentNode);
        this.replaceWithRangeExpression(filterExpressionMapNew);
        filterExpressionMapNew.clear();
    }

    private void fillExpressionMap(Map<String, List<FilterModificationNode>> filterExpressionMap, Expression currentNode, Expression parentNode) {
        if (null == currentNode) {
            parentNode = currentNode = this.getExpr();
        }
        if (parentNode instanceof AndExpression && this.isLessThanGreaterThanExp(currentNode) && this.eligibleForRangeExpConv(currentNode)) {
            this.addFilterExpressionMap(filterExpressionMap, currentNode, parentNode);
        }
        if (currentNode instanceof OrExpression) {
            Expression leftChild = ((OrExpression)currentNode).left;
            Expression rightChild = ((OrExpression)currentNode).right;
            if (null != leftChild) {
                this.evaluateOrExpression(currentNode, leftChild);
            }
            if (null != rightChild) {
                this.evaluateOrExpression(currentNode, rightChild);
            }
        } else {
            for (Expression exp : currentNode.getChildren()) {
                if (null == exp) continue;
                this.fillExpressionMap(filterExpressionMap, exp, currentNode);
            }
        }
    }

    private void addFilterExpressionMap(Map<String, List<FilterModificationNode>> filterExpressionMap, Expression currentNode, Expression parentNode) {
        String colName = this.getColumnName(currentNode);
        ExpressionType expType = this.getExpressionType(currentNode);
        FilterModificationNode filterExpression = new FilterModificationNode(currentNode, parentNode, expType);
        if (null == filterExpressionMap.get(colName)) {
            filterExpressionMap.put(colName, new ArrayList());
        }
        filterExpressionMap.get(colName).add(filterExpression);
    }

    private boolean isLessThanGreaterThanExp(Expression expr) {
        return expr instanceof LessThanEqualToExpression || expr instanceof LessThanExpression || expr instanceof GreaterThanEqualToExpression || expr instanceof GreaterThanExpression;
    }

    private boolean eligibleForRangeExpConv(Expression expChild) {
        for (Expression exp : expChild.getChildren()) {
            if (!(exp instanceof ColumnExpression)) continue;
            return ((ColumnExpression)exp).isDimension() && !((ColumnExpression)exp).getDimension().getDataType().isComplexType();
        }
        return false;
    }

    private String getColumnName(Expression andNode) {
        for (Expression exp : andNode.getChildren()) {
            if (!(exp instanceof ColumnExpression)) continue;
            return ((ColumnExpression)exp).getColumnName();
        }
        return null;
    }

    private Object getLiteralValue(Expression exp) {
        for (Expression expr : exp.getChildren()) {
            if (!(expr instanceof LiteralExpression)) continue;
            return ((LiteralExpression)expr).getLiteralExpValue();
        }
        return null;
    }

    private DataType getLiteralDataType(Expression exp) {
        for (Expression expr : exp.getChildren()) {
            if (!(expr instanceof LiteralExpression)) continue;
            return ((LiteralExpression)expr).getLiteralExpDataType();
        }
        return null;
    }

    private LiteralExpression getChildLiteralExpression(Expression exp) {
        for (Expression expr : exp.getChildren()) {
            if (!(expr instanceof LiteralExpression)) continue;
            return (LiteralExpression)expr;
        }
        return null;
    }

    private ExpressionType getExpressionType(Expression exp) {
        if (exp instanceof LessThanExpression) {
            return ExpressionType.LESSTHAN;
        }
        if (exp instanceof LessThanEqualToExpression) {
            return ExpressionType.LESSTHAN_EQUALTO;
        }
        if (exp instanceof GreaterThanExpression) {
            return ExpressionType.GREATERTHAN;
        }
        if (exp instanceof GreaterThanEqualToExpression) {
            return ExpressionType.GREATERTHAN_EQUALTO;
        }
        return ExpressionType.FALSE;
    }

    private boolean matchExpType(ExpressionType src, ExpressionType tar) {
        return !((src != ExpressionType.LESSTHAN && src != ExpressionType.LESSTHAN_EQUALTO || tar != ExpressionType.GREATERTHAN && tar != ExpressionType.GREATERTHAN_EQUALTO) && (src != ExpressionType.GREATERTHAN && src != ExpressionType.GREATERTHAN_EQUALTO || tar != ExpressionType.LESSTHAN && tar != ExpressionType.LESSTHAN_EQUALTO));
    }

    private Expression traverseTree(Expression currentNode, Expression parentNode) {
        Expression result = null;
        if (null == parentNode) {
            parentNode = currentNode = this.getExpr();
        }
        if (!this.getSrcNode().equals(currentNode) && this.isLessThanGreaterThanExp(currentNode)) {
            String srcColumnName = this.getColumnName(this.getSrcNode());
            String tarColumnName = this.getColumnName(currentNode);
            ExpressionType srcExpType = this.getExpressionType(this.getSrcNode());
            ExpressionType tarExpType = this.getExpressionType(currentNode);
            if (null != srcColumnName && null != tarColumnName && srcColumnName.equals(tarColumnName) && srcExpType != ExpressionType.FALSE && tarExpType != ExpressionType.FALSE && this.matchExpType(srcExpType, tarExpType) && this.checkLiteralValue(this.getSrcNode(), currentNode)) {
                this.setTarNode(currentNode);
                this.setTarParentNode(parentNode);
                return parentNode;
            }
        }
        for (Expression exp : currentNode.getChildren()) {
            if (null == exp || exp instanceof RangeExpression || null == (result = this.traverseTree(exp, currentNode))) continue;
            return result;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkLiteralValue(Expression src, Expression tar) {
        ExpressionType srcExpressionType = this.getExpressionType(src);
        ExpressionType tarExpressionType = this.getExpressionType(tar);
        LiteralExpression srcLiteral = this.getChildLiteralExpression(src);
        LiteralExpression tarLiteral = this.getChildLiteralExpression(tar);
        ExpressionResult srcExpResult = srcLiteral.evaluate(null);
        ExpressionResult tarExpResult = tarLiteral.evaluate(null);
        switch (srcExpressionType) {
            case LESSTHAN: 
            case LESSTHAN_EQUALTO: {
                switch (tarExpressionType) {
                    case GREATERTHAN: {
                        if (srcExpResult.compareTo(tarExpResult) <= 0) return false;
                        return true;
                    }
                    case GREATERTHAN_EQUALTO: {
                        if (srcExpResult.compareTo(tarExpResult) < 0) return false;
                        return true;
                    }
                }
                return false;
            }
            case GREATERTHAN: 
            case GREATERTHAN_EQUALTO: {
                switch (tarExpressionType) {
                    case LESSTHAN: {
                        if (srcExpResult.compareTo(tarExpResult) >= 0) return false;
                        return true;
                    }
                    case LESSTHAN_EQUALTO: {
                        if (srcExpResult.compareTo(tarExpResult) > 0) return false;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

