/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class EqualToExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = 1L;

    public EqualToExpression(Expression left, Expression right) {
        super(left, right);
    }

    public EqualToExpression(Expression left, Expression right, boolean isNull) {
        super(left, right);
        this.isNull = isNull;
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        DataType dataType;
        ExpressionResult elRes = this.left.evaluate(value);
        ExpressionResult erRes = this.right.evaluate(value);
        boolean result = false;
        ExpressionResult val1 = elRes;
        ExpressionResult val2 = erRes;
        if (elRes.isNull() || erRes.isNull()) {
            if (this.isNull) {
                elRes.set(DataTypes.BOOLEAN, elRes.isNull() == erRes.isNull());
            } else {
                elRes.set(DataTypes.BOOLEAN, false);
            }
            return elRes;
        }
        if (elRes.getDataType() != erRes.getDataType() && elRes.getDataType().getPrecedenceOrder() < erRes.getDataType().getPrecedenceOrder()) {
            val2 = elRes;
            val1 = erRes;
        }
        if ((dataType = val1.getDataType()) == DataTypes.BOOLEAN) {
            result = val1.getBoolean().equals(val2.getBoolean());
        } else if (dataType == DataTypes.STRING) {
            result = val1.getString().equals(val2.getString());
        } else if (dataType == DataTypes.SHORT) {
            result = val1.getShort().equals(val2.getShort());
        } else if (dataType == DataTypes.INT) {
            result = val1.getInt().equals(val2.getInt());
        } else if (dataType == DataTypes.DOUBLE) {
            result = FilterUtil.nanSafeEqualsDoubles(val1.getDouble(), val2.getDouble());
        } else if (dataType == DataTypes.DATE) {
            result = val1.getTime().equals(val2.getTime());
        } else if (dataType == DataTypes.TIMESTAMP) {
            result = val1.getTimeAsMillisecond().equals(val2.getTimeAsMillisecond());
        } else if (dataType == DataTypes.LONG) {
            result = val1.getLong().equals(val2.getLong());
        } else if (DataTypes.isDecimal(dataType)) {
            result = val1.getDecimal().compareTo(val2.getDecimal()) == 0;
        } else {
            throw new FilterUnsupportedException("DataType: " + val1.getDataType() + " not supported for the filter expression");
        }
        val1.set(DataTypes.BOOLEAN, result);
        return val1;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.EQUALS;
    }

    @Override
    public String getString() {
        return "EqualTo(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        if (this.isNull) {
            return this.left.getStatement() + " is " + this.right.getStatement();
        }
        return this.left.getStatement() + " = " + this.right.getStatement();
    }
}

