/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class GreaterThanEqualToExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = 4185317066280688984L;

    public GreaterThanEqualToExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        ExpressionResult elRes = this.left.evaluate(value);
        ExpressionResult erRes = this.right.evaluate(value);
        ExpressionResult exprResVal1 = elRes;
        if (elRes.isNull() || erRes.isNull()) {
            elRes.set(DataTypes.BOOLEAN, false);
            return elRes;
        }
        if (elRes.getDataType() != erRes.getDataType() && elRes.getDataType().getPrecedenceOrder() < erRes.getDataType().getPrecedenceOrder()) {
            exprResVal1 = erRes;
        }
        boolean result = false;
        DataType dataType = exprResVal1.getDataType();
        if (dataType == DataTypes.BOOLEAN) {
            result = elRes.getBoolean().compareTo(erRes.getBoolean()) >= 0;
        } else if (dataType == DataTypes.STRING) {
            result = elRes.getString().compareTo(erRes.getString()) >= 0;
        } else if (dataType == DataTypes.SHORT) {
            result = elRes.getShort() >= erRes.getShort();
        } else if (dataType == DataTypes.INT) {
            result = elRes.getInt() >= erRes.getInt();
        } else if (dataType == DataTypes.DOUBLE) {
            result = elRes.getDouble() >= erRes.getDouble();
        } else if (dataType == DataTypes.DATE) {
            result = elRes.getTime() >= erRes.getTime();
        } else if (dataType == DataTypes.TIMESTAMP) {
            result = elRes.getTimeAsMillisecond() >= erRes.getTimeAsMillisecond();
        } else if (dataType == DataTypes.LONG) {
            result = elRes.getLong() >= erRes.getLong();
        } else if (DataTypes.isDecimal(dataType)) {
            result = elRes.getDecimal().compareTo(erRes.getDecimal()) >= 0;
        } else {
            throw new FilterUnsupportedException("DataType: " + exprResVal1.getDataType() + " not supported for the filter expression");
        }
        exprResVal1.set(DataTypes.BOOLEAN, result);
        return exprResVal1;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.GREATERTHAN_EQUALTO;
    }

    @Override
    public String getString() {
        return "GreaterThanEqualTo(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return this.left.getStatement() + " >= " + this.right.getStatement();
    }
}

