/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.commons.lang.StringUtils;

public class ImplicitExpression
extends Expression {
    private Map<String, Set<Integer>> blockIdToBlockletIdMapping;

    public ImplicitExpression(List<Expression> implicitFilterList) {
        this.blockIdToBlockletIdMapping = new HashMap<String, Set<Integer>>(implicitFilterList.size() / 2);
        for (Expression value : implicitFilterList) {
            String blockletPath = ((LiteralExpression)value).getLiteralExpValue().toString();
            this.addBlockEntry(blockletPath);
        }
    }

    public ImplicitExpression(Map<String, Set<Integer>> blockIdToBlockletIdMapping) {
        this.blockIdToBlockletIdMapping = blockIdToBlockletIdMapping;
    }

    private void addBlockEntry(String blockletPath) {
        String blockId = blockletPath.substring(0, blockletPath.lastIndexOf("/"));
        Set<Integer> blockletIds = this.blockIdToBlockletIdMapping.get(blockId);
        if (null == blockletIds) {
            blockletIds = new HashSet<Integer>();
            this.blockIdToBlockletIdMapping.put(blockId, blockletIds);
        }
        blockletIds.add(Integer.parseInt(blockletPath.substring(blockId.length() + 1)));
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) {
        throw new UnsupportedOperationException("Operation not supported for Implicit expression");
    }

    public Map<String, Set<Integer>> getBlockIdToBlockletIdMapping() {
        return this.blockIdToBlockletIdMapping;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.IMPLICIT;
    }

    @Override
    public void findAndSetChild(Expression oldExpr, Expression newExpr) {
    }

    @Override
    public String getString() {
        StringBuilder value = new StringBuilder();
        value.append("ImplicitExpression(");
        for (Map.Entry<String, Set<Integer>> entry : this.blockIdToBlockletIdMapping.entrySet()) {
            value.append(entry.getKey()).append(" --> ");
            value.append(StringUtils.join((Object[])entry.getValue().toArray(new Integer[entry.getValue().size()]), (String)",")).append(";");
            if (value.length() <= 100) continue;
            value.append("...");
            break;
        }
        value.append(')');
        return value.toString();
    }

    @Override
    public String getStatement() {
        return this.getString();
    }
}

