/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import java.util.HashSet;
import java.util.Set;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class InExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = -3149927446694175489L;
    protected transient Set<ExpressionResult> setOfExprResult;

    public InExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        ExpressionResult leftRsult = this.left.evaluate(value);
        if (this.setOfExprResult == null) {
            ExpressionResult rightRsult = this.right.evaluate(value);
            ExpressionResult val = null;
            this.setOfExprResult = new HashSet<ExpressionResult>(10);
            for (ExpressionResult expressionResVal : rightRsult.getList()) {
                val = expressionResVal.getDataType().getPrecedenceOrder() < leftRsult.getDataType().getPrecedenceOrder() ? leftRsult : expressionResVal;
                DataType dataType = val.getDataType();
                if (dataType == DataTypes.BOOLEAN) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getBoolean());
                } else if (dataType == DataTypes.STRING) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getString());
                } else if (dataType == DataTypes.SHORT) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getShort());
                } else if (dataType == DataTypes.INT) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getInt());
                } else if (dataType == DataTypes.DOUBLE) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getDouble());
                } else if (dataType == DataTypes.LONG) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getLong());
                } else if (dataType == DataTypes.DATE) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getTime());
                } else if (dataType == DataTypes.TIMESTAMP) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getTimeAsMillisecond());
                } else if (DataTypes.isDecimal(dataType)) {
                    val = new ExpressionResult(val.getDataType(), expressionResVal.getDecimal());
                } else {
                    throw new FilterUnsupportedException("DataType: " + val.getDataType() + " not supported for the filter expression");
                }
                this.setOfExprResult.add(val);
            }
        }
        if (leftRsult.isNull()) {
            leftRsult.set(DataTypes.BOOLEAN, false);
        } else {
            leftRsult.set(DataTypes.BOOLEAN, this.setOfExprResult.contains(leftRsult));
        }
        return leftRsult;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.IN;
    }

    @Override
    public String getString() {
        return "IN(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return this.left.getStatement() + " in " + this.right.getStatement();
    }
}

