/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class ListExpression
extends Expression {
    private static final long serialVersionUID = 1L;

    public ListExpression(List<Expression> children) {
        this.children = children;
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException {
        ArrayList<ExpressionResult> listOfExprRes = new ArrayList<ExpressionResult>(10);
        for (Expression expr : this.children) {
            try {
                listOfExprRes.add(expr.evaluate(value));
            }
            catch (FilterIllegalMemberException e) {}
        }
        return new ExpressionResult(listOfExprRes);
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.LIST;
    }

    @Override
    public String getString() {
        StringBuffer value = new StringBuffer();
        value.append("ListExpression(");
        for (Expression expr : this.children) {
            value.append(expr.getString()).append(";");
        }
        value.append(')');
        return value.toString();
    }

    @Override
    public String getStatement() {
        StringBuffer value = new StringBuffer();
        value.append("(");
        for (Expression expr : this.children) {
            value.append(expr.getString()).append(";");
        }
        value.append(')');
        return value.toString();
    }

    @Override
    public void findAndSetChild(Expression oldExpr, Expression newExpr) {
    }
}

