/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class NotEqualsExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = 8684006025540863973L;
    private boolean isNotNull = false;

    public NotEqualsExpression(Expression left, Expression right, boolean isNotNull) {
        super(left, right);
        this.isNotNull = isNotNull;
    }

    public NotEqualsExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        DataType dataType;
        ExpressionResult elRes = this.left.evaluate(value);
        ExpressionResult erRes = this.right.evaluate(value);
        boolean result = false;
        ExpressionResult val1 = elRes;
        ExpressionResult val2 = erRes;
        if (elRes.isNull() || erRes.isNull()) {
            if (this.isNotNull) {
                elRes.set(DataTypes.BOOLEAN, elRes.isNull() != erRes.isNull());
            } else {
                elRes.set(DataTypes.BOOLEAN, false);
            }
            return elRes;
        }
        if (elRes.getDataType() != erRes.getDataType() && elRes.getDataType().getPrecedenceOrder() < erRes.getDataType().getPrecedenceOrder()) {
            val1 = erRes;
            val2 = elRes;
        }
        if ((dataType = val1.getDataType()) == DataTypes.BOOLEAN) {
            result = !val1.getBoolean().equals(val2.getBoolean());
        } else if (dataType == DataTypes.STRING) {
            result = !val1.getString().equals(val2.getString());
        } else if (dataType == DataTypes.SHORT) {
            result = val1.getShort().shortValue() != val2.getShort().shortValue();
        } else if (dataType == DataTypes.INT) {
            result = val1.getInt().intValue() != val2.getInt().intValue();
        } else if (dataType == DataTypes.DOUBLE) {
            result = val1.getDouble().doubleValue() != val2.getDouble().doubleValue();
        } else if (dataType == DataTypes.DATE) {
            result = val1.getTime().longValue() != val2.getTime().longValue();
        } else if (dataType == DataTypes.TIMESTAMP) {
            result = val1.getTimeAsMillisecond().longValue() != val2.getTimeAsMillisecond().longValue();
        } else if (dataType == DataTypes.LONG) {
            result = elRes.getLong().longValue() != erRes.getLong().longValue();
        } else if (DataTypes.isDecimal(dataType)) {
            result = elRes.getDecimal().compareTo(erRes.getDecimal()) != 0;
        } else {
            throw new FilterUnsupportedException("DataType: " + val1.getDataType() + " not supported for the filter expression");
        }
        val1.set(DataTypes.BOOLEAN, result);
        return val1;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.NOT_EQUALS;
    }

    @Override
    public String getString() {
        return "NotEquals(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return this.left.getStatement() + " <> " + this.right.getStatement();
    }
}

