/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import java.util.HashSet;
import java.util.Set;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class NotInExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = -6835841923752118034L;
    protected transient Set<ExpressionResult> setOfExprResult;
    protected transient ExpressionResult nullValuePresent = null;

    public NotInExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        if (this.nullValuePresent != null) {
            return this.nullValuePresent;
        }
        ExpressionResult leftRsult = this.left.evaluate(value);
        if (leftRsult.isNull()) {
            leftRsult.set(DataTypes.BOOLEAN, false);
            return leftRsult;
        }
        if (this.setOfExprResult == null) {
            ExpressionResult val = null;
            ExpressionResult rightRsult = this.right.evaluate(value);
            this.setOfExprResult = new HashSet<ExpressionResult>(10);
            for (ExpressionResult exprResVal : rightRsult.getList()) {
                if (exprResVal.isNull()) {
                    this.nullValuePresent = new ExpressionResult(DataTypes.BOOLEAN, false);
                    leftRsult.set(DataTypes.BOOLEAN, false);
                    return leftRsult;
                }
                val = exprResVal.getDataType().getPrecedenceOrder() < leftRsult.getDataType().getPrecedenceOrder() ? leftRsult : exprResVal;
                DataType dataType = val.getDataType();
                if (dataType == DataTypes.BOOLEAN) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getBoolean());
                } else if (dataType == DataTypes.STRING) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getString());
                } else if (dataType == DataTypes.SHORT) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getShort());
                } else if (dataType == DataTypes.INT) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getInt());
                } else if (dataType == DataTypes.DOUBLE) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getDouble());
                } else if (dataType == DataTypes.DATE) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getTime());
                } else if (dataType == DataTypes.TIMESTAMP) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getTimeAsMillisecond());
                } else if (dataType == DataTypes.LONG) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getLong());
                } else if (DataTypes.isDecimal(dataType)) {
                    val = new ExpressionResult(val.getDataType(), exprResVal.getDecimal());
                } else {
                    throw new FilterUnsupportedException("DataType: " + val.getDataType() + " not supported for the filter expression");
                }
                this.setOfExprResult.add(val);
            }
        }
        leftRsult.set(DataTypes.BOOLEAN, !this.setOfExprResult.contains(leftRsult));
        return leftRsult;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.NOT_IN;
    }

    @Override
    public String getString() {
        return "NOT IN(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return this.left.getStatement() + " not in " + this.right.getStatement();
    }
}

