/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.conditional;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class StartsWithExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = -5319109756575539219L;

    public StartsWithExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        ExpressionResult exprLeftRes = this.left.evaluate(value);
        ExpressionResult exprRightRes = this.right.evaluate(value);
        ExpressionResult val1 = exprLeftRes;
        if (exprLeftRes.isNull() || exprRightRes.isNull()) {
            exprLeftRes.set(DataTypes.BOOLEAN, false);
            return exprLeftRes;
        }
        if (exprLeftRes.getDataType() != exprRightRes.getDataType() && exprLeftRes.getDataType().getPrecedenceOrder() < exprRightRes.getDataType().getPrecedenceOrder()) {
            val1 = exprRightRes;
        }
        boolean result = false;
        DataType dataType = val1.getDataType();
        if (dataType != DataTypes.STRING) {
            throw new FilterUnsupportedException("DataType: " + val1.getDataType() + " not supported for the filter expression");
        }
        result = exprLeftRes.getString().startsWith(exprRightRes.getString());
        val1.set(DataTypes.BOOLEAN, result);
        return val1;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.STARTSWITH;
    }

    @Override
    public String getString() {
        return "StartsWith(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return this.left.getStatement() + " like '" + this.right.getStatement() + "%'";
    }
}

