/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.carbondata.core.scan.expression.BinaryExpression;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.LiteralExpression;

public abstract class BinaryLogicalExpression
extends BinaryExpression {
    private static final long serialVersionUID = 1L;

    public BinaryLogicalExpression(Expression left, Expression right) {
        super(left, right);
    }

    public List<ExpressionResult> getLiterals() {
        ArrayList<ExpressionResult> listOfExp = new ArrayList<ExpressionResult>(16);
        this.getExpressionResultList(this, listOfExp);
        Collections.sort(listOfExp);
        return listOfExp;
    }

    public List<ColumnExpression> getColumnList() {
        ArrayList<ColumnExpression> listOfExp = new ArrayList<ColumnExpression>(16);
        this.getColumnList(this, listOfExp);
        return listOfExp;
    }

    private void getColumnList(Expression expression, List<ColumnExpression> lst) {
        if (expression instanceof ColumnExpression) {
            ColumnExpression colExp = (ColumnExpression)expression;
            boolean found = false;
            for (ColumnExpression currentColExp : lst) {
                if (!currentColExp.getColumnName().equalsIgnoreCase(colExp.getColumnName())) continue;
                found = true;
                colExp.setColIndex(currentColExp.getColIndex());
                break;
            }
            if (!found) {
                colExp.setColIndex(lst.size());
                lst.add(colExp);
            }
        }
        for (Expression child : expression.getChildren()) {
            this.getColumnList(child, lst);
        }
    }

    public boolean isSingleColumn() {
        ArrayList<ColumnExpression> listOfExp = new ArrayList<ColumnExpression>(16);
        this.getColumnList(this, listOfExp);
        return listOfExp.size() == 1 && (((ColumnExpression)listOfExp.get(0)).isDimension() || ((ColumnExpression)listOfExp.get(0)).isMeasure());
    }

    private void getExpressionResultList(Expression binaryConditionalExpression, List<ExpressionResult> listOfExp) {
        if (binaryConditionalExpression instanceof LiteralExpression) {
            ExpressionResult colExp = ((LiteralExpression)binaryConditionalExpression).getExpressionResult();
            listOfExp.add(colExp);
        }
        for (Expression child : binaryConditionalExpression.getChildren()) {
            this.getExpressionResultList(child, listOfExp);
        }
    }
}

