/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.logical;

import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.expression.logical.BinaryLogicalExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class OrExpression
extends BinaryLogicalExpression {
    private static final long serialVersionUID = 4220598043176438380L;

    public OrExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterIllegalMemberException, FilterUnsupportedException {
        ExpressionResult resultLeft = this.left.evaluate(value);
        ExpressionResult resultRight = this.right.evaluate(value);
        if (resultLeft.getDataType() != DataTypes.BOOLEAN) {
            throw new FilterUnsupportedException("Incompatible datatype for applying OR Expression Filter");
        }
        resultLeft.set(DataTypes.BOOLEAN, resultLeft.getBoolean() != false || resultRight.getBoolean() != false);
        return resultLeft;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.OR;
    }

    @Override
    public String getString() {
        return "Or(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return "(" + this.left.getString() + " or " + this.right.getString() + ")";
    }
}

