/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.expression.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;

public class RangeExpression
extends BinaryConditionalExpression {
    private static final long serialVersionUID = 1L;

    public RangeExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public ExpressionResult evaluate(RowIntf value) throws FilterUnsupportedException, FilterIllegalMemberException {
        ExpressionResult resultLeft = this.left.evaluate(value);
        ExpressionResult resultRight = this.right.evaluate(value);
        if (resultLeft.getDataType() != DataTypes.BOOLEAN) {
            throw new FilterUnsupportedException("Incompatible datatype for applying RANGE Expression Filter");
        }
        resultLeft.set(DataTypes.BOOLEAN, resultLeft.getBoolean() != false && resultRight.getBoolean() != false);
        return resultLeft;
    }

    @Override
    public ExpressionType getFilterExpressionType() {
        return ExpressionType.RANGE;
    }

    @Override
    public String getString() {
        return "Range(" + this.left.getString() + ',' + this.right.getString() + ')';
    }

    @Override
    public String getStatement() {
        return this.left.getStatement() + " between " + this.right.getStatement();
    }

    @Override
    public List<ExpressionResult> getLiterals() {
        ArrayList<ExpressionResult> listOfExp = new ArrayList<ExpressionResult>(16);
        this.getLiteralsResult(this, listOfExp);
        Collections.sort(listOfExp);
        return listOfExp;
    }

    private void getLiteralsResult(Expression expression, List<ExpressionResult> listOfExp) {
        for (Expression child : expression.getChildren()) {
            if (child instanceof LiteralExpression) {
                ExpressionResult colExp = ((LiteralExpression)child).getExpressionResult();
                listOfExp.add(colExp);
                continue;
            }
            this.getLiteralsResult(child, listOfExp);
        }
    }
}

