/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter;

import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.HashSet;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterBitSetUpdater;
import org.apache.carbondata.core.scan.filter.executer.MeasureColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.util.DataTypeUtil;

public class FilterExecutorUtil {
    public static void executeIncludeExcludeFilterForMeasure(ColumnPage page, BitSet bitSet, MeasureColumnExecuterFilterInfo measureColumnExecuterFilterInfo, MeasureColumnResolvedFilterInfo measureColumnResolvedFilterInfo, FilterBitSetUpdater filterBitSetUpdater) {
        CarbonMeasure measure = measureColumnResolvedFilterInfo.getMeasure();
        DataType dataType = FilterUtil.getMeasureDataType(measureColumnResolvedFilterInfo);
        int numberOfRows = page.getPageSize();
        BitSet nullBitSet = page.getNullBits();
        Object[] filterKeys = measureColumnExecuterFilterInfo.getFilterKeys();
        for (int i = 0; i < filterKeys.length; ++i) {
            if (filterKeys[i] != null) continue;
            int j = nullBitSet.nextSetBit(0);
            while (j >= 0) {
                bitSet.flip(j);
                j = nullBitSet.nextSetBit(j + 1);
            }
        }
        AbstractCollection filterSet = measureColumnExecuterFilterInfo.getFilterSet();
        if (dataType == DataTypes.BYTE) {
            ByteOpenHashSet byteOpenHashSet = (ByteOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !byteOpenHashSet.contains((byte)page.getLong(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (dataType == DataTypes.BOOLEAN) {
            BooleanOpenHashSet booleanOpenHashSet = (BooleanOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !booleanOpenHashSet.contains(page.getBoolean(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (dataType == DataTypes.SHORT) {
            ShortOpenHashSet shortOpenHashSet = (ShortOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !shortOpenHashSet.contains((short)page.getLong(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (dataType == DataTypes.INT) {
            IntOpenHashSet intOpenHashSet = (IntOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !intOpenHashSet.contains((int)page.getLong(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (dataType == DataTypes.FLOAT) {
            FloatOpenHashSet floatOpenHashSet = (FloatOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !floatOpenHashSet.contains((float)page.getDouble(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (dataType == DataTypes.DOUBLE) {
            DoubleOpenHashSet doubleOpenHashSet = (DoubleOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !doubleOpenHashSet.contains(page.getDouble(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (dataType == DataTypes.LONG) {
            LongOpenHashSet longOpenHashSet = (LongOpenHashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                if (nullBitSet.get(i) || !longOpenHashSet.contains(page.getLong(i))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else if (DataTypes.isDecimal(dataType)) {
            HashSet bigDecimalHashSet = (HashSet)filterSet;
            for (int i = 0; i < numberOfRows; ++i) {
                Object measureObjectBasedOnDataType;
                if (nullBitSet.get(i) || !bigDecimalHashSet.contains(measureObjectBasedOnDataType = DataTypeUtil.getMeasureObjectBasedOnDataType(page, i, dataType, measure))) continue;
                filterBitSetUpdater.updateBitset(bitSet, i);
            }
        } else {
            throw new IllegalArgumentException("Invalid data type");
        }
    }
}

