/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter;

import java.util.BitSet;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.expression.BinaryExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.conditional.ConditionalExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.StartsWithExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.core.scan.expression.logical.TrueExpression;
import org.apache.carbondata.core.scan.filter.FilterProcessor;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.ImplicitColumnFilterExecutor;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.resolver.ConditionalFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.filter.resolver.LogicalFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.RowLevelFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.RowLevelRangeFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.FalseConditionalResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.TrueConditionalResolverImpl;
import org.apache.log4j.Logger;

public class FilterExpressionProcessor
implements FilterProcessor {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)FilterExpressionProcessor.class.getName());

    @Override
    public FilterResolverIntf getFilterResolver(Expression expressionTree, AbsoluteTableIdentifier tableIdentifier) throws FilterUnsupportedException {
        if (null != expressionTree && null != tableIdentifier) {
            return this.getFilterResolvertree(expressionTree, tableIdentifier);
        }
        return null;
    }

    private FilterResolverIntf getFilterResolvertree(Expression expressionTree, AbsoluteTableIdentifier tableIdentifier) throws FilterUnsupportedException {
        FilterResolverIntf filterEvaluatorTree = this.createFilterResolverTree(expressionTree, tableIdentifier);
        this.traverseAndResolveTree(filterEvaluatorTree, tableIdentifier);
        return filterEvaluatorTree;
    }

    private void traverseAndResolveTree(FilterResolverIntf filterResolverTree, AbsoluteTableIdentifier tableIdentifier) throws FilterUnsupportedException {
        if (null == filterResolverTree) {
            return;
        }
        this.traverseAndResolveTree(filterResolverTree.getLeft(), tableIdentifier);
        filterResolverTree.resolve();
        this.traverseAndResolveTree(filterResolverTree.getRight(), tableIdentifier);
    }

    private FilterResolverIntf createFilterResolverTree(Expression expressionTree, AbsoluteTableIdentifier tableIdentifier) {
        ExpressionType filterExpressionType = expressionTree.getFilterExpressionType();
        BinaryExpression currentExpression = null;
        switch (filterExpressionType) {
            case OR: 
            case AND: {
                currentExpression = (BinaryExpression)expressionTree;
                return new LogicalFilterResolverImpl(this.createFilterResolverTree(currentExpression.getLeft(), tableIdentifier), this.createFilterResolverTree(currentExpression.getRight(), tableIdentifier), currentExpression);
            }
            case RANGE: {
                return this.getFilterResolverBasedOnExpressionType(ExpressionType.RANGE, true, expressionTree, tableIdentifier, expressionTree);
            }
            case EQUALS: 
            case IN: {
                return this.getFilterResolverBasedOnExpressionType(ExpressionType.EQUALS, ((BinaryConditionalExpression)expressionTree).isNull, expressionTree, tableIdentifier, expressionTree);
            }
            case GREATERTHAN: 
            case GREATERTHAN_EQUALTO: 
            case LESSTHAN: 
            case LESSTHAN_EQUALTO: {
                return this.getFilterResolverBasedOnExpressionType(ExpressionType.EQUALS, true, expressionTree, tableIdentifier, expressionTree);
            }
            case STARTSWITH: {
                assert (expressionTree instanceof StartsWithExpression);
                currentExpression = (StartsWithExpression)expressionTree;
                Expression re = currentExpression.getRight();
                assert (re instanceof LiteralExpression);
                LiteralExpression literal = (LiteralExpression)re;
                String value = literal.getLiteralExpValue().toString();
                GreaterThanEqualToExpression left = new GreaterThanEqualToExpression(currentExpression.getLeft(), literal);
                String maxValueLimit = value.substring(0, value.length() - 1) + (char)(value.charAt(value.length() - 1) + '\u0001');
                LessThanExpression right = new LessThanExpression(currentExpression.getLeft(), new LiteralExpression(maxValueLimit, literal.getLiteralExpDataType()));
                currentExpression = new AndExpression(left, right);
                return new LogicalFilterResolverImpl(this.createFilterResolverTree(currentExpression.getLeft(), tableIdentifier), this.createFilterResolverTree(currentExpression.getRight(), tableIdentifier), currentExpression);
            }
            case NOT_EQUALS: 
            case NOT_IN: {
                return this.getFilterResolverBasedOnExpressionType(ExpressionType.NOT_EQUALS, false, expressionTree, tableIdentifier, expressionTree);
            }
            case FALSE: {
                return this.getFilterResolverBasedOnExpressionType(ExpressionType.FALSE, false, expressionTree, tableIdentifier, expressionTree);
            }
            case TRUE: {
                return this.getFilterResolverBasedOnExpressionType(ExpressionType.TRUE, false, expressionTree, tableIdentifier, expressionTree);
            }
        }
        return this.getFilterResolverBasedOnExpressionType(ExpressionType.UNKNOWN, false, expressionTree, tableIdentifier, expressionTree);
    }

    private FilterResolverIntf getFilterResolverBasedOnExpressionType(ExpressionType filterExpressionType, boolean isExpressionResolve, Expression expression, AbsoluteTableIdentifier tableIdentifier, Expression expressionTree) {
        BinaryConditionalExpression currentCondExpression = null;
        ConditionalExpression condExpression = null;
        switch (filterExpressionType) {
            case FALSE: {
                return new FalseConditionalResolverImpl(expression, false, false);
            }
            case TRUE: {
                return new TrueConditionalResolverImpl(expression, false, false);
            }
            case EQUALS: {
                CarbonColumn carbonColumn;
                currentCondExpression = (BinaryConditionalExpression)expression;
                if (currentCondExpression instanceof InExpression && (carbonColumn = currentCondExpression.getColumnList().get(0).getCarbonColumn()).hasEncoding(Encoding.IMPLICIT)) {
                    return new ConditionalFilterResolverImpl(expression, isExpressionResolve, true, currentCondExpression.getColumnList().get(0).getCarbonColumn().isMeasure());
                }
                CarbonColumn column = currentCondExpression.getColumnList().get(0).getCarbonColumn();
                if (!currentCondExpression.isSingleColumn() || column.getDataType().isComplexType()) break;
                if (column.isMeasure().booleanValue()) {
                    if (FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getLeft()) && FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getRight()) || FilterUtil.checkIfRightExpressionRequireEvaluation(currentCondExpression.getRight()) || FilterUtil.checkIfLeftExpressionRequireEvaluation(currentCondExpression.getLeft())) {
                        return new RowLevelFilterResolverImpl(expression, isExpressionResolve, true, tableIdentifier);
                    }
                    if (currentCondExpression.getFilterExpressionType() == ExpressionType.GREATERTHAN || currentCondExpression.getFilterExpressionType() == ExpressionType.LESSTHAN || currentCondExpression.getFilterExpressionType() == ExpressionType.GREATERTHAN_EQUALTO || currentCondExpression.getFilterExpressionType() == ExpressionType.LESSTHAN_EQUALTO) {
                        return new RowLevelRangeFilterResolverImpl(expression, isExpressionResolve, true, tableIdentifier);
                    }
                    return new ConditionalFilterResolverImpl(expression, isExpressionResolve, true, currentCondExpression.getColumnList().get(0).getCarbonColumn().isMeasure());
                }
                if (FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getLeft()) && FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getRight()) || FilterUtil.checkIfRightExpressionRequireEvaluation(currentCondExpression.getRight()) || FilterUtil.checkIfLeftExpressionRequireEvaluation(currentCondExpression.getLeft())) {
                    return new RowLevelFilterResolverImpl(expression, isExpressionResolve, true, tableIdentifier);
                }
                if (currentCondExpression.getFilterExpressionType() == ExpressionType.GREATERTHAN || currentCondExpression.getFilterExpressionType() == ExpressionType.LESSTHAN || currentCondExpression.getFilterExpressionType() == ExpressionType.GREATERTHAN_EQUALTO || currentCondExpression.getFilterExpressionType() == ExpressionType.LESSTHAN_EQUALTO) {
                    return new RowLevelRangeFilterResolverImpl(expression, isExpressionResolve, true, tableIdentifier);
                }
                return new ConditionalFilterResolverImpl(expression, isExpressionResolve, true, currentCondExpression.getColumnList().get(0).getCarbonColumn().isMeasure());
            }
            case RANGE: {
                return new ConditionalFilterResolverImpl(expression, isExpressionResolve, true, false);
            }
            case NOT_EQUALS: {
                currentCondExpression = (BinaryConditionalExpression)expression;
                CarbonColumn column = currentCondExpression.getColumnList().get(0).getCarbonColumn();
                if (!currentCondExpression.isSingleColumn() || column.getDataType().isComplexType()) break;
                if (column.isMeasure().booleanValue()) {
                    if (FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getLeft()) && FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getRight()) || FilterUtil.checkIfRightExpressionRequireEvaluation(currentCondExpression.getRight()) || FilterUtil.checkIfLeftExpressionRequireEvaluation(currentCondExpression.getLeft())) {
                        return new RowLevelFilterResolverImpl(expression, isExpressionResolve, false, tableIdentifier);
                    }
                    if (currentCondExpression.getFilterExpressionType() == ExpressionType.GREATERTHAN || currentCondExpression.getFilterExpressionType() == ExpressionType.LESSTHAN || currentCondExpression.getFilterExpressionType() == ExpressionType.GREATERTHAN_EQUALTO || currentCondExpression.getFilterExpressionType() == ExpressionType.LESSTHAN_EQUALTO) {
                        return new RowLevelRangeFilterResolverImpl(expression, isExpressionResolve, false, tableIdentifier);
                    }
                    return new ConditionalFilterResolverImpl(expression, isExpressionResolve, false, true);
                }
                if (FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getLeft()) && FilterUtil.checkIfExpressionContainsColumn(currentCondExpression.getRight()) || FilterUtil.checkIfRightExpressionRequireEvaluation(currentCondExpression.getRight()) || FilterUtil.checkIfLeftExpressionRequireEvaluation(currentCondExpression.getLeft())) {
                    return new RowLevelFilterResolverImpl(expression, isExpressionResolve, false, tableIdentifier);
                }
                if (expressionTree.getFilterExpressionType() == ExpressionType.GREATERTHAN || expressionTree.getFilterExpressionType() == ExpressionType.LESSTHAN || expressionTree.getFilterExpressionType() == ExpressionType.GREATERTHAN_EQUALTO || expressionTree.getFilterExpressionType() == ExpressionType.LESSTHAN_EQUALTO) {
                    return new RowLevelRangeFilterResolverImpl(expression, isExpressionResolve, false, tableIdentifier);
                }
                return new ConditionalFilterResolverImpl(expression, isExpressionResolve, false, false);
            }
            default: {
                if (!(expression instanceof ConditionalExpression)) break;
                condExpression = (ConditionalExpression)((Object)expression);
                CarbonColumn column = condExpression.getColumnList().get(0).getCarbonColumn();
                if (!condExpression.isSingleColumn() || column.isComplex().booleanValue() || !(condExpression = (ConditionalExpression)((Object)expression)).getColumnList().get(0).getCarbonColumn().isMeasure().booleanValue()) break;
                return new ConditionalFilterResolverImpl(expression, true, true, condExpression.getColumnList().get(0).getCarbonColumn().isMeasure());
            }
        }
        return new RowLevelFilterResolverImpl(expression, false, false, tableIdentifier);
    }

    public static boolean isScanRequired(FilterExecuter filterExecuter, byte[][] maxValue, byte[][] minValue, boolean[] isMinMaxSet) {
        if (filterExecuter instanceof ImplicitColumnFilterExecutor) {
            return ((ImplicitColumnFilterExecutor)((Object)filterExecuter)).isFilterValuesPresentInAbstractIndex(maxValue, minValue, isMinMaxSet);
        }
        BitSet bitSet = filterExecuter.isScanRequired(maxValue, minValue, isMinMaxSet);
        return !bitSet.isEmpty();
    }

    public Expression removeUnknownExpression(Expression expressionTree) {
        ExpressionType filterExpressionType = expressionTree.getFilterExpressionType();
        BinaryExpression currentExpression = null;
        switch (filterExpressionType) {
            case OR: {
                currentExpression = (BinaryExpression)expressionTree;
                return new OrExpression(this.removeUnknownExpression(currentExpression.getLeft()), this.removeUnknownExpression(currentExpression.getRight()));
            }
            case AND: {
                currentExpression = (BinaryExpression)expressionTree;
                return new AndExpression(this.removeUnknownExpression(currentExpression.getLeft()), this.removeUnknownExpression(currentExpression.getRight()));
            }
            case UNKNOWN: {
                return new TrueExpression(null);
            }
        }
        return expressionTree;
    }

    public FilterResolverIntf changeUnknownResloverToTrue(AbsoluteTableIdentifier tableIdentifier) {
        return this.getFilterResolverBasedOnExpressionType(ExpressionType.TRUE, false, new TrueExpression(null), tableIdentifier, new TrueExpression(null));
    }
}

