/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.keygenerator.factory.KeyGeneratorFactory;
import org.apache.carbondata.core.keygenerator.mdkey.MultiDimKeyVarLengthGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.ConditionalExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.ImplicitExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.ListExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.core.scan.expression.logical.TrueExpression;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.filter.executer.AndFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.DimColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.executer.ExcludeFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.FalseFilterExecutor;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.ImplicitIncludeFilterExecutorImpl;
import org.apache.carbondata.core.scan.filter.executer.IncludeFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.MeasureColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.executer.OrFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.RangeValueFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.RestructureExcludeFilterExecutorImpl;
import org.apache.carbondata.core.scan.filter.executer.RestructureIncludeFilterExecutorImpl;
import org.apache.carbondata.core.scan.filter.executer.RowLevelFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.RowLevelRangeTypeExecuterFactory;
import org.apache.carbondata.core.scan.filter.executer.TrueFilterExecutor;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;
import org.apache.carbondata.core.scan.filter.intf.RowImpl;
import org.apache.carbondata.core.scan.filter.resolver.ConditionalFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.filter.resolver.RowLevelFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.RowLevelRangeFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.ColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.result.vector.CarbonDictionary;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;
import org.apache.log4j.Logger;

public final class FilterUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)FilterUtil.class.getName());

    private FilterUtil() {
    }

    private static FilterExecuter createFilterExecuterTree(FilterResolverIntf filterExpressionResolverTree, SegmentProperties segmentProperties, Map<Integer, GenericQueryType> complexDimensionInfoMap, List<CarbonColumn> minMaxCacheColumns, boolean isStreamDataFile) {
        FilterExecuterType filterExecuterType = filterExpressionResolverTree.getFilterExecuterType();
        if (null != filterExecuterType) {
            switch (filterExecuterType) {
                case INCLUDE: {
                    if (null != filterExpressionResolverTree.getDimColResolvedFilterInfo() && null != filterExpressionResolverTree.getDimColResolvedFilterInfo().getFilterValues() && filterExpressionResolverTree.getDimColResolvedFilterInfo().getFilterValues().isOptimized()) {
                        return FilterUtil.getExcludeFilterExecuter(filterExpressionResolverTree.getDimColResolvedFilterInfo(), filterExpressionResolverTree.getMsrColResolvedFilterInfo(), segmentProperties);
                    }
                    if (FilterUtil.checkIfCurrentNodeToBeReplacedWithTrueFilterExpression(filterExpressionResolverTree, segmentProperties, minMaxCacheColumns, isStreamDataFile)) {
                        return new TrueFilterExecutor();
                    }
                    return FilterUtil.getIncludeFilterExecuter(filterExpressionResolverTree.getDimColResolvedFilterInfo(), filterExpressionResolverTree.getMsrColResolvedFilterInfo(), segmentProperties);
                }
                case EXCLUDE: {
                    return FilterUtil.getExcludeFilterExecuter(filterExpressionResolverTree.getDimColResolvedFilterInfo(), filterExpressionResolverTree.getMsrColResolvedFilterInfo(), segmentProperties);
                }
                case OR: {
                    return new OrFilterExecuterImpl(FilterUtil.createFilterExecuterTree(filterExpressionResolverTree.getLeft(), segmentProperties, complexDimensionInfoMap, minMaxCacheColumns, isStreamDataFile), FilterUtil.createFilterExecuterTree(filterExpressionResolverTree.getRight(), segmentProperties, complexDimensionInfoMap, minMaxCacheColumns, isStreamDataFile));
                }
                case AND: {
                    return new AndFilterExecuterImpl(FilterUtil.createFilterExecuterTree(filterExpressionResolverTree.getLeft(), segmentProperties, complexDimensionInfoMap, minMaxCacheColumns, isStreamDataFile), FilterUtil.createFilterExecuterTree(filterExpressionResolverTree.getRight(), segmentProperties, complexDimensionInfoMap, minMaxCacheColumns, isStreamDataFile));
                }
                case ROWLEVEL_LESSTHAN: 
                case ROWLEVEL_LESSTHAN_EQUALTO: 
                case ROWLEVEL_GREATERTHAN_EQUALTO: 
                case ROWLEVEL_GREATERTHAN: {
                    RowLevelRangeFilterResolverImpl rowLevelRangeFilterResolver = (RowLevelRangeFilterResolverImpl)filterExpressionResolverTree;
                    if (FilterUtil.checkIfCurrentNodeToBeReplacedWithTrueFilterExpression(rowLevelRangeFilterResolver.getDimColEvaluatorInfoList(), rowLevelRangeFilterResolver.getMsrColEvalutorInfoList(), segmentProperties, minMaxCacheColumns, isStreamDataFile)) {
                        return new TrueFilterExecutor();
                    }
                    return RowLevelRangeTypeExecuterFactory.getRowLevelRangeTypeExecuter(filterExecuterType, filterExpressionResolverTree, segmentProperties);
                }
                case RANGE: {
                    if (FilterUtil.checkIfCurrentNodeToBeReplacedWithTrueFilterExpression(filterExpressionResolverTree, segmentProperties, minMaxCacheColumns, isStreamDataFile)) {
                        return new TrueFilterExecutor();
                    }
                    return new RangeValueFilterExecuterImpl(filterExpressionResolverTree.getDimColResolvedFilterInfo(), filterExpressionResolverTree.getFilterExpression(), ((ConditionalFilterResolverImpl)filterExpressionResolverTree).getFilterRangeValues(segmentProperties), segmentProperties);
                }
                case TRUE: {
                    return new TrueFilterExecutor();
                }
                case FALSE: {
                    return new FalseFilterExecutor();
                }
            }
            return new RowLevelFilterExecuterImpl(((RowLevelFilterResolverImpl)filterExpressionResolverTree).getDimColEvaluatorInfoList(), ((RowLevelFilterResolverImpl)filterExpressionResolverTree).getMsrColEvalutorInfoList(), ((RowLevelFilterResolverImpl)filterExpressionResolverTree).getFilterExpresion(), ((RowLevelFilterResolverImpl)filterExpressionResolverTree).getTableIdentifier(), segmentProperties, complexDimensionInfoMap);
        }
        return new RowLevelFilterExecuterImpl(((RowLevelFilterResolverImpl)filterExpressionResolverTree).getDimColEvaluatorInfoList(), ((RowLevelFilterResolverImpl)filterExpressionResolverTree).getMsrColEvalutorInfoList(), ((RowLevelFilterResolverImpl)filterExpressionResolverTree).getFilterExpresion(), ((RowLevelFilterResolverImpl)filterExpressionResolverTree).getTableIdentifier(), segmentProperties, complexDimensionInfoMap);
    }

    private static FilterExecuter getIncludeFilterExecuter(DimColumnResolvedFilterInfo dimColResolvedFilterInfo, MeasureColumnResolvedFilterInfo msrColResolvedFilterInfo, SegmentProperties segmentProperties) {
        if (null != msrColResolvedFilterInfo && msrColResolvedFilterInfo.getMeasure().isMeasure().booleanValue()) {
            CarbonMeasure measuresFromCurrentBlock = segmentProperties.getMeasureFromCurrentBlock(msrColResolvedFilterInfo.getMeasure());
            if (null != measuresFromCurrentBlock) {
                MeasureColumnResolvedFilterInfo msrColResolvedFilterInfoCopyObject = msrColResolvedFilterInfo.getCopyObject();
                msrColResolvedFilterInfoCopyObject.setMeasure(measuresFromCurrentBlock);
                msrColResolvedFilterInfoCopyObject.setColumnIndex(measuresFromCurrentBlock.getOrdinal());
                msrColResolvedFilterInfoCopyObject.setType(measuresFromCurrentBlock.getDataType());
                return new IncludeFilterExecuterImpl(null, msrColResolvedFilterInfoCopyObject, segmentProperties, true);
            }
            return new RestructureIncludeFilterExecutorImpl(dimColResolvedFilterInfo, msrColResolvedFilterInfo, true);
        }
        CarbonDimension dimension = dimColResolvedFilterInfo.getDimension();
        if (dimension.hasEncoding(Encoding.IMPLICIT)) {
            return new ImplicitIncludeFilterExecutorImpl(dimColResolvedFilterInfo);
        }
        CarbonDimension dimensionFromCurrentBlock = segmentProperties.getDimensionFromCurrentBlock(dimColResolvedFilterInfo.getDimension());
        if (null != dimensionFromCurrentBlock) {
            DimColumnResolvedFilterInfo dimColResolvedFilterInfoCopyObject = dimColResolvedFilterInfo.getCopyObject();
            dimColResolvedFilterInfoCopyObject.setDimension(dimensionFromCurrentBlock);
            dimColResolvedFilterInfoCopyObject.setColumnIndex(dimensionFromCurrentBlock.getOrdinal());
            return new IncludeFilterExecuterImpl(dimColResolvedFilterInfoCopyObject, null, segmentProperties, false);
        }
        return new RestructureIncludeFilterExecutorImpl(dimColResolvedFilterInfo, msrColResolvedFilterInfo, false);
    }

    private static boolean checkIfCurrentNodeToBeReplacedWithTrueFilterExpression(List<DimColumnResolvedFilterInfo> dimColEvaluatorInfoList, List<MeasureColumnResolvedFilterInfo> msrColEvaluatorInfoList, SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, boolean isStreamDataFile) {
        boolean replaceCurrentNodeWithTrueFilter = false;
        ColumnResolvedFilterInfo columnResolvedFilterInfo = null;
        if (!msrColEvaluatorInfoList.isEmpty()) {
            columnResolvedFilterInfo = msrColEvaluatorInfoList.get(0);
            replaceCurrentNodeWithTrueFilter = FilterUtil.checkIfFilterColumnIsCachedInDriver(columnResolvedFilterInfo, segmentProperties, minMaxCacheColumns, true, isStreamDataFile);
        } else {
            columnResolvedFilterInfo = dimColEvaluatorInfoList.get(0);
            if (!columnResolvedFilterInfo.getDimension().hasEncoding(Encoding.IMPLICIT)) {
                replaceCurrentNodeWithTrueFilter = FilterUtil.checkIfFilterColumnIsCachedInDriver(columnResolvedFilterInfo, segmentProperties, minMaxCacheColumns, false, isStreamDataFile);
            }
        }
        return replaceCurrentNodeWithTrueFilter;
    }

    private static boolean checkIfCurrentNodeToBeReplacedWithTrueFilterExpression(FilterResolverIntf filterExpressionResolverTree, SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, boolean isStreamDataFile) {
        boolean replaceCurrentNodeWithTrueFilter = false;
        ColumnResolvedFilterInfo columnResolvedFilterInfo = null;
        if (null != filterExpressionResolverTree.getMsrColResolvedFilterInfo()) {
            columnResolvedFilterInfo = filterExpressionResolverTree.getMsrColResolvedFilterInfo();
            replaceCurrentNodeWithTrueFilter = FilterUtil.checkIfFilterColumnIsCachedInDriver(columnResolvedFilterInfo, segmentProperties, minMaxCacheColumns, true, isStreamDataFile);
        } else {
            columnResolvedFilterInfo = filterExpressionResolverTree.getDimColResolvedFilterInfo();
            if (!columnResolvedFilterInfo.getDimension().hasEncoding(Encoding.IMPLICIT)) {
                replaceCurrentNodeWithTrueFilter = FilterUtil.checkIfFilterColumnIsCachedInDriver(columnResolvedFilterInfo, segmentProperties, minMaxCacheColumns, false, isStreamDataFile);
            }
        }
        return replaceCurrentNodeWithTrueFilter;
    }

    private static boolean checkIfFilterColumnIsCachedInDriver(ColumnResolvedFilterInfo columnResolvedFilterInfo, SegmentProperties segmentProperties, List<CarbonColumn> minMaxCacheColumns, boolean isMeasure, boolean isStreamDataFile) {
        boolean replaceCurrentNodeWithTrueFilter = false;
        CarbonColumn columnFromCurrentBlock = null;
        columnFromCurrentBlock = isMeasure ? segmentProperties.getMeasureFromCurrentBlock(columnResolvedFilterInfo.getMeasure()) : segmentProperties.getDimensionFromCurrentBlock(columnResolvedFilterInfo.getDimension());
        if (null != columnFromCurrentBlock) {
            if (null != minMaxCacheColumns) {
                int columnIndexInMinMaxByteArray = FilterUtil.getFilterColumnIndexInCachedColumns(minMaxCacheColumns, columnFromCurrentBlock);
                if (columnIndexInMinMaxByteArray != -1) {
                    columnResolvedFilterInfo.setColumnIndexInMinMaxByteArray(columnIndexInMinMaxByteArray);
                } else {
                    replaceCurrentNodeWithTrueFilter = true;
                }
            } else if (isMeasure) {
                if (isStreamDataFile) {
                    columnResolvedFilterInfo.setColumnIndexInMinMaxByteArray(segmentProperties.getDimensions().size() + columnFromCurrentBlock.getOrdinal());
                } else {
                    columnResolvedFilterInfo.setColumnIndexInMinMaxByteArray(segmentProperties.getLastDimensionColOrdinal() + columnFromCurrentBlock.getOrdinal());
                }
            } else {
                columnResolvedFilterInfo.setColumnIndexInMinMaxByteArray(columnFromCurrentBlock.getOrdinal());
            }
        }
        return replaceCurrentNodeWithTrueFilter;
    }

    private static int getFilterColumnIndexInCachedColumns(List<CarbonColumn> carbonDimensionsToBeCached, CarbonColumn filterColumn) {
        int columnIndexInMinMaxByteArray = -1;
        int columnCounter = 0;
        for (CarbonColumn cachedColumn : carbonDimensionsToBeCached) {
            if (cachedColumn.getColumnId().equalsIgnoreCase(filterColumn.getColumnId())) {
                columnIndexInMinMaxByteArray = columnCounter;
                break;
            }
            ++columnCounter;
        }
        return columnIndexInMinMaxByteArray;
    }

    private static FilterExecuter getExcludeFilterExecuter(DimColumnResolvedFilterInfo dimColResolvedFilterInfo, MeasureColumnResolvedFilterInfo msrColResolvedFilterInfo, SegmentProperties segmentProperties) {
        if (null != msrColResolvedFilterInfo && msrColResolvedFilterInfo.getMeasure().isMeasure().booleanValue()) {
            CarbonMeasure measuresFromCurrentBlock = segmentProperties.getMeasureFromCurrentBlock(msrColResolvedFilterInfo.getMeasure());
            if (null != measuresFromCurrentBlock) {
                MeasureColumnResolvedFilterInfo msrColResolvedFilterInfoCopyObject = msrColResolvedFilterInfo.getCopyObject();
                msrColResolvedFilterInfoCopyObject.setMeasure(measuresFromCurrentBlock);
                msrColResolvedFilterInfoCopyObject.setColumnIndex(measuresFromCurrentBlock.getOrdinal());
                msrColResolvedFilterInfoCopyObject.setType(measuresFromCurrentBlock.getDataType());
                return new ExcludeFilterExecuterImpl(null, msrColResolvedFilterInfoCopyObject, segmentProperties, true);
            }
            return new RestructureExcludeFilterExecutorImpl(dimColResolvedFilterInfo, msrColResolvedFilterInfo, true);
        }
        CarbonDimension dimensionFromCurrentBlock = segmentProperties.getDimensionFromCurrentBlock(dimColResolvedFilterInfo.getDimension());
        if (null != dimensionFromCurrentBlock) {
            DimColumnResolvedFilterInfo dimColResolvedFilterInfoCopyObject = dimColResolvedFilterInfo.getCopyObject();
            dimColResolvedFilterInfoCopyObject.setDimension(dimensionFromCurrentBlock);
            dimColResolvedFilterInfoCopyObject.setColumnIndex(dimensionFromCurrentBlock.getOrdinal());
            return new ExcludeFilterExecuterImpl(dimColResolvedFilterInfoCopyObject, null, segmentProperties, false);
        }
        return new RestructureExcludeFilterExecutorImpl(dimColResolvedFilterInfo, msrColResolvedFilterInfo, false);
    }

    public static boolean checkIfExpressionContainsColumn(Expression expression) {
        if (expression instanceof ColumnExpression) {
            return true;
        }
        for (Expression child : expression.getChildren()) {
            if (!FilterUtil.checkIfExpressionContainsColumn(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfLeftExpressionRequireEvaluation(Expression expression) {
        if (expression.getFilterExpressionType() == ExpressionType.UNKNOWN || !(expression instanceof ColumnExpression)) {
            return true;
        }
        for (Expression child : expression.getChildren()) {
            if (!FilterUtil.checkIfLeftExpressionRequireEvaluation(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfDataTypeNotTimeStamp(Expression expression) {
        DataType dataType;
        if (expression.getFilterExpressionType() == ExpressionType.LITERAL && expression instanceof LiteralExpression && (dataType = ((LiteralExpression)expression).getLiteralExpDataType()) != DataTypes.TIMESTAMP && dataType != DataTypes.DATE) {
            return true;
        }
        for (Expression child : expression.getChildren()) {
            if (!FilterUtil.checkIfDataTypeNotTimeStamp(child)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkIfRightExpressionRequireEvaluation(Expression expression) {
        if (expression.getFilterExpressionType() == ExpressionType.UNKNOWN || !(expression instanceof LiteralExpression) && !(expression instanceof ListExpression)) {
            return true;
        }
        for (Expression child : expression.getChildren()) {
            if (!FilterUtil.checkIfRightExpressionRequireEvaluation(child)) continue;
            return true;
        }
        return false;
    }

    public static ColumnFilterInfo getNoDictionaryValKeyMemberForFilter(List<String> evaluateResultListFinal, boolean isIncludeFilter, DataType dataType) throws FilterUnsupportedException {
        ArrayList<byte[]> filterValuesList = new ArrayList<byte[]>(20);
        String result = null;
        try {
            int length = evaluateResultListFinal.size();
            String timeFormat = CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < length; ++i) {
                result = evaluateResultListFinal.get(i);
                if ("@NU#LL$!".equals(result)) {
                    if (dataType == DataTypes.STRING) {
                        filterValuesList.add(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY);
                        continue;
                    }
                    filterValuesList.add(CarbonCommonConstants.EMPTY_BYTE_ARRAY);
                    continue;
                }
                filterValuesList.add(DataTypeUtil.getBytesBasedOnDataTypeForNoDictionaryColumn(result, dataType, timeFormat));
            }
        }
        catch (Throwable ex) {
            throw new FilterUnsupportedException("Unsupported Filter condition: " + result, ex);
        }
        java.util.Comparator<byte[]> filterNoDictValueComaparator = new java.util.Comparator<byte[]>(){

            @Override
            public int compare(byte[] filterMember1, byte[] filterMember2) {
                return ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterMember1, filterMember2);
            }
        };
        Collections.sort(filterValuesList, filterNoDictValueComaparator);
        ColumnFilterInfo columnFilterInfo = null;
        if (filterValuesList.size() > 0) {
            columnFilterInfo = new ColumnFilterInfo();
            columnFilterInfo.setIncludeFilter(isIncludeFilter);
            columnFilterInfo.setFilterListForNoDictionaryCols(filterValuesList);
        }
        return columnFilterInfo;
    }

    public static ColumnFilterInfo getMeasureValKeyMemberForFilter(List<String> evaluateResultListFinal, boolean isIncludeFilter, DataType dataType, CarbonMeasure carbonMeasure) throws FilterUnsupportedException {
        ArrayList<Object> filterValuesList = new ArrayList<Object>(20);
        String result = null;
        try {
            int length = evaluateResultListFinal.size();
            for (int i = 0; i < length; ++i) {
                result = evaluateResultListFinal.get(i);
                if ("@NU#LL$!".equals(result)) {
                    filterValuesList.add(null);
                    continue;
                }
                filterValuesList.add(DataTypeUtil.getMeasureValueBasedOnDataType(result, dataType, carbonMeasure.getScale(), carbonMeasure.getPrecision()));
            }
        }
        catch (Throwable ex) {
            throw new FilterUnsupportedException("Unsupported Filter condition: " + result, ex);
        }
        SerializableComparator filterMeasureComaparator = Comparator.getComparatorByDataTypeForMeasure(dataType);
        Collections.sort(filterValuesList, filterMeasureComaparator);
        ColumnFilterInfo columnFilterInfo = null;
        if (filterValuesList.size() > 0) {
            columnFilterInfo = new ColumnFilterInfo();
            columnFilterInfo.setIncludeFilter(isIncludeFilter);
            columnFilterInfo.setMeasuresFilterValuesList(filterValuesList);
        }
        return columnFilterInfo;
    }

    public static DataType getMeasureDataType(MeasureColumnResolvedFilterInfo msrColumnEvaluatorInfo) {
        if (msrColumnEvaluatorInfo.getType() == DataTypes.BOOLEAN) {
            return DataTypes.BOOLEAN;
        }
        if (msrColumnEvaluatorInfo.getType() == DataTypes.SHORT) {
            return DataTypes.SHORT;
        }
        if (msrColumnEvaluatorInfo.getType() == DataTypes.INT) {
            return DataTypes.INT;
        }
        if (msrColumnEvaluatorInfo.getType() == DataTypes.LONG) {
            return DataTypes.LONG;
        }
        if (msrColumnEvaluatorInfo.getType() == DataTypes.FLOAT) {
            return DataTypes.FLOAT;
        }
        if (msrColumnEvaluatorInfo.getType() == DataTypes.BYTE) {
            return DataTypes.BYTE;
        }
        if (DataTypes.isDecimal(msrColumnEvaluatorInfo.getType())) {
            return DataTypes.createDefaultDecimalType();
        }
        return DataTypes.DOUBLE;
    }

    public static boolean isExcludeFilterNeedsToApply(int dictionarySize, int size) {
        if (size * 100 / dictionarySize >= 60) {
            LOGGER.info((Object)"Applying CBO to convert include filter to exclude filter.");
            return true;
        }
        return false;
    }

    private static byte[][] getFilterValuesInBytes(ColumnFilterInfo columnFilterInfo, boolean isExclude, int[] keys, List<byte[]> filterValuesList, int keyOrdinalOfDimensionFromCurrentBlock) {
        if (null != columnFilterInfo) {
            List<Integer> listOfsurrogates = null;
            if (!isExclude && columnFilterInfo.isIncludeFilter()) {
                listOfsurrogates = columnFilterInfo.getFilterList();
            } else if (isExclude || !columnFilterInfo.isIncludeFilter()) {
                listOfsurrogates = columnFilterInfo.getExcludeFilterList();
            }
            if (null != listOfsurrogates) {
                for (Integer surrogate : listOfsurrogates) {
                    keys[keyOrdinalOfDimensionFromCurrentBlock] = surrogate;
                    filterValuesList.add(ByteUtil.convertIntToBytes(surrogate));
                }
            }
        }
        return (byte[][])filterValuesList.toArray((T[])new byte[filterValuesList.size()][]);
    }

    private static byte[][] getFilterValueInBytesForDictRange(ColumnFilterInfo columnFilterInfo, int[] keys, List<byte[]> filterValuesList, int keyOrdinalOfDimensionFromCurrentBlock) {
        if (null != columnFilterInfo) {
            List<Integer> listOfsurrogates = columnFilterInfo.getFilterList();
            if (listOfsurrogates == null || listOfsurrogates.size() > 1) {
                throw new RuntimeException("Filter values cannot be null in case of range in dictionary include");
            }
            keys[keyOrdinalOfDimensionFromCurrentBlock] = listOfsurrogates.get(0);
            filterValuesList.add(ByteUtil.convertIntToBytes(listOfsurrogates.get(0)));
        }
        return (byte[][])filterValuesList.toArray((T[])new byte[filterValuesList.size()][]);
    }

    public static byte[][] getKeyArray(ColumnFilterInfo columnFilterInfo, boolean isExclude) {
        int[] dimColumnsCardinality = new int[]{Integer.MAX_VALUE};
        int[] dimensionBitLength = CarbonUtil.getDimensionBitLength(dimColumnsCardinality, new int[]{1});
        MultiDimKeyVarLengthGenerator blockLevelKeyGenerator = new MultiDimKeyVarLengthGenerator(dimensionBitLength);
        int[] keys = new int[blockLevelKeyGenerator.getDimCount()];
        Arrays.fill(keys, 0);
        int keyOrdinalOfDimensionFromCurrentBlock = 0;
        ArrayList<byte[]> filterValuesList = new ArrayList<byte[]>(16);
        return FilterUtil.getFilterValuesInBytes(columnFilterInfo, isExclude, keys, filterValuesList, keyOrdinalOfDimensionFromCurrentBlock);
    }

    public static byte[][] getKeyArray(ColumnFilterInfo columnFilterInfo, CarbonDimension carbonDimension, SegmentProperties segmentProperties, boolean isExclude, boolean isDictRange) {
        if (carbonDimension.getDataType() != DataTypes.DATE) {
            return (byte[][])columnFilterInfo.getNoDictionaryFilterValuesList().toArray((T[])new byte[columnFilterInfo.getNoDictionaryFilterValuesList().size()][]);
        }
        int[] keys = new int[segmentProperties.getDimensions().size()];
        ArrayList<byte[]> filterValuesList = new ArrayList<byte[]>(20);
        Arrays.fill(keys, 0);
        int keyOrdinalOfDimensionFromCurrentBlock = carbonDimension.getKeyOrdinal();
        if (!isDictRange) {
            return FilterUtil.getFilterValuesInBytes(columnFilterInfo, isExclude, keys, filterValuesList, keyOrdinalOfDimensionFromCurrentBlock);
        }
        return FilterUtil.getFilterValueInBytesForDictRange(columnFilterInfo, keys, filterValuesList, keyOrdinalOfDimensionFromCurrentBlock);
    }

    public static FilterExecuter getFilterExecuterTree(FilterResolverIntf filterExpressionResolverTree, SegmentProperties segmentProperties, Map<Integer, GenericQueryType> complexDimensionInfoMap, boolean isStreamDataFile) {
        return FilterUtil.getFilterExecuterTree(filterExpressionResolverTree, segmentProperties, complexDimensionInfoMap, null, isStreamDataFile);
    }

    public static FilterExecuter getFilterExecuterTree(FilterResolverIntf filterExpressionResolverTree, SegmentProperties segmentProperties, Map<Integer, GenericQueryType> complexDimensionInfoMap, List<CarbonColumn> minMaxCacheColumns, boolean isStreamDataFile) {
        return FilterUtil.createFilterExecuterTree(filterExpressionResolverTree, segmentProperties, complexDimensionInfoMap, minMaxCacheColumns, isStreamDataFile);
    }

    public static void prepareKeysFromSurrogates(ColumnFilterInfo filterValues, SegmentProperties segmentProperties, CarbonDimension dimension, DimColumnExecuterFilterInfo dimColumnExecuterInfo, CarbonMeasure measures, MeasureColumnExecuterFilterInfo msrColumnExecuterInfo) {
        if (null != measures) {
            DataType filterColumnDataType = DataTypes.valueOf(measures.getDataType().getId());
            DataTypeConverterImpl converter = new DataTypeConverterImpl();
            Object[] keysBasedOnFilter = filterValues.getMeasuresFilterValuesList().toArray(new Object[filterValues.getMeasuresFilterValuesList().size()]);
            for (int i = 0; i < keysBasedOnFilter.length; ++i) {
                if (keysBasedOnFilter[i] == null) continue;
                keysBasedOnFilter[i] = DataTypeUtil.getDataBasedOnDataType(keysBasedOnFilter[i].toString(), filterColumnDataType, converter);
            }
            msrColumnExecuterInfo.setFilterKeys(keysBasedOnFilter, filterColumnDataType);
        } else if (filterValues == null) {
            dimColumnExecuterInfo.setFilterKeys(new byte[0][]);
        } else {
            byte[][] keysBasedOnFilter = FilterUtil.getKeyArray(filterValues, dimension, segmentProperties, false, false);
            if (!filterValues.isIncludeFilter() || filterValues.isOptimized()) {
                dimColumnExecuterInfo.setExcludeFilterKeys(FilterUtil.getKeyArray(filterValues, dimension, segmentProperties, true, false));
            }
            dimColumnExecuterInfo.setFilterKeys(keysBasedOnFilter);
        }
    }

    public static int compareFilterKeyBasedOnDataType(String dictionaryVal, String memberVal, DataType dataType) {
        try {
            if (dataType == DataTypes.BOOLEAN) {
                return Boolean.compare(Boolean.parseBoolean(dictionaryVal), Boolean.parseBoolean(memberVal));
            }
            if (dataType == DataTypes.SHORT) {
                return Short.compare(Short.parseShort(dictionaryVal), Short.parseShort(memberVal));
            }
            if (dataType == DataTypes.INT) {
                return Integer.compare(Integer.parseInt(dictionaryVal), Integer.parseInt(memberVal));
            }
            if (dataType == DataTypes.DOUBLE) {
                return Double.compare(Double.parseDouble(dictionaryVal), Double.parseDouble(memberVal));
            }
            if (dataType == DataTypes.LONG) {
                return Long.compare(Long.parseLong(dictionaryVal), Long.parseLong(memberVal));
            }
            if (dataType == DataTypes.BOOLEAN) {
                return Boolean.compare(Boolean.parseBoolean(dictionaryVal), Boolean.parseBoolean(memberVal));
            }
            if (dataType == DataTypes.DATE || dataType == DataTypes.TIMESTAMP) {
                String format = CarbonUtil.getFormatFromProperty(dataType);
                SimpleDateFormat parser = new SimpleDateFormat(format);
                Date dateToStr = parser.parse(memberVal);
                Date dictionaryDate = parser.parse(dictionaryVal);
                return dictionaryDate.compareTo(dateToStr);
            }
            if (DataTypes.isDecimal(dataType)) {
                BigDecimal javaDecValForDictVal = new BigDecimal(dictionaryVal);
                BigDecimal javaDecValForMemberVal = new BigDecimal(memberVal);
                return javaDecValForDictVal.compareTo(javaDecValForMemberVal);
            }
            return -1;
        }
        catch (NumberFormatException | ParseException e) {
            return -1;
        }
    }

    public static boolean isExpressionNeedsToResolved(Expression rightExp, boolean isIncludeFilter) {
        if (!isIncludeFilter && rightExp instanceof LiteralExpression && DataTypes.NULL == ((LiteralExpression)rightExp).getLiteralExpDataType()) {
            return true;
        }
        for (Expression child : rightExp.getChildren()) {
            if (!FilterUtil.isExpressionNeedsToResolved(child, isIncludeFilter)) continue;
            return true;
        }
        return false;
    }

    public static void logError(Throwable e, boolean invalidRowsPresent) {
        if (!invalidRowsPresent) {
            LOGGER.error((Object)(" Invalid Record(s) are present while filter evaluation. " + e.getMessage()), e);
        }
    }

    public static boolean nanSafeEqualsDoubles(Double d1, Double d2) {
        return d1.doubleValue() == d2.doubleValue() || Double.isNaN(d1) && Double.isNaN(d2);
    }

    public static BitSetGroup createBitSetGroupWithDefaultValue(int pageCount, int totalRowCount, boolean defaultValue) {
        BitSetGroup bitSetGroup = new BitSetGroup(pageCount);
        int numberOfRows = 32000;
        int pagesTobeFullFilled = totalRowCount / numberOfRows;
        int rowCountForLastPage = totalRowCount % numberOfRows;
        for (int i = 0; i < pagesTobeFullFilled; ++i) {
            BitSet bitSet = new BitSet(numberOfRows);
            bitSet.set(0, numberOfRows, defaultValue);
            bitSetGroup.setBitSet(bitSet, i);
        }
        if (rowCountForLastPage > 0) {
            BitSet bitSet = new BitSet(rowCountForLastPage);
            bitSet.set(0, rowCountForLastPage, defaultValue);
            bitSetGroup.setBitSet(bitSet, pagesTobeFullFilled);
        }
        return bitSetGroup;
    }

    public static void removeNullValues(DimensionColumnPage dimensionColumnPage, BitSet bitSet, byte[] defaultValue) {
        block4: {
            block5: {
                if (bitSet.isEmpty()) break block4;
                if (null == dimensionColumnPage.getNullBits()) break block5;
                if (dimensionColumnPage.getNullBits().isEmpty()) break block4;
                int i = bitSet.nextSetBit(0);
                while (i >= 0) {
                    if (dimensionColumnPage.getNullBits().get(i)) {
                        bitSet.flip(i);
                    }
                    i = bitSet.nextSetBit(i + 1);
                }
                break block4;
            }
            int i = bitSet.nextSetBit(0);
            while (i >= 0) {
                if (dimensionColumnPage.compareTo(i, defaultValue) == 0) {
                    bitSet.flip(i);
                }
                i = bitSet.nextSetBit(i + 1);
            }
        }
    }

    public static void updateIndexOfColumnExpression(Expression exp, int dimOridnalMax) {
        if (exp == null) {
            return;
        }
        if (exp.getChildren() == null || exp.getChildren().size() == 0) {
            if (exp instanceof ColumnExpression) {
                ColumnExpression ce = (ColumnExpression)exp;
                CarbonColumn column = ce.getCarbonColumn();
                if (column.isDimension().booleanValue()) {
                    ce.setColIndex(column.getOrdinal());
                } else {
                    ce.setColIndex(dimOridnalMax + column.getOrdinal());
                }
            }
        } else if (exp.getChildren().size() > 0) {
            List<Expression> children = exp.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                FilterUtil.updateIndexOfColumnExpression(children.get(i), dimOridnalMax);
            }
        }
    }

    public static ColumnFilterInfo getImplicitColumnFilterList(Map<String, Set<Integer>> implicitColumnFilterList, boolean isIncludeFilter) {
        ColumnFilterInfo columnFilterInfo = new ColumnFilterInfo();
        columnFilterInfo.setIncludeFilter(isIncludeFilter);
        if (null != implicitColumnFilterList) {
            columnFilterInfo.setImplicitColumnFilterBlockToBlockletsMap(implicitColumnFilterList);
        }
        return columnFilterInfo;
    }

    public static void removeInExpressionNodeWithPositionIdColumn(Expression expression) {
        if (null != FilterUtil.getImplicitFilterExpression(expression)) {
            FilterUtil.setTrueExpressionAsRightChild(expression);
        }
    }

    public static void setTrueExpressionAsRightChild(Expression expression) {
        FilterUtil.setNewExpressionForRightChild(expression, new TrueExpression(null));
    }

    public static void setNewExpressionForRightChild(Expression expression, Expression rightChild) {
        expression.findAndSetChild(((AndExpression)expression).getRight(), rightChild);
        LOGGER.info((Object)"In expression removed from the filter expression list to prevent it from serializing on executor");
    }

    public static Expression getImplicitFilterExpression(Expression expression) {
        Expression childExpression;
        List<Expression> children;
        Expression rightExpression;
        ExpressionType filterExpressionType = expression.getFilterExpressionType();
        if (ExpressionType.AND == filterExpressionType && (rightExpression = ((AndExpression)expression).getRight()) instanceof InExpression && null != (children = rightExpression.getChildren()) && !children.isEmpty() && (childExpression = children.get(0)) instanceof ColumnExpression && ((ColumnExpression)childExpression).getColumnName().equalsIgnoreCase("positionId")) {
            return children.get(1);
        }
        return null;
    }

    public static void createImplicitExpressionAndSetAsRightChild(Expression expression, Map<String, Set<Integer>> blockIdToBlockletIdMapping) {
        ColumnExpression columnExpression = new ColumnExpression("positionId", DataTypes.STRING);
        ImplicitExpression implicitExpression = new ImplicitExpression(blockIdToBlockletIdMapping);
        InExpression inExpression = new InExpression(columnExpression, implicitExpression);
        FilterUtil.setNewExpressionForRightChild(expression, inExpression);
        LOGGER.info((Object)"Implicit expression added to the filter expression");
    }

    public static byte[][] getEncodedFilterValues(CarbonDictionary dictionary, byte[][] actualFilterValues) {
        if (null == dictionary) {
            return actualFilterValues;
        }
        KeyGenerator keyGenerator = KeyGeneratorFactory.getKeyGenerator(new int[]{100000});
        int[] dummy = new int[1];
        ArrayList<byte[]> encodedFilters = new ArrayList<byte[]>();
        block0: for (byte[] actualFilter : actualFilterValues) {
            for (int i = 1; i < dictionary.getDictionarySize(); ++i) {
                if (dictionary.getDictionaryValue(i) == null || ByteUtil.UnsafeComparer.INSTANCE.compareTo(actualFilter, dictionary.getDictionaryValue(i)) != 0) continue;
                dummy[0] = i;
                encodedFilters.add(keyGenerator.generateKey(dummy));
                continue block0;
            }
        }
        return FilterUtil.getSortedEncodedFilters(encodedFilters);
    }

    private static byte[][] getSortedEncodedFilters(List<byte[]> encodedFilters) {
        java.util.Comparator<byte[]> filterNoDictValueComaparator = new java.util.Comparator<byte[]>(){

            @Override
            public int compare(byte[] filterMember1, byte[] filterMember2) {
                return ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterMember1, filterMember2);
            }
        };
        Collections.sort(encodedFilters, filterNoDictValueComaparator);
        return (byte[][])encodedFilters.toArray((T[])new byte[encodedFilters.size()][]);
    }

    private static BitSet getIncludeDictFilterValuesForRange(Expression expression, CarbonDictionary dictionary) throws FilterUnsupportedException {
        ConditionalExpression conExp = (ConditionalExpression)((Object)expression);
        ColumnExpression columnExpression = conExp.getColumnList().get(0);
        BitSet includeFilterBitSet = new BitSet();
        for (int i = 2; i < dictionary.getDictionarySize(); ++i) {
            if (null == dictionary.getDictionaryValue(i)) continue;
            try {
                RowImpl row = new RowImpl();
                String stringValue = new String(dictionary.getDictionaryValue(i), Charset.forName("UTF-8"));
                row.setValues(new Object[]{DataTypeUtil.getDataBasedOnDataType(stringValue, columnExpression.getCarbonColumn().getDataType())});
                Boolean rslt = expression.evaluate(row).getBoolean();
                if (null == rslt || !rslt.booleanValue()) continue;
                includeFilterBitSet.set(i);
                continue;
            }
            catch (FilterIllegalMemberException e) {
                LOGGER.debug((Object)e.getMessage());
            }
        }
        return includeFilterBitSet;
    }

    private static byte[][] getEncodedFilterValuesForRange(BitSet includeDictValues, CarbonDictionary carbonDictionary, boolean useExclude) {
        KeyGenerator keyGenerator = KeyGeneratorFactory.getKeyGenerator(new int[]{100000});
        ArrayList<byte[]> encodedFilterValues = new ArrayList<byte[]>();
        int[] dummy = new int[1];
        if (!useExclude) {
            int i = includeDictValues.nextSetBit(0);
            while (i >= 0) {
                dummy[0] = i;
                encodedFilterValues.add(keyGenerator.generateKey(dummy));
                i = includeDictValues.nextSetBit(i + 1);
            }
            return (byte[][])encodedFilterValues.toArray((T[])new byte[encodedFilterValues.size()][]);
        }
        for (int i = 1; i < carbonDictionary.getDictionarySize(); ++i) {
            if (includeDictValues.get(i) || null == carbonDictionary.getDictionaryValue(i)) continue;
            dummy[0] = i;
            encodedFilterValues.add(keyGenerator.generateKey(dummy));
        }
        return FilterUtil.getSortedEncodedFilters(encodedFilterValues);
    }

    public static FilterExecuter getFilterExecutorForRangeFilters(DimensionRawColumnChunk rawColumnChunk, Expression exp, boolean isNaturalSorted) {
        BitSet includeDictionaryValues;
        try {
            includeDictionaryValues = FilterUtil.getIncludeDictFilterValuesForRange(exp, rawColumnChunk.getLocalDictionary());
        }
        catch (FilterUnsupportedException e) {
            throw new RuntimeException(e);
        }
        boolean isExclude = includeDictionaryValues.cardinality() > 1 && FilterUtil.isExcludeFilterNeedsToApply(rawColumnChunk.getLocalDictionary().getDictionaryActualSize(), includeDictionaryValues.cardinality());
        byte[][] encodedFilterValues = FilterUtil.getEncodedFilterValuesForRange(includeDictionaryValues, rawColumnChunk.getLocalDictionary(), isExclude);
        FilterExecuter filterExecuter = !isExclude ? new IncludeFilterExecuterImpl(encodedFilterValues, isNaturalSorted) : new ExcludeFilterExecuterImpl(encodedFilterValues, isNaturalSorted);
        return filterExecuter;
    }

    public static int compareValues(byte[] filterValue, byte[] minMaxBytes, CarbonDimension carbonDimension, boolean isMin) {
        DataType dataType = carbonDimension.getDataType();
        if (DataTypeUtil.isPrimitiveColumn(dataType) && dataType != DataTypes.DATE) {
            Object value = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(minMaxBytes, dataType);
            Object data = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(filterValue, dataType);
            SerializableComparator comparator = Comparator.getComparator(dataType);
            if (isMin) {
                return comparator.compare(value, data);
            }
            return comparator.compare(data, value);
        }
        if (isMin) {
            return ByteUtil.UnsafeComparer.INSTANCE.compareTo(minMaxBytes, filterValue);
        }
        return ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterValue, minMaxBytes);
    }

    public static byte[] getDefaultNullValue(CarbonDimension currentBlockDimension) {
        DirectDictionaryGenerator directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(currentBlockDimension.getDataType());
        int key = directDictionaryGenerator.generateDirectSurrogateKey(null);
        return ByteUtil.convertIntToBytes(key);
    }

    public static Expression prepareEqualToExpression(String columnName, String dataType, Object value) {
        if (DataTypes.STRING.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.STRING), new LiteralExpression(value, DataTypes.STRING));
        }
        if (DataTypes.INT.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.INT), new LiteralExpression(value, DataTypes.INT));
        }
        if (DataTypes.DOUBLE.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.DOUBLE), new LiteralExpression(value, DataTypes.DOUBLE));
        }
        if (DataTypes.FLOAT.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.FLOAT), new LiteralExpression(value, DataTypes.FLOAT));
        }
        if (DataTypes.SHORT.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.SHORT), new LiteralExpression(value, DataTypes.SHORT));
        }
        if (DataTypes.BINARY.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.BINARY), new LiteralExpression(value, DataTypes.BINARY));
        }
        if (DataTypes.DATE.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.DATE), new LiteralExpression(value, DataTypes.DATE));
        }
        if (DataTypes.LONG.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.LONG), new LiteralExpression(value, DataTypes.LONG));
        }
        if (DataTypes.TIMESTAMP.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.TIMESTAMP), new LiteralExpression(value, DataTypes.TIMESTAMP));
        }
        if (DataTypes.BYTE.getName().equalsIgnoreCase(dataType)) {
            return new EqualToExpression(new ColumnExpression(columnName, DataTypes.BYTE), new LiteralExpression(value, DataTypes.BYTE));
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    public static Expression prepareOrExpression(List<Expression> expressions) {
        if (expressions.size() < 2) {
            throw new RuntimeException("Please input at least two expressions");
        }
        Expression expression = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            expression = new OrExpression(expression, expressions.get(i));
        }
        return expression;
    }

    private static Expression prepareEqualToExpressionSet(String columnName, DataType dataType, List<Object> values) {
        Expression expression = null;
        expression = 0 == values.size() ? FilterUtil.prepareEqualToExpression(columnName, dataType.getName(), null) : FilterUtil.prepareEqualToExpression(columnName, dataType.getName(), values.get(0));
        for (int i = 1; i < values.size(); ++i) {
            Expression expression2 = FilterUtil.prepareEqualToExpression(columnName, dataType.getName(), values.get(i));
            expression = new OrExpression(expression, expression2);
        }
        return expression;
    }

    public static Expression prepareEqualToExpressionSet(String columnName, String dataType, List<Object> values) {
        if (DataTypes.STRING.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.STRING, values);
        }
        if (DataTypes.INT.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.INT, values);
        }
        if (DataTypes.DOUBLE.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.DOUBLE, values);
        }
        if (DataTypes.FLOAT.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.FLOAT, values);
        }
        if (DataTypes.SHORT.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.SHORT, values);
        }
        if (DataTypes.BINARY.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.BINARY, values);
        }
        if (DataTypes.DATE.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.DATE, values);
        }
        if (DataTypes.LONG.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.LONG, values);
        }
        if (DataTypes.TIMESTAMP.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.TIMESTAMP, values);
        }
        if (DataTypes.BYTE.getName().equalsIgnoreCase(dataType)) {
            return FilterUtil.prepareEqualToExpressionSet(columnName, DataTypes.BYTE, values);
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }
}

