/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.IOException;
import java.util.BitSet;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.ImplicitColumnFilterExecutor;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;

public class AndFilterExecuterImpl
implements FilterExecuter,
ImplicitColumnFilterExecutor {
    private FilterExecuter leftExecuter;
    private FilterExecuter rightExecuter;

    public AndFilterExecuterImpl(FilterExecuter leftExecuter, FilterExecuter rightExecuter) {
        this.leftExecuter = leftExecuter;
        this.rightExecuter = rightExecuter;
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws FilterUnsupportedException, IOException {
        BitSetGroup leftFilters = this.leftExecuter.applyFilter(rawBlockletColumnChunks, useBitsetPipeLine);
        if (leftFilters.isEmpty()) {
            return leftFilters;
        }
        BitSetGroup rightFilter = this.rightExecuter.applyFilter(rawBlockletColumnChunks, useBitsetPipeLine);
        if (rightFilter.isEmpty()) {
            return rightFilter;
        }
        leftFilters.and(rightFilter);
        rawBlockletColumnChunks.setBitSetGroup(leftFilters);
        return leftFilters;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) throws FilterUnsupportedException, IOException {
        BitSet leftFilters = this.leftExecuter.prunePages(rawBlockletColumnChunks);
        if (leftFilters.isEmpty()) {
            return leftFilters;
        }
        BitSet rightFilter = this.rightExecuter.prunePages(rawBlockletColumnChunks);
        if (rightFilter.isEmpty()) {
            return rightFilter;
        }
        leftFilters.and(rightFilter);
        return leftFilters;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) throws FilterUnsupportedException, IOException {
        return this.leftExecuter.applyFilter(value, dimOrdinalMax) && this.rightExecuter.applyFilter(value, dimOrdinalMax);
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet leftFilters = this.leftExecuter.isScanRequired(blockMaxValue, blockMinValue, isMinMaxSet);
        if (leftFilters.isEmpty()) {
            return leftFilters;
        }
        BitSet rightFilter = this.rightExecuter.isScanRequired(blockMaxValue, blockMinValue, isMinMaxSet);
        if (rightFilter.isEmpty()) {
            return rightFilter;
        }
        leftFilters.and(rightFilter);
        return leftFilters;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        this.leftExecuter.readColumnChunks(rawBlockletColumnChunks);
        this.rightExecuter.readColumnChunks(rawBlockletColumnChunks);
    }

    @Override
    public BitSet isFilterValuesPresentInBlockOrBlocklet(byte[][] maxValue, byte[][] minValue, String uniqueBlockPath, boolean[] isMinMaxSet) {
        BitSet leftFilters = null;
        leftFilters = this.leftExecuter instanceof ImplicitColumnFilterExecutor ? ((ImplicitColumnFilterExecutor)((Object)this.leftExecuter)).isFilterValuesPresentInBlockOrBlocklet(maxValue, minValue, uniqueBlockPath, isMinMaxSet) : this.leftExecuter.isScanRequired(maxValue, minValue, isMinMaxSet);
        if (leftFilters.isEmpty()) {
            return leftFilters;
        }
        BitSet rightFilter = null;
        rightFilter = this.rightExecuter instanceof ImplicitColumnFilterExecutor ? ((ImplicitColumnFilterExecutor)((Object)this.rightExecuter)).isFilterValuesPresentInBlockOrBlocklet(maxValue, minValue, uniqueBlockPath, isMinMaxSet) : this.rightExecuter.isScanRequired(maxValue, minValue, isMinMaxSet);
        if (rightFilter.isEmpty()) {
            return rightFilter;
        }
        leftFilters.and(rightFilter);
        return leftFilters;
    }

    @Override
    public Boolean isFilterValuesPresentInAbstractIndex(byte[][] maxValue, byte[][] minValue, boolean[] isMinMaxSet) {
        BitSet tempFilter;
        Boolean leftRes = this.leftExecuter instanceof ImplicitColumnFilterExecutor ? ((ImplicitColumnFilterExecutor)((Object)this.leftExecuter)).isFilterValuesPresentInAbstractIndex(maxValue, minValue, isMinMaxSet) : Boolean.valueOf(!(tempFilter = this.leftExecuter.isScanRequired(maxValue, minValue, isMinMaxSet)).isEmpty());
        if (!leftRes.booleanValue()) {
            return leftRes;
        }
        Boolean rightRes = null;
        rightRes = this.rightExecuter instanceof ImplicitColumnFilterExecutor ? ((ImplicitColumnFilterExecutor)((Object)this.rightExecuter)).isFilterValuesPresentInAbstractIndex(maxValue, minValue, isMinMaxSet) : Boolean.valueOf(!(tempFilter = this.rightExecuter.isScanRequired(maxValue, minValue, isMinMaxSet)).isEmpty());
        return rightRes;
    }
}

