/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.util.BitSet;
import org.apache.carbondata.core.scan.filter.executer.FilterBitSetUpdater;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;

public final class BitSetUpdaterFactory {
    public static final BitSetUpdaterFactory INSTANCE = new BitSetUpdaterFactory();

    public FilterBitSetUpdater getBitSetUpdater(FilterExecuterType filterExecuterType) {
        switch (filterExecuterType) {
            case INCLUDE: {
                return new IncludeFilterBitSetUpdater();
            }
            case EXCLUDE: {
                return new ExcludeFilterBitSetUpdater();
            }
        }
        throw new UnsupportedOperationException("Invalid filter executor type:" + filterExecuterType);
    }

    static class ExcludeFilterBitSetUpdater
    implements FilterBitSetUpdater {
        ExcludeFilterBitSetUpdater() {
        }

        @Override
        public void updateBitset(BitSet bitSet, int bitIndex) {
            bitSet.flip(bitIndex);
        }
    }

    static class IncludeFilterBitSetUpdater
    implements FilterBitSetUpdater {
        IncludeFilterBitSetUpdater() {
        }

        @Override
        public void updateBitset(BitSet bitSet, int bitIndex) {
            bitSet.set(bitIndex);
        }
    }
}

