/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.IOException;
import java.util.BitSet;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.filter.FilterExecutorUtil;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.BitSetUpdaterFactory;
import org.apache.carbondata.core.scan.filter.executer.DimColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.executer.FilterBitSetUpdater;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.MeasureColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

public class ExcludeFilterExecuterImpl
implements FilterExecuter {
    private DimColumnResolvedFilterInfo dimColEvaluatorInfo;
    private DimColumnExecuterFilterInfo dimColumnExecuterInfo;
    private MeasureColumnResolvedFilterInfo msrColumnEvaluatorInfo;
    private MeasureColumnExecuterFilterInfo msrColumnExecutorInfo;
    protected SegmentProperties segmentProperties;
    private boolean isDimensionPresentInCurrentBlock = false;
    private boolean isMeasurePresentInCurrentBlock = false;
    private SerializableComparator comparator;
    private boolean isNaturalSorted = false;
    private byte[][] filterValues;
    private FilterBitSetUpdater filterBitSetUpdater;

    public ExcludeFilterExecuterImpl(byte[][] filterValues, boolean isNaturalSorted) {
        this.filterValues = filterValues;
        this.isNaturalSorted = isNaturalSorted;
        this.filterBitSetUpdater = BitSetUpdaterFactory.INSTANCE.getBitSetUpdater(FilterExecuterType.EXCLUDE);
    }

    public ExcludeFilterExecuterImpl(DimColumnResolvedFilterInfo dimColEvaluatorInfo, MeasureColumnResolvedFilterInfo msrColumnEvaluatorInfo, SegmentProperties segmentProperties, boolean isMeasure) {
        this.filterBitSetUpdater = BitSetUpdaterFactory.INSTANCE.getBitSetUpdater(FilterExecuterType.EXCLUDE);
        this.segmentProperties = segmentProperties;
        if (!isMeasure) {
            this.dimColEvaluatorInfo = dimColEvaluatorInfo;
            this.dimColumnExecuterInfo = new DimColumnExecuterFilterInfo();
            FilterUtil.prepareKeysFromSurrogates(dimColEvaluatorInfo.getFilterValues(), segmentProperties, dimColEvaluatorInfo.getDimension(), this.dimColumnExecuterInfo, null, null);
            this.isDimensionPresentInCurrentBlock = true;
            this.isNaturalSorted = dimColEvaluatorInfo.getDimension().isUseInvertedIndex() != false && dimColEvaluatorInfo.getDimension().isSortColumn();
        } else {
            this.msrColumnEvaluatorInfo = msrColumnEvaluatorInfo;
            this.msrColumnExecutorInfo = new MeasureColumnExecuterFilterInfo();
            FilterUtil.prepareKeysFromSurrogates(msrColumnEvaluatorInfo.getFilterValues(), segmentProperties, null, null, msrColumnEvaluatorInfo.getMeasure(), this.msrColumnExecutorInfo);
            this.isMeasurePresentInCurrentBlock = true;
            DataType msrType = FilterUtil.getMeasureDataType(msrColumnEvaluatorInfo);
            this.comparator = Comparator.getComparatorByDataTypeForMeasure(msrType);
        }
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws IOException {
        if (this.isDimensionPresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            DimensionRawColumnChunk dimensionRawColumnChunk = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
            DimensionColumnPage[] dimensionColumnPages = dimensionRawColumnChunk.decodeAllColumnPages();
            this.filterValues = FilterUtil.getEncodedFilterValues(dimensionRawColumnChunk.getLocalDictionary(), this.dimColumnExecuterInfo.filterKeysForExclude);
            BitSetGroup bitSetGroup = new BitSetGroup(dimensionRawColumnChunk.getPagesCount());
            for (int i = 0; i < dimensionColumnPages.length; ++i) {
                BitSet bitSet = this.getFilteredIndexes(dimensionColumnPages[i], dimensionRawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i);
                bitSetGroup.setBitSet(bitSet, i);
            }
            return bitSetGroup;
        }
        if (this.isMeasurePresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(this.msrColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            MeasureRawColumnChunk measureRawColumnChunk = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
            ColumnPage[] ColumnPages = measureRawColumnChunk.decodeAllColumnPages();
            BitSetGroup bitSetGroup = new BitSetGroup(measureRawColumnChunk.getPagesCount());
            DataType msrType = FilterUtil.getMeasureDataType(this.msrColumnEvaluatorInfo);
            for (int i = 0; i < ColumnPages.length; ++i) {
                BitSet bitSet = this.getFilteredIndexesForMeasure(measureRawColumnChunk.decodeColumnPage(i), measureRawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i, msrType);
                bitSetGroup.setBitSet(bitSet, i);
            }
            return bitSetGroup;
        }
        return null;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) {
        int numberOfPages = rawBlockletColumnChunks.getDataBlock().numberOfPages();
        BitSet bitSet = new BitSet(numberOfPages);
        bitSet.set(0, numberOfPages);
        return bitSet;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) {
        block3: {
            block2: {
                if (!this.isDimensionPresentInCurrentBlock) break block2;
                byte[][] filterValues = this.dimColumnExecuterInfo.getExcludeFilterKeys();
                byte[] col = (byte[])value.getVal(this.dimColEvaluatorInfo.getDimension().getOrdinal());
                for (int i = 0; i < filterValues.length; ++i) {
                    if (0 != ByteUtil.UnsafeComparer.INSTANCE.compareTo(col, 0, col.length, filterValues[i], 0, filterValues[i].length)) continue;
                    return false;
                }
                break block3;
            }
            if (!this.isMeasurePresentInCurrentBlock) break block3;
            Object[] filterValues = this.msrColumnExecutorInfo.getFilterKeys();
            Object col = value.getVal(this.msrColumnEvaluatorInfo.getMeasure().getOrdinal() + dimOrdinalMax);
            for (int i = 0; i < filterValues.length; ++i) {
                if (!(filterValues[i] == null ? null == col : this.comparator.compare(col, filterValues[i]) == 0)) continue;
                return false;
            }
        }
        return true;
    }

    private BitSet getFilteredIndexes(ColumnPage columnPage, int numerOfRows, DataType msrType) {
        BitSet bitSet = new BitSet(numerOfRows);
        bitSet.flip(0, numerOfRows);
        FilterExecutorUtil.executeIncludeExcludeFilterForMeasure(columnPage, bitSet, this.msrColumnExecutorInfo, this.msrColumnEvaluatorInfo, this.filterBitSetUpdater);
        return bitSet;
    }

    private BitSet getFilteredIndexesForMeasure(ColumnPage measureColumnPage, int numberOfRows, boolean useBitsetPipeLine, BitSetGroup prvBitSetGroup, int pageNumber, DataType msrDataType) {
        if (CarbonUtil.usePreviousFilterBitsetGroup(useBitsetPipeLine, prvBitSetGroup, pageNumber, this.msrColumnExecutorInfo.getFilterKeys().length)) {
            return this.getFilteredIndexesForMsrUsingPrvBitSet(measureColumnPage, prvBitSetGroup, pageNumber, numberOfRows, msrDataType);
        }
        return this.getFilteredIndexes(measureColumnPage, numberOfRows, msrDataType);
    }

    private BitSet getFilteredIndexesForMsrUsingPrvBitSet(ColumnPage measureColumnPage, BitSetGroup prvBitSetGroup, int pageNumber, int numberOfRows, DataType msrDataType) {
        BitSet bitSet = new BitSet(numberOfRows);
        bitSet.flip(0, numberOfRows);
        Object[] filterValues = this.msrColumnExecutorInfo.getFilterKeys();
        BitSet nullBitSet = measureColumnPage.getNullBits();
        BitSet prvPageBitSet = prvBitSetGroup.getBitSet(pageNumber);
        SerializableComparator comparator = Comparator.getComparatorByDataTypeForMeasure(msrDataType);
        for (int i = 0; i < filterValues.length; ++i) {
            if (filterValues[i] == null) {
                int j = nullBitSet.nextSetBit(0);
                while (j >= 0) {
                    bitSet.flip(j);
                    j = nullBitSet.nextSetBit(j + 1);
                }
                continue;
            }
            int index = prvPageBitSet.nextSetBit(0);
            while (index >= 0) {
                Object msrValue;
                if (!nullBitSet.get(index) && comparator.compare(msrValue = DataTypeUtil.getMeasureObjectBasedOnDataType(measureColumnPage, index, msrDataType, this.msrColumnEvaluatorInfo.getMeasure()), filterValues[i]) == 0) {
                    bitSet.flip(index);
                }
                index = prvPageBitSet.nextSetBit(index + 1);
            }
        }
        return bitSet;
    }

    protected BitSet getFilteredIndexes(DimensionColumnPage dimensionColumnPage, int numberOfRows, boolean useBitsetPipeLine, BitSetGroup prvBitSetGroup, int pageNumber) {
        if (this.filterValues.length > 0 && CarbonUtil.usePreviousFilterBitsetGroup(useBitsetPipeLine, prvBitSetGroup, pageNumber, this.filterValues.length)) {
            return this.getFilteredIndexesUisngPrvBitset(dimensionColumnPage, prvBitSetGroup, pageNumber);
        }
        return this.getFilteredIndexes(dimensionColumnPage, numberOfRows);
    }

    private BitSet getFilteredIndexes(DimensionColumnPage dimensionColumnPage, int numberOfRows) {
        if (dimensionColumnPage.isExplicitSorted()) {
            return this.setFilterdIndexToBitSetWithColumnIndex(dimensionColumnPage, numberOfRows);
        }
        return this.setFilterdIndexToBitSet(dimensionColumnPage, numberOfRows);
    }

    private BitSet getFilteredIndexesUisngPrvBitset(DimensionColumnPage dimensionColumnPage, BitSetGroup prvBitSetGroup, int pageNumber) {
        BitSet prvPageBitSet = prvBitSetGroup.getBitSet(pageNumber);
        if (prvPageBitSet == null || prvPageBitSet.isEmpty()) {
            return prvPageBitSet;
        }
        BitSet bitSet = new BitSet();
        bitSet.or(prvPageBitSet);
        int compareResult = 0;
        if (!dimensionColumnPage.isExplicitSorted()) {
            int index = prvPageBitSet.nextSetBit(0);
            while (index >= 0) {
                compareResult = CarbonUtil.isFilterPresent(this.filterValues, dimensionColumnPage, 0, this.filterValues.length - 1, index);
                if (compareResult != 0) {
                    bitSet.set(index);
                } else if (bitSet.get(index)) {
                    bitSet.flip(index);
                }
                index = prvPageBitSet.nextSetBit(index + 1);
            }
        } else {
            int index = prvPageBitSet.nextSetBit(0);
            while (index >= 0) {
                compareResult = CarbonUtil.isFilterPresent(this.filterValues, dimensionColumnPage, 0, this.filterValues.length - 1, dimensionColumnPage.getInvertedReverseIndex(index));
                if (compareResult != 0) {
                    bitSet.set(index);
                } else if (bitSet.get(index)) {
                    bitSet.flip(index);
                }
                index = prvPageBitSet.nextSetBit(index + 1);
            }
        }
        return bitSet;
    }

    private BitSet setFilterdIndexToBitSetWithColumnIndex(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        bitSet.flip(0, numerOfRows);
        if (this.filterValues.length == 0) {
            return bitSet;
        }
        int startIndex = 0;
        for (int i = 0; i < this.filterValues.length && startIndex < numerOfRows; ++i) {
            int[] rangeIndex = CarbonUtil.getRangeIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, this.filterValues[i]);
            for (int j = rangeIndex[0]; j <= rangeIndex[1]; ++j) {
                bitSet.flip(dimensionColumnPage.getInvertedIndex(j));
            }
            if (rangeIndex[1] < 0) continue;
            startIndex = rangeIndex[1] + 1;
        }
        return bitSet;
    }

    private BitSet setFilterdIndexToBitSet(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        bitSet.flip(0, numerOfRows);
        if (this.filterValues.length == 0) {
            return bitSet;
        }
        if (this.isNaturalSorted && dimensionColumnPage.isExplicitSorted()) {
            int startIndex = 0;
            for (int i = 0; i < this.filterValues.length && startIndex < numerOfRows; ++i) {
                int[] rangeIndex = CarbonUtil.getRangeIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, this.filterValues[i]);
                for (int j = rangeIndex[0]; j <= rangeIndex[1]; ++j) {
                    bitSet.flip(j);
                }
                if (rangeIndex[1] < 0) continue;
                startIndex = rangeIndex[1] + 1;
            }
        } else if (this.filterValues.length > 1) {
            for (int i = 0; i < numerOfRows; ++i) {
                int index = CarbonUtil.binarySearch(this.filterValues, 0, this.filterValues.length - 1, dimensionColumnPage, i);
                if (index < 0) continue;
                bitSet.flip(i);
            }
        } else {
            for (int j = 0; j < numerOfRows; ++j) {
                if (dimensionColumnPage.compareTo(j, this.filterValues[0]) != 0) continue;
                bitSet.flip(j);
            }
        }
        return bitSet;
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        bitSet.flip(0, 1);
        return bitSet;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        if (this.isDimensionPresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        } else if (this.isMeasurePresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(this.msrColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        }
    }
}

