/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.util.BitSet;
import java.util.Set;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.ImplicitColumnFilterExecutor;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.path.CarbonTablePath;

public class ImplicitIncludeFilterExecutorImpl
implements FilterExecuter,
ImplicitColumnFilterExecutor {
    private final DimColumnResolvedFilterInfo dimColumnEvaluatorInfo;

    public ImplicitIncludeFilterExecutorImpl(DimColumnResolvedFilterInfo dimColumnEvaluatorInfo) {
        this.dimColumnEvaluatorInfo = dimColumnEvaluatorInfo;
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeline) {
        BitSetGroup bitSetGroup = new BitSetGroup(rawBlockletColumnChunks.getDataBlock().numberOfPages());
        for (int i = 0; i < rawBlockletColumnChunks.getDataBlock().numberOfPages(); ++i) {
            bitSetGroup.setBitSet(this.setBitSetForCompleteDimensionData(rawBlockletColumnChunks.getDataBlock().getPageRowCount(i)), i);
        }
        return bitSetGroup;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) {
        int numberOfPages = rawBlockletColumnChunks.getDataBlock().numberOfPages();
        BitSet bitSet = new BitSet(numberOfPages);
        bitSet.set(0, numberOfPages);
        return bitSet;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) {
        return false;
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        return null;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) {
    }

    @Override
    public BitSet isFilterValuesPresentInBlockOrBlocklet(byte[][] maxValue, byte[][] minValue, String uniqueBlockPath, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        boolean isScanRequired = false;
        String shortBlockId = CarbonTablePath.getShortBlockId(uniqueBlockPath);
        if (uniqueBlockPath.endsWith(".carbondata")) {
            if (this.dimColumnEvaluatorInfo.getFilterValues().getImplicitColumnFilterBlockToBlockletsMap().containsKey(shortBlockId)) {
                isScanRequired = true;
            }
        } else {
            int idInUniqueBlockPath;
            String blockId = shortBlockId.substring(0, shortBlockId.lastIndexOf("/"));
            Set<Integer> blockletIds = this.dimColumnEvaluatorInfo.getFilterValues().getImplicitColumnFilterBlockToBlockletsMap().get(blockId);
            if (null != blockletIds && blockletIds.contains(idInUniqueBlockPath = Integer.parseInt(shortBlockId.substring(blockId.length() + 1)))) {
                isScanRequired = true;
            }
        }
        if (isScanRequired) {
            bitSet.set(0);
        }
        return bitSet;
    }

    private BitSet setBitSetForCompleteDimensionData(int numberOfRows) {
        BitSet bitSet = new BitSet();
        bitSet.set(0, numberOfRows, true);
        return bitSet;
    }

    @Override
    public Boolean isFilterValuesPresentInAbstractIndex(byte[][] maxValue, byte[][] minValue, boolean[] isMinMaxSet) {
        return true;
    }
}

