/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.IOException;
import java.util.BitSet;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.filter.FilterExecutorUtil;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.BitSetUpdaterFactory;
import org.apache.carbondata.core.scan.filter.executer.DimColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.executer.FilterBitSetUpdater;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.MeasureColumnExecuterFilterInfo;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

public class IncludeFilterExecuterImpl
implements FilterExecuter {
    protected DimColumnResolvedFilterInfo dimColumnEvaluatorInfo;
    DimColumnExecuterFilterInfo dimColumnExecuterInfo;
    private MeasureColumnResolvedFilterInfo msrColumnEvaluatorInfo;
    private MeasureColumnExecuterFilterInfo msrColumnExecutorInfo;
    protected SegmentProperties segmentProperties;
    private boolean isDimensionPresentInCurrentBlock = false;
    private boolean isMeasurePresentInCurrentBlock = false;
    protected SerializableComparator comparator;
    private boolean isNaturalSorted = false;
    private byte[][] filterValues;
    private FilterBitSetUpdater filterBitSetUpdater;

    public IncludeFilterExecuterImpl(byte[][] filterValues, boolean isNaturalSorted) {
        this.filterValues = filterValues;
        this.isNaturalSorted = isNaturalSorted;
        this.filterBitSetUpdater = BitSetUpdaterFactory.INSTANCE.getBitSetUpdater(FilterExecuterType.INCLUDE);
    }

    public IncludeFilterExecuterImpl(DimColumnResolvedFilterInfo dimColumnEvaluatorInfo, MeasureColumnResolvedFilterInfo msrColumnEvaluatorInfo, SegmentProperties segmentProperties, boolean isMeasure) {
        this.filterBitSetUpdater = BitSetUpdaterFactory.INSTANCE.getBitSetUpdater(FilterExecuterType.INCLUDE);
        this.segmentProperties = segmentProperties;
        if (!isMeasure) {
            this.dimColumnEvaluatorInfo = dimColumnEvaluatorInfo;
            this.dimColumnExecuterInfo = new DimColumnExecuterFilterInfo();
            FilterUtil.prepareKeysFromSurrogates(dimColumnEvaluatorInfo.getFilterValues(), segmentProperties, dimColumnEvaluatorInfo.getDimension(), this.dimColumnExecuterInfo, null, null);
            this.isDimensionPresentInCurrentBlock = true;
            this.isNaturalSorted = dimColumnEvaluatorInfo.getDimension().isUseInvertedIndex() != false && dimColumnEvaluatorInfo.getDimension().isSortColumn();
        } else {
            this.msrColumnEvaluatorInfo = msrColumnEvaluatorInfo;
            this.msrColumnExecutorInfo = new MeasureColumnExecuterFilterInfo();
            this.comparator = Comparator.getComparatorByDataTypeForMeasure(FilterUtil.getMeasureDataType(msrColumnEvaluatorInfo));
            FilterUtil.prepareKeysFromSurrogates(msrColumnEvaluatorInfo.getFilterValues(), segmentProperties, null, null, msrColumnEvaluatorInfo.getMeasure(), this.msrColumnExecutorInfo);
            this.isMeasurePresentInCurrentBlock = true;
        }
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws IOException {
        if (this.isDimensionPresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            DimensionRawColumnChunk dimensionRawColumnChunk = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
            BitSetGroup bitSetGroup = new BitSetGroup(dimensionRawColumnChunk.getPagesCount());
            this.filterValues = this.dimColumnExecuterInfo.getFilterKeys();
            boolean isDecoded = false;
            for (int i = 0; i < dimensionRawColumnChunk.getPagesCount(); ++i) {
                if (dimensionRawColumnChunk.getMaxValues() != null) {
                    if (!this.isScanRequired(dimensionRawColumnChunk, i)) continue;
                    DimensionColumnPage dimensionColumnPage = dimensionRawColumnChunk.decodeColumnPage(i);
                    if (!isDecoded) {
                        this.filterValues = FilterUtil.getEncodedFilterValues(dimensionRawColumnChunk.getLocalDictionary(), this.dimColumnExecuterInfo.getFilterKeys());
                        isDecoded = true;
                    }
                    BitSet bitSet = this.getFilteredIndexes(dimensionColumnPage, dimensionRawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i);
                    bitSetGroup.setBitSet(bitSet, i);
                    continue;
                }
                BitSet bitSet = this.getFilteredIndexes(dimensionRawColumnChunk.decodeColumnPage(i), dimensionRawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i);
                bitSetGroup.setBitSet(bitSet, i);
            }
            return bitSetGroup;
        }
        if (this.isMeasurePresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(this.msrColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            MeasureRawColumnChunk measureRawColumnChunk = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
            BitSetGroup bitSetGroup = new BitSetGroup(measureRawColumnChunk.getPagesCount());
            DataType msrType = FilterUtil.getMeasureDataType(this.msrColumnEvaluatorInfo);
            for (int i = 0; i < measureRawColumnChunk.getPagesCount(); ++i) {
                BitSet bitSet;
                if (measureRawColumnChunk.getMaxValues() != null) {
                    if (!this.isScanRequired(measureRawColumnChunk.getMaxValues()[i], measureRawColumnChunk.getMinValues()[i], this.msrColumnExecutorInfo.getFilterKeys(), this.msrColumnEvaluatorInfo.getType())) continue;
                    bitSet = this.getFilteredIndexesForMeasure(measureRawColumnChunk.decodeColumnPage(i), measureRawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i, msrType);
                    bitSetGroup.setBitSet(bitSet, i);
                    continue;
                }
                bitSet = this.getFilteredIndexesForMeasure(measureRawColumnChunk.decodeColumnPage(i), measureRawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i, msrType);
                bitSetGroup.setBitSet(bitSet, i);
            }
            return bitSetGroup;
        }
        return null;
    }

    private boolean isScanRequired(DimensionRawColumnChunk dimensionRawColumnChunk, int columnIndex) {
        boolean scanRequired = DataTypeUtil.isPrimitiveColumn(this.dimColumnEvaluatorInfo.getDimension().getDataType()) && this.dimColumnEvaluatorInfo.getDimension().getDataType() != DataTypes.DATE ? this.isScanRequired(dimensionRawColumnChunk.getMaxValues()[columnIndex], dimensionRawColumnChunk.getMinValues()[columnIndex], this.dimColumnExecuterInfo.getFilterKeys(), this.dimColumnEvaluatorInfo.getDimension().getDataType()) : this.isScanRequired(dimensionRawColumnChunk.getMaxValues()[columnIndex], dimensionRawColumnChunk.getMinValues()[columnIndex], this.dimColumnExecuterInfo.getFilterKeys(), dimensionRawColumnChunk.getMinMaxFlagArray()[columnIndex]);
        return scanRequired;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        if (this.isDimensionPresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            DimensionRawColumnChunk dimensionRawColumnChunk = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
            this.filterValues = this.dimColumnExecuterInfo.getFilterKeys();
            BitSet bitSet = new BitSet(dimensionRawColumnChunk.getPagesCount());
            for (int i = 0; i < dimensionRawColumnChunk.getPagesCount(); ++i) {
                if (dimensionRawColumnChunk.getMaxValues() != null) {
                    if (!this.isScanRequired(dimensionRawColumnChunk, i)) continue;
                    bitSet.set(i);
                    continue;
                }
                bitSet.set(i);
            }
            return bitSet;
        }
        if (this.isMeasurePresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(this.msrColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            MeasureRawColumnChunk measureRawColumnChunk = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
            BitSet bitSet = new BitSet(measureRawColumnChunk.getPagesCount());
            for (int i = 0; i < measureRawColumnChunk.getPagesCount(); ++i) {
                if (measureRawColumnChunk.getMaxValues() != null) {
                    if (!this.isScanRequired(measureRawColumnChunk.getMaxValues()[i], measureRawColumnChunk.getMinValues()[i], this.msrColumnExecutorInfo.getFilterKeys(), this.msrColumnEvaluatorInfo.getType())) continue;
                    bitSet.set(i);
                    continue;
                }
                bitSet.set(i);
            }
            return bitSet;
        }
        return null;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) {
        block3: {
            block2: {
                if (!this.isDimensionPresentInCurrentBlock) break block2;
                byte[][] filterValues = this.dimColumnExecuterInfo.getFilterKeys();
                byte[] col = (byte[])value.getVal(this.dimColumnEvaluatorInfo.getDimension().getOrdinal());
                for (int i = 0; i < filterValues.length; ++i) {
                    if (0 != ByteUtil.UnsafeComparer.INSTANCE.compareTo(col, 0, col.length, filterValues[i], 0, filterValues[i].length)) continue;
                    return true;
                }
                break block3;
            }
            if (!this.isMeasurePresentInCurrentBlock) break block3;
            Object[] filterValues = this.msrColumnExecutorInfo.getFilterKeys();
            Object col = value.getVal(this.msrColumnEvaluatorInfo.getMeasure().getOrdinal() + dimOrdinalMax);
            for (int i = 0; i < filterValues.length; ++i) {
                if (!(filterValues[i] == null ? null == col : this.comparator.compare(col, filterValues[i]) == 0)) continue;
                return true;
            }
        }
        return false;
    }

    private BitSet getFilteredIndexesForMeasures(ColumnPage columnPage, int rowsInPage, DataType msrType) {
        BitSet bitSet = new BitSet(rowsInPage);
        FilterExecutorUtil.executeIncludeExcludeFilterForMeasure(columnPage, bitSet, this.msrColumnExecutorInfo, this.msrColumnEvaluatorInfo, this.filterBitSetUpdater);
        return bitSet;
    }

    private BitSet getFilteredIndexesForMeasure(ColumnPage measureColumnPage, int numberOfRows, boolean useBitsetPipeLine, BitSetGroup prvBitSetGroup, int pageNumber, DataType msrDataType) {
        if (CarbonUtil.usePreviousFilterBitsetGroup(useBitsetPipeLine, prvBitSetGroup, pageNumber, this.msrColumnExecutorInfo.getFilterKeys().length)) {
            return this.getFilteredIndexesForMsrUsingPrvBitSet(measureColumnPage, prvBitSetGroup, pageNumber, numberOfRows, msrDataType);
        }
        return this.getFilteredIndexesForMeasures(measureColumnPage, numberOfRows, msrDataType);
    }

    private BitSet getFilteredIndexesForMsrUsingPrvBitSet(ColumnPage measureColumnPage, BitSetGroup prvBitSetGroup, int pageNumber, int numberOfRows, DataType msrDataType) {
        BitSet bitSet = new BitSet(numberOfRows);
        Object[] filterValues = this.msrColumnExecutorInfo.getFilterKeys();
        BitSet nullBitSet = measureColumnPage.getNullBits();
        BitSet prvPageBitSet = prvBitSetGroup.getBitSet(pageNumber);
        SerializableComparator comparator = Comparator.getComparatorByDataTypeForMeasure(msrDataType);
        for (int i = 0; i < filterValues.length; ++i) {
            if (filterValues[i] == null) {
                int j = nullBitSet.nextSetBit(0);
                while (j >= 0) {
                    bitSet.set(j);
                    j = nullBitSet.nextSetBit(j + 1);
                }
                continue;
            }
            int index = prvPageBitSet.nextSetBit(0);
            while (index >= 0) {
                Object msrValue;
                if (!nullBitSet.get(index) && comparator.compare(msrValue = DataTypeUtil.getMeasureObjectBasedOnDataType(measureColumnPage, index, msrDataType, this.msrColumnEvaluatorInfo.getMeasure()), filterValues[i]) == 0) {
                    bitSet.set(index);
                }
                index = prvPageBitSet.nextSetBit(index + 1);
            }
        }
        return bitSet;
    }

    protected BitSet getFilteredIndexes(DimensionColumnPage dimensionColumnPage, int numberOfRows, boolean useBitsetPipeLine, BitSetGroup prvBitSetGroup, int pageNumber) {
        if (this.filterValues.length > 0 && CarbonUtil.usePreviousFilterBitsetGroup(useBitsetPipeLine, prvBitSetGroup, pageNumber, this.filterValues.length)) {
            return this.getFilteredIndexesUisngPrvBitset(dimensionColumnPage, prvBitSetGroup, pageNumber, numberOfRows);
        }
        return this.getFilteredIndexes(dimensionColumnPage, numberOfRows);
    }

    private BitSet getFilteredIndexes(DimensionColumnPage dimensionColumnPage, int numberOfRows) {
        if (dimensionColumnPage.isExplicitSorted()) {
            return this.setFilterdIndexToBitSetWithColumnIndex(dimensionColumnPage, numberOfRows);
        }
        return this.setFilterdIndexToBitSet(dimensionColumnPage, numberOfRows);
    }

    private BitSet getFilteredIndexesUisngPrvBitset(DimensionColumnPage dimensionColumnPage, BitSetGroup prvBitSetGroup, int pageNumber, int numberOfRows) {
        BitSet prvPageBitSet = prvBitSetGroup.getBitSet(pageNumber);
        if (prvPageBitSet == null || prvPageBitSet.isEmpty()) {
            return prvPageBitSet;
        }
        BitSet bitSet = new BitSet(numberOfRows);
        int compareResult = 0;
        if (!dimensionColumnPage.isExplicitSorted()) {
            int index = prvPageBitSet.nextSetBit(0);
            while (index >= 0) {
                compareResult = CarbonUtil.isFilterPresent(this.filterValues, dimensionColumnPage, 0, this.filterValues.length - 1, index);
                if (compareResult == 0) {
                    bitSet.set(index);
                }
                index = prvPageBitSet.nextSetBit(index + 1);
            }
        } else {
            int index = prvPageBitSet.nextSetBit(0);
            while (index >= 0) {
                compareResult = CarbonUtil.isFilterPresent(this.filterValues, dimensionColumnPage, 0, this.filterValues.length - 1, dimensionColumnPage.getInvertedReverseIndex(index));
                if (compareResult == 0) {
                    bitSet.set(index);
                }
                index = prvPageBitSet.nextSetBit(index + 1);
            }
        }
        return bitSet;
    }

    private BitSet setFilterdIndexToBitSetWithColumnIndex(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        if (this.filterValues.length == 0) {
            return bitSet;
        }
        int startIndex = 0;
        for (int i = 0; i < this.filterValues.length && startIndex < numerOfRows; ++i) {
            int[] rangeIndex = CarbonUtil.getRangeIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, this.filterValues[i]);
            for (int j = rangeIndex[0]; j <= rangeIndex[1]; ++j) {
                bitSet.set(dimensionColumnPage.getInvertedIndex(j));
            }
            if (rangeIndex[1] < 0) continue;
            startIndex = rangeIndex[1] + 1;
        }
        return bitSet;
    }

    private BitSet setFilterdIndexToBitSet(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        if (this.filterValues.length == 0) {
            return bitSet;
        }
        if (this.isNaturalSorted && dimensionColumnPage.isExplicitSorted()) {
            int startIndex = 0;
            for (int i = 0; i < this.filterValues.length && startIndex < numerOfRows; ++i) {
                int[] rangeIndex = CarbonUtil.getRangeIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, this.filterValues[i]);
                for (int j = rangeIndex[0]; j <= rangeIndex[1]; ++j) {
                    bitSet.set(j);
                }
                if (rangeIndex[1] < 0) continue;
                startIndex = rangeIndex[1] + 1;
            }
        } else if (this.filterValues.length > 1) {
            for (int i = 0; i < numerOfRows; ++i) {
                int index = CarbonUtil.binarySearch(this.filterValues, 0, this.filterValues.length - 1, dimensionColumnPage, i);
                if (index < 0) continue;
                bitSet.set(i);
            }
        } else {
            for (int j = 0; j < numerOfRows; ++j) {
                if (dimensionColumnPage.compareTo(j, this.filterValues[0]) != 0) continue;
                bitSet.set(j);
            }
        }
        return bitSet;
    }

    @Override
    public BitSet isScanRequired(byte[][] blkMaxVal, byte[][] blkMinVal, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        int chunkIndex = 0;
        boolean isScanRequired = false;
        if (this.isDimensionPresentInCurrentBlock) {
            byte[][] filterValues = this.dimColumnExecuterInfo.getFilterKeys();
            chunkIndex = this.dimColumnEvaluatorInfo.getColumnIndexInMinMaxByteArray();
            isScanRequired = DataTypeUtil.isPrimitiveColumn(this.dimColumnEvaluatorInfo.getDimension().getDataType()) && this.dimColumnEvaluatorInfo.getDimension().getDataType() != DataTypes.DATE ? this.isScanRequired(blkMaxVal[chunkIndex], blkMinVal[chunkIndex], filterValues, this.dimColumnEvaluatorInfo.getDimension().getDataType()) : this.isScanRequired(blkMaxVal[chunkIndex], blkMinVal[chunkIndex], filterValues, isMinMaxSet[chunkIndex]);
        } else if (this.isMeasurePresentInCurrentBlock) {
            chunkIndex = this.msrColumnEvaluatorInfo.getColumnIndexInMinMaxByteArray();
            isScanRequired = isMinMaxSet[chunkIndex] ? this.isScanRequired(blkMaxVal[chunkIndex], blkMinVal[chunkIndex], this.msrColumnExecutorInfo.getFilterKeys(), this.msrColumnEvaluatorInfo.getType()) : true;
        }
        if (isScanRequired) {
            bitSet.set(0);
        }
        return bitSet;
    }

    private boolean isScanRequired(byte[] blkMaxVal, byte[] blkMinVal, byte[][] filterValues, boolean isMinMaxSet) {
        if (!isMinMaxSet) {
            return true;
        }
        boolean isScanRequired = false;
        for (int k = 0; k < filterValues.length; ++k) {
            int maxCompare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterValues[k], blkMaxVal);
            int minCompare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterValues[k], blkMinVal);
            if (maxCompare > 0 || minCompare < 0) continue;
            isScanRequired = true;
            break;
        }
        return isScanRequired;
    }

    private boolean isScanRequired(byte[] blkMaxVal, byte[] blkMinVal, byte[][] filterValues, DataType dataType) {
        boolean isScanRequired = false;
        Object minValue = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(blkMinVal, dataType);
        Object maxValue = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(blkMaxVal, dataType);
        for (int k = 0; k < filterValues.length; ++k) {
            if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterValues[k], CarbonCommonConstants.EMPTY_BYTE_ARRAY) == 0) {
                return true;
            }
            Object data = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(filterValues[k], dataType);
            SerializableComparator comparator = Comparator.getComparator(dataType);
            int maxCompare = comparator.compare(data, maxValue);
            int minCompare = comparator.compare(data, minValue);
            if (maxCompare > 0 || minCompare < 0) continue;
            isScanRequired = true;
            break;
        }
        return isScanRequired;
    }

    private boolean isScanRequired(byte[] maxValue, byte[] minValue, Object[] filterValue, DataType dataType) {
        Object maxObject = DataTypeUtil.getMeasureObjectFromDataType(maxValue, dataType);
        Object minObject = DataTypeUtil.getMeasureObjectFromDataType(minValue, dataType);
        for (int i = 0; i < filterValue.length; ++i) {
            if (filterValue[i] == null) {
                return true;
            }
            if (this.comparator.compare(filterValue[i], maxObject) > 0 || this.comparator.compare(filterValue[i], minObject) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        if (this.isDimensionPresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        } else if (this.isMeasurePresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(this.msrColumnEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        }
    }
}

