/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class MeasureColumnExecuterFilterInfo {
    Object[] filterKeys;
    private AbstractCollection filterSet;

    public void setFilterKeys(Object[] filterKeys, DataType dataType) {
        this.filterKeys = filterKeys;
        if (dataType == DataTypes.BOOLEAN) {
            this.filterSet = new BooleanOpenHashSet();
        } else if (dataType == DataTypes.BYTE) {
            this.filterSet = new ByteOpenHashSet();
        } else if (dataType == DataTypes.SHORT) {
            this.filterSet = new ShortOpenHashSet();
        } else if (dataType == DataTypes.INT) {
            this.filterSet = new IntOpenHashSet();
        } else if (dataType == DataTypes.FLOAT) {
            this.filterSet = new FloatOpenHashSet();
        } else if (dataType == DataTypes.LONG) {
            this.filterSet = new LongOpenHashSet();
        } else if (dataType == DataTypes.DOUBLE) {
            this.filterSet = new DoubleOpenHashSet();
        } else if (DataTypes.isDecimal(dataType)) {
            this.filterSet = new HashSet();
        } else {
            throw new IllegalArgumentException("Invalid data type");
        }
        for (int i = 0; i < filterKeys.length; ++i) {
            if (null == filterKeys[i]) continue;
            this.filterSet.add(filterKeys[i]);
        }
    }

    public Object[] getFilterKeys() {
        return this.filterKeys;
    }

    public AbstractCollection getFilterSet() {
        return this.filterSet;
    }
}

