/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.IOException;
import java.util.BitSet;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;

public class OrFilterExecuterImpl
implements FilterExecuter {
    private FilterExecuter leftExecuter;
    private FilterExecuter rightExecuter;

    public OrFilterExecuterImpl(FilterExecuter leftExecuter, FilterExecuter rightExecuter) {
        this.leftExecuter = leftExecuter;
        this.rightExecuter = rightExecuter;
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws FilterUnsupportedException, IOException {
        BitSetGroup leftFilters = this.leftExecuter.applyFilter(rawBlockletColumnChunks, false);
        BitSetGroup rightFilters = this.rightExecuter.applyFilter(rawBlockletColumnChunks, false);
        leftFilters.or(rightFilters);
        rawBlockletColumnChunks.setBitSetGroup(leftFilters);
        return leftFilters;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) throws FilterUnsupportedException, IOException {
        BitSet leftFilters = this.leftExecuter.prunePages(rawBlockletColumnChunks);
        BitSet rightFilters = this.rightExecuter.prunePages(rawBlockletColumnChunks);
        leftFilters.or(rightFilters);
        return leftFilters;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) throws FilterUnsupportedException, IOException {
        return this.leftExecuter.applyFilter(value, dimOrdinalMax) || this.rightExecuter.applyFilter(value, dimOrdinalMax);
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet leftFilters = this.leftExecuter.isScanRequired(blockMaxValue, blockMinValue, isMinMaxSet);
        BitSet rightFilters = this.rightExecuter.isScanRequired(blockMaxValue, blockMinValue, isMinMaxSet);
        leftFilters.or(rightFilters);
        return leftFilters;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        this.leftExecuter.readColumnChunks(rawBlockletColumnChunks);
        this.rightExecuter.readColumnChunks(rawBlockletColumnChunks);
    }
}

