/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.IOException;
import java.util.BitSet;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.ExcludeFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.IncludeFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;

public class RangeValueFilterExecuterImpl
implements FilterExecuter {
    private DimColumnResolvedFilterInfo dimColEvaluatorInfo;
    private Expression exp;
    private byte[][] filterRangesValues;
    private SegmentProperties segmentProperties;
    private boolean isDefaultValuePresentInFilter;
    private boolean isDimensionPresentInCurrentBlock;
    private boolean lessThanExp;
    private boolean lessThanEqualExp;
    private boolean greaterThanExp;
    private boolean greaterThanEqualExp;
    private boolean startBlockMinIsDefaultStart;
    private boolean endBlockMaxisDefaultEnd;
    private boolean isRangeFullyCoverBlock;
    private boolean isNaturalSorted;

    public RangeValueFilterExecuterImpl(DimColumnResolvedFilterInfo dimColEvaluatorInfo, Expression exp, byte[][] filterRangeValues, SegmentProperties segmentProperties) {
        this.dimColEvaluatorInfo = dimColEvaluatorInfo;
        this.exp = exp;
        this.segmentProperties = segmentProperties;
        this.filterRangesValues = filterRangeValues;
        this.lessThanExp = this.isLessThan();
        this.lessThanEqualExp = this.isLessThanEqualTo();
        this.greaterThanExp = this.isGreaterThan();
        this.greaterThanEqualExp = this.isGreaterThanEqualTo();
        this.startBlockMinIsDefaultStart = false;
        this.endBlockMaxisDefaultEnd = false;
        this.isRangeFullyCoverBlock = false;
        this.initDimensionChunkIndexes();
        this.ifDefaultValueMatchesFilter();
        if (this.isDimensionPresentInCurrentBlock) {
            this.isNaturalSorted = dimColEvaluatorInfo.getDimension().isUseInvertedIndex() != false && dimColEvaluatorInfo.getDimension().isSortColumn();
        }
    }

    private void initDimensionChunkIndexes() {
        CarbonDimension dimensionFromCurrentBlock = this.segmentProperties.getDimensionFromCurrentBlock(this.dimColEvaluatorInfo.getDimension());
        if (null != dimensionFromCurrentBlock) {
            this.dimColEvaluatorInfo.setColumnIndex(dimensionFromCurrentBlock.getOrdinal());
            this.isDimensionPresentInCurrentBlock = true;
        }
    }

    private void ifDefaultValueMatchesFilter() {
        CarbonDimension dimension;
        byte[] defaultValue;
        this.isDefaultValuePresentInFilter = false;
        if (!this.isDimensionPresentInCurrentBlock && null != this.filterRangesValues && null != (defaultValue = (dimension = this.dimColEvaluatorInfo.getDimension()).getDefaultValue())) {
            int minCompare = FilterUtil.compareValues(this.filterRangesValues[0], defaultValue, dimension, true);
            int maxCompare = FilterUtil.compareValues(this.filterRangesValues[1], defaultValue, dimension, false);
            if ((this.greaterThanExp && maxCompare > 0 || this.greaterThanEqualExp && maxCompare >= 0) && (this.lessThanExp && minCompare > 0 || this.lessThanEqualExp && minCompare >= 0)) {
                this.isDefaultValuePresentInFilter = true;
            }
        }
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws IOException {
        return this.applyNoAndDirectFilter(rawBlockletColumnChunks, useBitsetPipeLine);
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks blockChunkHolder) throws IOException {
        if (!this.isDimensionPresentInCurrentBlock) {
            int numberOfPages = blockChunkHolder.getDataBlock().numberOfPages();
            BitSet bitSet = new BitSet();
            bitSet.set(0, numberOfPages);
            return bitSet;
        }
        int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColEvaluatorInfo.getColumnIndex());
        if (null == blockChunkHolder.getDimensionRawColumnChunks()[chunkIndex]) {
            blockChunkHolder.getDimensionRawColumnChunks()[chunkIndex] = blockChunkHolder.getDataBlock().readDimensionChunk(blockChunkHolder.getFileReader(), chunkIndex);
        }
        DimensionRawColumnChunk rawColumnChunk = blockChunkHolder.getDimensionRawColumnChunks()[chunkIndex];
        BitSet bitSet = new BitSet(rawColumnChunk.getPagesCount());
        for (int i = 0; i < rawColumnChunk.getPagesCount(); ++i) {
            if (rawColumnChunk.getMaxValues() != null) {
                if (!this.isScanRequired(rawColumnChunk.getMinValues()[i], rawColumnChunk.getMaxValues()[i], this.filterRangesValues, rawColumnChunk.getMinMaxFlagArray()[i])) continue;
                bitSet.set(i);
                continue;
            }
            bitSet.set(i);
        }
        return bitSet;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) {
        byte[] col = (byte[])value.getVal(this.dimColEvaluatorInfo.getDimension().getOrdinal());
        byte[][] filterValues = this.filterRangesValues;
        if (this.isDimensionPresentInCurrentBlock) {
            boolean result;
            if (this.greaterThanExp) {
                result = ByteUtil.compare(filterValues[0], col) < 0;
            } else {
                boolean bl = result = ByteUtil.compare(filterValues[0], col) <= 0;
            }
            if (result) {
                if (this.lessThanExp) {
                    return ByteUtil.compare(filterValues[1], col) > 0;
                }
                return ByteUtil.compare(filterValues[1], col) >= 0;
            }
        }
        return false;
    }

    private boolean isLessThan() {
        for (Expression result : this.exp.getChildren()) {
            if (!(result instanceof LessThanExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean isLessThanEqualTo() {
        for (Expression result : this.exp.getChildren()) {
            if (!(result instanceof LessThanEqualToExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean isGreaterThan() {
        for (Expression result : this.exp.getChildren()) {
            if (!(result instanceof GreaterThanExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean isGreaterThanEqualTo() {
        for (Expression result : this.exp.getChildren()) {
            if (!(result instanceof GreaterThanEqualToExpression)) continue;
            return true;
        }
        return false;
    }

    public boolean isScanRequired(byte[] blockMinValue, byte[] blockMaxValue, byte[][] filterValues, boolean isMinMaxSet) {
        if (!isMinMaxSet) {
            return true;
        }
        boolean isScanRequired = true;
        this.isRangeFullyCoverBlock = false;
        this.startBlockMinIsDefaultStart = false;
        this.endBlockMaxisDefaultEnd = false;
        if (this.isDimensionPresentInCurrentBlock) {
            CarbonDimension carbonDimension = this.dimColEvaluatorInfo.getDimension();
            if (this.lessThanExp && FilterUtil.compareValues(filterValues[1], blockMinValue, carbonDimension, true) >= 0 || this.lessThanEqualExp && FilterUtil.compareValues(filterValues[1], blockMinValue, carbonDimension, true) > 0 || this.greaterThanExp && FilterUtil.compareValues(filterValues[0], blockMaxValue, carbonDimension, false) >= 0 || this.greaterThanEqualExp && FilterUtil.compareValues(filterValues[0], blockMaxValue, carbonDimension, false) > 0) {
                isScanRequired = false;
            } else {
                if (this.greaterThanExp && FilterUtil.compareValues(filterValues[0], blockMinValue, carbonDimension, true) > 0 || this.greaterThanEqualExp && FilterUtil.compareValues(filterValues[0], blockMinValue, carbonDimension, true) >= 0) {
                    this.startBlockMinIsDefaultStart = true;
                }
                if (this.lessThanExp && FilterUtil.compareValues(filterValues[1], blockMaxValue, carbonDimension, false) > 0 || this.lessThanEqualExp && FilterUtil.compareValues(filterValues[1], blockMaxValue, carbonDimension, false) >= 0) {
                    this.endBlockMaxisDefaultEnd = true;
                }
                if (this.startBlockMinIsDefaultStart && this.endBlockMaxisDefaultEnd) {
                    this.isRangeFullyCoverBlock = true;
                }
            }
            return isScanRequired;
        }
        return this.isDefaultValuePresentInFilter;
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        boolean isScanRequired;
        BitSet bitSet = new BitSet(1);
        byte[][] filterValues = this.filterRangesValues;
        int columnIndex = this.dimColEvaluatorInfo.getColumnIndexInMinMaxByteArray();
        boolean bl = isScanRequired = columnIndex >= blockMinValue.length || this.isScanRequired(blockMinValue[columnIndex], blockMaxValue[columnIndex], filterValues, isMinMaxSet[columnIndex]);
        if (isScanRequired) {
            bitSet.set(0);
        }
        return bitSet;
    }

    private BitSetGroup applyNoAndDirectFilter(RawBlockletColumnChunks blockChunkHolder, boolean useBitsetPipeLine) throws IOException {
        if (!this.isDimensionPresentInCurrentBlock) {
            int numberOfRows = blockChunkHolder.getDataBlock().numRows();
            return FilterUtil.createBitSetGroupWithDefaultValue(blockChunkHolder.getDataBlock().numberOfPages(), numberOfRows, true);
        }
        int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColEvaluatorInfo.getColumnIndex());
        if (null == blockChunkHolder.getDimensionRawColumnChunks()[chunkIndex]) {
            blockChunkHolder.getDimensionRawColumnChunks()[chunkIndex] = blockChunkHolder.getDataBlock().readDimensionChunk(blockChunkHolder.getFileReader(), chunkIndex);
        }
        DimensionRawColumnChunk rawColumnChunk = blockChunkHolder.getDimensionRawColumnChunks()[chunkIndex];
        BitSetGroup bitSetGroup = new BitSetGroup(rawColumnChunk.getPagesCount());
        FilterExecuter filterExecuter = null;
        boolean isExclude = false;
        for (int i = 0; i < rawColumnChunk.getPagesCount(); ++i) {
            BitSet bitSet;
            if (rawColumnChunk.getMaxValues() != null) {
                if (!this.isScanRequired(rawColumnChunk.getMinValues()[i], rawColumnChunk.getMaxValues()[i], this.filterRangesValues, rawColumnChunk.getMinMaxFlagArray()[i])) continue;
                if (this.isRangeFullyCoverBlock) {
                    bitSet = new BitSet(rawColumnChunk.getRowCount()[i]);
                    bitSet.flip(0, rawColumnChunk.getRowCount()[i]);
                    bitSetGroup.setBitSet(bitSet, i);
                    continue;
                }
                DimensionColumnPage dimensionColumnPage = rawColumnChunk.decodeColumnPage(i);
                if (null != rawColumnChunk.getLocalDictionary()) {
                    if (null == filterExecuter && (filterExecuter = FilterUtil.getFilterExecutorForRangeFilters(rawColumnChunk, this.exp, this.isNaturalSorted)) instanceof ExcludeFilterExecuterImpl) {
                        isExclude = true;
                    }
                    bitSet = !isExclude ? ((IncludeFilterExecuterImpl)filterExecuter).getFilteredIndexes(dimensionColumnPage, rawColumnChunk.getRowCount()[i], useBitsetPipeLine, blockChunkHolder.getBitSetGroup(), i) : ((ExcludeFilterExecuterImpl)filterExecuter).getFilteredIndexes(dimensionColumnPage, rawColumnChunk.getRowCount()[i], useBitsetPipeLine, blockChunkHolder.getBitSetGroup(), i);
                } else {
                    bitSet = this.getFilteredIndexes(dimensionColumnPage, rawColumnChunk.getRowCount()[i]);
                }
                bitSetGroup.setBitSet(bitSet, i);
                continue;
            }
            bitSet = this.getFilteredIndexes(rawColumnChunk.decodeColumnPage(i), rawColumnChunk.getRowCount()[i]);
            bitSetGroup.setBitSet(bitSet, i);
        }
        return bitSetGroup;
    }

    private BitSet getFilteredIndexes(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        if (dimensionColumnPage.isExplicitSorted()) {
            return this.setFilterdIndexToBitSetWithColumnIndex(dimensionColumnPage, numerOfRows);
        }
        return this.setFilterdIndexToBitSet(dimensionColumnPage, numerOfRows);
    }

    private BitSet setFilterdIndexToBitSetWithColumnIndex(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        int start = 0;
        int startIndex = 0;
        int startMin = 0;
        int endMax = 0;
        byte[][] filterValues = this.filterRangesValues;
        if (!this.startBlockMinIsDefaultStart) {
            start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, filterValues[0], this.greaterThanExp);
            if (this.greaterThanExp && start >= 0) {
                start = CarbonUtil.nextGreaterValueToTarget(start, dimensionColumnPage, filterValues[0], numerOfRows);
            }
            if (start < 0) {
                if ((start = -(start + 1)) == numerOfRows) {
                    --start;
                }
                if (ByteUtil.compare(filterValues[0], dimensionColumnPage.getChunkData(dimensionColumnPage.getInvertedIndex(start))) > 0) {
                    ++start;
                }
            }
            startMin = start;
        } else {
            startMin = startIndex;
        }
        if (!this.endBlockMaxisDefaultEnd) {
            start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, filterValues[1], this.lessThanEqualExp);
            if (this.lessThanExp && start >= 0) {
                start = CarbonUtil.nextLesserValueToTarget(start, dimensionColumnPage, filterValues[1]);
            }
            if (start < 0) {
                if ((start = -(start + 1)) == numerOfRows) {
                    --start;
                }
                if (ByteUtil.compare(filterValues[1], dimensionColumnPage.getChunkData(dimensionColumnPage.getInvertedIndex(start))) < 0) {
                    --start;
                }
            }
            endMax = start;
        } else {
            endMax = numerOfRows - 1;
        }
        for (int j = startMin; j <= endMax; ++j) {
            bitSet.set(dimensionColumnPage.getInvertedIndex(j));
        }
        if (dimensionColumnPage.isNoDicitionaryColumn() && !dimensionColumnPage.isAdaptiveEncoded()) {
            this.updateForNoDictionaryColumn(startMin, endMax, dimensionColumnPage, bitSet);
        }
        return bitSet;
    }

    private void updateForNoDictionaryColumn(int start, int end, DimensionColumnPage dataChunk, BitSet bitset) {
        for (int j = start; j <= end; ++j) {
            if (dataChunk.compareTo(j, CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY) != 0 && dataChunk.compareTo(j, CarbonCommonConstants.EMPTY_BYTE_ARRAY) != 0) continue;
            bitset.flip(j);
        }
    }

    private BitSet setFilterdIndexToBitSet(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        byte[][] filterValues = this.filterRangesValues;
        if (dimensionColumnPage.isExplicitSorted()) {
            int start = 0;
            int startMin = 0;
            int endMax = 0;
            int startIndex = 0;
            if (!this.startBlockMinIsDefaultStart) {
                start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, filterValues[0], this.greaterThanExp);
                if (this.greaterThanExp && start >= 0) {
                    start = CarbonUtil.nextGreaterValueToTarget(start, dimensionColumnPage, filterValues[0], numerOfRows);
                }
                if (start < 0) {
                    if ((start = -(start + 1)) == numerOfRows) {
                        --start;
                    }
                    if (ByteUtil.compare(filterValues[0], dimensionColumnPage.getChunkData(start)) > 0) {
                        ++start;
                    }
                }
                startMin = start;
            } else {
                startMin = startIndex;
            }
            if (!this.endBlockMaxisDefaultEnd) {
                start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, filterValues[1], this.lessThanEqualExp);
                if (this.lessThanExp && start >= 0) {
                    start = CarbonUtil.nextLesserValueToTarget(start, dimensionColumnPage, filterValues[1]);
                }
                if (start < 0) {
                    if ((start = -(start + 1)) == numerOfRows) {
                        --start;
                    }
                    if (ByteUtil.compare(filterValues[1], dimensionColumnPage.getChunkData(start)) < 0) {
                        --start;
                    }
                }
                endMax = start;
            } else {
                endMax = numerOfRows - 1;
            }
            for (int j = startMin; j <= endMax; ++j) {
                bitSet.set(j);
            }
            if (dimensionColumnPage.isNoDicitionaryColumn()) {
                this.updateForNoDictionaryColumn(startMin, endMax, dimensionColumnPage, bitSet);
            }
        } else {
            byte[] defaultValue = null;
            if (this.dimColEvaluatorInfo.getDimension().getDataType() == DataTypes.DATE) {
                defaultValue = FilterUtil.getDefaultNullValue(this.dimColEvaluatorInfo.getDimension());
            } else if (this.dimColEvaluatorInfo.getDimension().getDataType() == DataTypes.STRING) {
                defaultValue = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
            } else if (!dimensionColumnPage.isAdaptiveEncoded()) {
                defaultValue = CarbonCommonConstants.EMPTY_BYTE_ARRAY;
            }
            bitSet = this.evaluateGreaterThanFilterForUnsortedColumn(dimensionColumnPage, filterValues[0], numerOfRows);
            BitSet upperRangeBitSet = this.evaluateLessThanFilterForUnsortedColumn(dimensionColumnPage, filterValues[1], numerOfRows);
            bitSet.and(upperRangeBitSet);
            FilterUtil.removeNullValues(dimensionColumnPage, bitSet, defaultValue);
        }
        return bitSet;
    }

    private BitSet evaluateGreaterThanFilterForUnsortedColumn(DimensionColumnPage dimensionColumnPage, byte[] filterValue, int numberOfRows) {
        BitSet bitSet;
        block3: {
            block2: {
                bitSet = new BitSet(numberOfRows);
                if (!this.greaterThanExp) break block2;
                for (int i = 0; i < numberOfRows; ++i) {
                    if (ByteUtil.compare(dimensionColumnPage.getChunkData(i), filterValue) <= 0) continue;
                    bitSet.set(i);
                }
                break block3;
            }
            if (!this.greaterThanEqualExp) break block3;
            for (int i = 0; i < numberOfRows; ++i) {
                if (ByteUtil.compare(dimensionColumnPage.getChunkData(i), filterValue) < 0) continue;
                bitSet.set(i);
            }
        }
        return bitSet;
    }

    private BitSet evaluateLessThanFilterForUnsortedColumn(DimensionColumnPage dimensionColumnPage, byte[] filterValue, int numberOfRows) {
        BitSet bitSet;
        block3: {
            block2: {
                bitSet = new BitSet(numberOfRows);
                if (!this.lessThanExp) break block2;
                for (int i = 0; i < numberOfRows; ++i) {
                    if (ByteUtil.compare(dimensionColumnPage.getChunkData(i), filterValue) >= 0) continue;
                    bitSet.set(i);
                }
                break block3;
            }
            if (!this.lessThanEqualExp) break block3;
            for (int i = 0; i < numberOfRows; ++i) {
                if (ByteUtil.compare(dimensionColumnPage.getChunkData(i), filterValue) > 0) continue;
                bitSet.set(i);
            }
        }
        return bitSet;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        if (this.isDimensionPresentInCurrentBlock) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimColEvaluatorInfo.getColumnIndex());
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        }
    }
}

