/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

public abstract class RestructureEvaluatorImpl
implements FilterExecuter {
    protected boolean isDimensionDefaultValuePresentInFilterValues(DimColumnResolvedFilterInfo dimColumnEvaluatorInfo) {
        boolean isDefaultValuePresentInFilterValues = false;
        ColumnFilterInfo filterValues = dimColumnEvaluatorInfo.getFilterValues();
        CarbonDimension dimension = dimColumnEvaluatorInfo.getDimension();
        byte[] defaultValue = dimension.getDefaultValue();
        if (dimension.getDataType() != DataTypes.DATE) {
            if (null == defaultValue && dimension.getDataType() == DataTypes.STRING) {
                defaultValue = "@NU#LL$!".getBytes(Charset.forName("UTF-8"));
            } else if (null == defaultValue) {
                defaultValue = CarbonCommonConstants.EMPTY_BYTE_ARRAY;
            }
            List<byte[]> noDictionaryFilterValuesList = filterValues.getNoDictionaryFilterValuesList();
            for (byte[] filterValue : noDictionaryFilterValuesList) {
                int compare = FilterUtil.compareValues(filterValue, defaultValue, dimension, true);
                if (compare != 0) continue;
                isDefaultValuePresentInFilterValues = true;
                break;
            }
        } else {
            int defaultSurrogateValueToCompare = 1;
            if (null != defaultValue) {
                if (dimension.getDataType() == DataTypes.DATE) {
                    DirectDictionaryGenerator directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(dimension.getDataType());
                    if (directDictionaryGenerator != null) {
                        String value = new String(defaultValue, Charset.forName("UTF-8"));
                        defaultSurrogateValueToCompare = Integer.parseInt(value);
                    }
                } else {
                    ++defaultSurrogateValueToCompare;
                }
            }
            List<Integer> filterList = null;
            filterList = filterValues.isIncludeFilter() && !filterValues.isOptimized() ? filterValues.getFilterList() : filterValues.getExcludeFilterList();
            for (Integer filterValue : filterList) {
                if (defaultSurrogateValueToCompare != filterValue) continue;
                isDefaultValuePresentInFilterValues = true;
                break;
            }
        }
        return isDefaultValuePresentInFilterValues;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) throws FilterUnsupportedException {
        throw new FilterUnsupportedException("Unsupported RestructureEvaluatorImpl on pune pages");
    }

    protected boolean isMeasureDefaultValuePresentInFilterValues(MeasureColumnResolvedFilterInfo measureColumnResolvedFilterInfo) {
        boolean isDefaultValuePresentInFilterValues = false;
        ColumnFilterInfo filterValues = measureColumnResolvedFilterInfo.getFilterValues();
        CarbonMeasure measure = measureColumnResolvedFilterInfo.getMeasure();
        SerializableComparator comparator = Comparator.getComparatorByDataTypeForMeasure(measure.getDataType());
        Object defaultValue = null;
        if (null != measure.getDefaultValue()) {
            defaultValue = RestructureUtil.getMeasureDefaultValue(measure.getColumnSchema(), measure.getDefaultValue());
        }
        List<Object> measureFilterValuesList = filterValues.getMeasuresFilterValuesList();
        for (Object filterValue : measureFilterValuesList) {
            int compare = comparator.compare(defaultValue, filterValue);
            if (compare != 0) continue;
            isDefaultValuePresentInFilterValues = true;
            break;
        }
        return isDefaultValuePresentInFilterValues;
    }
}

