/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.util.BitSet;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.RestructureEvaluatorImpl;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;

public class RestructureExcludeFilterExecutorImpl
extends RestructureEvaluatorImpl {
    private boolean isDefaultValuePresentInFilterValues;

    public RestructureExcludeFilterExecutorImpl(DimColumnResolvedFilterInfo dimColEvaluatorInfo, MeasureColumnResolvedFilterInfo measureColumnResolvedFilterInfo, boolean isMeasure) {
        this.isDefaultValuePresentInFilterValues = isMeasure ? this.isMeasureDefaultValuePresentInFilterValues(measureColumnResolvedFilterInfo) : this.isDimensionDefaultValuePresentInFilterValues(dimColEvaluatorInfo);
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) {
        int numberOfRows = rawBlockletColumnChunks.getDataBlock().numRows();
        return FilterUtil.createBitSetGroupWithDefaultValue(rawBlockletColumnChunks.getDataBlock().numberOfPages(), numberOfRows, !this.isDefaultValuePresentInFilterValues);
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) throws FilterUnsupportedException {
        throw new FilterUnsupportedException("Unsupported RestructureExcludeFilterExecutorImpl on row");
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        bitSet.flip(0, 1);
        return bitSet;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) {
    }
}

