/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.VariableLengthDimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.store.ColumnPageWrapper;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.MatchExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.intf.RowImpl;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.log4j.Logger;

public class RowLevelFilterExecuterImpl
implements FilterExecuter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)RowLevelFilterExecuterImpl.class.getName());
    List<DimColumnResolvedFilterInfo> dimColEvaluatorInfoList;
    List<MeasureColumnResolvedFilterInfo> msrColEvalutorInfoList;
    protected Expression exp;
    protected AbsoluteTableIdentifier tableIdentifier;
    protected SegmentProperties segmentProperties;
    int[] dimensionChunkIndex;
    int[] measureChunkIndex;
    private Map<Integer, GenericQueryType> complexDimensionInfoMap;
    boolean[] isDimensionPresentInCurrentBlock;
    boolean[] isMeasurePresentInCurrentBlock;
    boolean isNaturalSorted;

    public RowLevelFilterExecuterImpl(List<DimColumnResolvedFilterInfo> dimColEvaluatorInfoList, List<MeasureColumnResolvedFilterInfo> msrColEvalutorInfoList, Expression exp, AbsoluteTableIdentifier tableIdentifier, SegmentProperties segmentProperties, Map<Integer, GenericQueryType> complexDimensionInfoMap) {
        this.segmentProperties = segmentProperties;
        this.dimColEvaluatorInfoList = null == dimColEvaluatorInfoList ? new ArrayList<DimColumnResolvedFilterInfo>(16) : dimColEvaluatorInfoList;
        if (this.dimColEvaluatorInfoList.size() > 0) {
            this.isDimensionPresentInCurrentBlock = new boolean[this.dimColEvaluatorInfoList.size()];
            this.dimensionChunkIndex = new int[this.dimColEvaluatorInfoList.size()];
        } else {
            this.isDimensionPresentInCurrentBlock = new boolean[]{false};
            this.dimensionChunkIndex = new int[]{0};
        }
        this.msrColEvalutorInfoList = null == msrColEvalutorInfoList ? new ArrayList<MeasureColumnResolvedFilterInfo>(20) : msrColEvalutorInfoList;
        if (this.msrColEvalutorInfoList.size() > 0) {
            this.isMeasurePresentInCurrentBlock = new boolean[this.msrColEvalutorInfoList.size()];
            this.measureChunkIndex = new int[this.msrColEvalutorInfoList.size()];
        } else {
            this.isMeasurePresentInCurrentBlock = new boolean[]{false};
            this.measureChunkIndex = new int[]{0};
        }
        this.exp = exp;
        this.tableIdentifier = tableIdentifier;
        this.complexDimensionInfoMap = complexDimensionInfoMap;
        this.initDimensionChunkIndexes();
        this.initMeasureChunkIndexes();
    }

    private void initDimensionChunkIndexes() {
        for (int i = 0; i < this.dimColEvaluatorInfoList.size(); ++i) {
            CarbonDimension dimensionFromCurrentBlock = this.segmentProperties.getDimensionFromCurrentBlock(this.dimColEvaluatorInfoList.get(i).getDimension());
            if (null == dimensionFromCurrentBlock) continue;
            this.dimColEvaluatorInfoList.get(i).setColumnIndex(dimensionFromCurrentBlock.getOrdinal());
            this.dimensionChunkIndex[i] = this.dimColEvaluatorInfoList.get(i).getColumnIndexInMinMaxByteArray();
            this.isDimensionPresentInCurrentBlock[i] = true;
        }
    }

    private void initMeasureChunkIndexes() {
        for (int i = 0; i < this.msrColEvalutorInfoList.size(); ++i) {
            CarbonMeasure measureFromCurrentBlock = this.segmentProperties.getMeasureFromCurrentBlock(this.msrColEvalutorInfoList.get(i).getMeasure());
            if (null == measureFromCurrentBlock) continue;
            this.msrColEvalutorInfoList.get(i).setColumnIndex(measureFromCurrentBlock.getOrdinal());
            this.measureChunkIndex[i] = this.msrColEvalutorInfoList.get(i).getColumnIndexInMinMaxByteArray();
            this.isMeasurePresentInCurrentBlock[i] = true;
        }
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws FilterUnsupportedException, IOException {
        int i;
        if (this.exp instanceof MatchExpression) {
            BitSetGroup bitSetGroup = rawBlockletColumnChunks.getBitSetGroup();
            if (bitSetGroup == null) {
                throw new FilterUnsupportedException(String.format("%s is not supported on table %s", this.exp.getFilterExpressionType().name(), this.tableIdentifier.getTableName()));
            }
            return bitSetGroup;
        }
        this.readColumnChunks(rawBlockletColumnChunks);
        int[] numberOfRows = null;
        int pageNumbers = 0;
        if (this.dimColEvaluatorInfoList.size() > 0) {
            if (this.isDimensionPresentInCurrentBlock[0]) {
                pageNumbers = rawBlockletColumnChunks.getDimensionRawColumnChunks()[this.dimensionChunkIndex[0]].getPagesCount();
                numberOfRows = rawBlockletColumnChunks.getDimensionRawColumnChunks()[this.dimensionChunkIndex[0]].getRowCount();
            } else {
                pageNumbers = rawBlockletColumnChunks.getDataBlock().numberOfPages();
                numberOfRows = new int[pageNumbers];
                for (i = 0; i < pageNumbers; ++i) {
                    numberOfRows[i] = rawBlockletColumnChunks.getDataBlock().getPageRowCount(i);
                }
            }
        }
        if (this.msrColEvalutorInfoList.size() > 0) {
            if (this.isMeasurePresentInCurrentBlock[0]) {
                pageNumbers = rawBlockletColumnChunks.getMeasureRawColumnChunks()[this.msrColEvalutorInfoList.get(0).getColumnIndex()].getPagesCount();
                numberOfRows = rawBlockletColumnChunks.getMeasureRawColumnChunks()[this.msrColEvalutorInfoList.get(0).getColumnIndex()].getRowCount();
            } else {
                pageNumbers = rawBlockletColumnChunks.getDataBlock().numberOfPages();
                numberOfRows = new int[pageNumbers];
                for (i = 0; i < pageNumbers; ++i) {
                    numberOfRows[i] = rawBlockletColumnChunks.getDataBlock().getPageRowCount(i);
                }
            }
        }
        BitSetGroup bitSetGroup = new BitSetGroup(pageNumbers);
        for (int i2 = 0; i2 < pageNumbers; ++i2) {
            Boolean rslt;
            int index;
            BitSet set = new BitSet(numberOfRows[i2]);
            RowImpl row = new RowImpl();
            BitSet prvBitset = null;
            if (!useBitsetPipeLine || null == rawBlockletColumnChunks.getBitSetGroup() || null == bitSetGroup.getBitSet(i2) || rawBlockletColumnChunks.getBitSetGroup().getBitSet(i2).isEmpty()) {
                for (index = 0; index < numberOfRows[i2]; ++index) {
                    this.createRow(rawBlockletColumnChunks, row, i2, index);
                    rslt = false;
                    try {
                        rslt = this.exp.evaluate(row).getBoolean();
                    }
                    catch (FilterIllegalMemberException e) {
                        FilterUtil.logError(e, false);
                    }
                    if (null == rslt || !rslt.booleanValue()) continue;
                    set.set(index);
                }
            } else {
                prvBitset = rawBlockletColumnChunks.getBitSetGroup().getBitSet(i2);
                index = prvBitset.nextSetBit(0);
                while (index >= 0) {
                    this.createRow(rawBlockletColumnChunks, row, i2, index);
                    rslt = false;
                    try {
                        rslt = this.exp.evaluate(row).getBoolean();
                    }
                    catch (FilterIllegalMemberException e) {
                        FilterUtil.logError(e, false);
                    }
                    if (null != rslt && rslt.booleanValue()) {
                        set.set(index);
                    }
                    index = prvBitset.nextSetBit(index + 1);
                }
            }
            bitSetGroup.setBitSet(set, i2);
        }
        return bitSetGroup;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        this.readColumnChunks(rawBlockletColumnChunks);
        int pages = rawBlockletColumnChunks.getDataBlock().numberOfPages();
        BitSet bitSet = new BitSet();
        bitSet.set(0, pages);
        return bitSet;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) throws FilterUnsupportedException {
        try {
            Boolean result = this.exp.evaluate(this.convertRow(value, dimOrdinalMax)).getBoolean();
            return result == null ? false : result;
        }
        catch (FilterIllegalMemberException e) {
            throw new FilterUnsupportedException(e);
        }
    }

    private RowIntf convertRow(RowIntf value, int dimOrdinalMax) {
        int index;
        int i;
        Object[] record = new Object[value.size()];
        for (i = 0; i < this.dimColEvaluatorInfoList.size(); ++i) {
            DimColumnResolvedFilterInfo dimColumnEvaluatorInfo = this.dimColEvaluatorInfoList.get(i);
            index = dimColumnEvaluatorInfo.getDimension().getOrdinal();
            if (!this.isDimensionPresentInCurrentBlock[i]) {
                record[index] = this.getDimensionDefaultValue(dimColumnEvaluatorInfo);
                continue;
            }
            if (!dimColumnEvaluatorInfo.getDimension().getDataType().isComplexType()) {
                byte[] memberBytes;
                if (!dimColumnEvaluatorInfo.isDimensionExistsInCurrentSilce()) {
                    record[index] = dimColumnEvaluatorInfo.getDimension().getDefaultValue();
                }
                if (null == (memberBytes = (byte[])value.getVal(index))) continue;
                if (Arrays.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, memberBytes)) {
                    memberBytes = null;
                } else if (memberBytes.length == 0) {
                    memberBytes = null;
                }
                record[index] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(memberBytes, dimColumnEvaluatorInfo.getDimension().getDataType());
                continue;
            }
            record[index] = value.getVal(index);
        }
        for (i = 0; i < this.msrColEvalutorInfoList.size(); ++i) {
            MeasureColumnResolvedFilterInfo msrColumnEvalutorInfo = this.msrColEvalutorInfoList.get(i);
            index = msrColumnEvalutorInfo.getMeasure().getOrdinal() + dimOrdinalMax;
            if (!this.isMeasurePresentInCurrentBlock[i]) {
                byte[] defaultValue = msrColumnEvalutorInfo.getCarbonColumn().getDefaultValue();
                record[index] = RestructureUtil.getMeasureDefaultValue(msrColumnEvalutorInfo.getCarbonColumn().getColumnSchema(), defaultValue);
                continue;
            }
            record[index] = value.getVal(index);
        }
        RowImpl row = new RowImpl();
        row.setValues(record);
        return row;
    }

    private void createRow(RawBlockletColumnChunks blockChunkHolder, RowIntf row, int pageIndex, int index) {
        Object[] record = new Object[this.dimColEvaluatorInfoList.size() + this.msrColEvalutorInfoList.size()];
        for (int i = 0; i < this.dimColEvaluatorInfoList.size(); ++i) {
            DimColumnResolvedFilterInfo dimColumnEvaluatorInfo = this.dimColEvaluatorInfoList.get(i);
            if (!this.isDimensionPresentInCurrentBlock[i]) {
                record[dimColumnEvaluatorInfo.getRowIndex()] = this.getDimensionDefaultValue(dimColumnEvaluatorInfo);
                continue;
            }
            if (!dimColumnEvaluatorInfo.getDimension().getDataType().isComplexType()) {
                byte[] memberBytes;
                if (!dimColumnEvaluatorInfo.isDimensionExistsInCurrentSilce()) {
                    record[dimColumnEvaluatorInfo.getRowIndex()] = dimColumnEvaluatorInfo.getDimension().getDefaultValue();
                }
                DimensionColumnPage columnDataChunk = blockChunkHolder.getDimensionRawColumnChunks()[this.dimensionChunkIndex[i]].decodeColumnPage(pageIndex);
                if (dimColumnEvaluatorInfo.getDimension().getDataType() == DataTypes.DATE || !(columnDataChunk instanceof VariableLengthDimensionColumnPage) && !(columnDataChunk instanceof ColumnPageWrapper) || null == (memberBytes = columnDataChunk.getChunkData(index))) continue;
                if (Arrays.equals(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY, memberBytes)) {
                    memberBytes = null;
                } else if (memberBytes.length == 0) {
                    memberBytes = null;
                }
                record[dimColumnEvaluatorInfo.getRowIndex()] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(memberBytes, dimColumnEvaluatorInfo.getDimension().getDataType());
                continue;
            }
            try {
                GenericQueryType complexType = this.complexDimensionInfoMap.get(this.dimensionChunkIndex[i]);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteStream);
                complexType.parseBlocksAndReturnComplexColumnByteArray(blockChunkHolder.getDimensionRawColumnChunks(), null, index, pageIndex, dataOutputStream);
                record[dimColumnEvaluatorInfo.getRowIndex()] = complexType.getDataBasedOnDataType(ByteBuffer.wrap(byteStream.toByteArray()));
                byteStream.close();
                continue;
            }
            catch (IOException e) {
                LOGGER.info((Object)e.getMessage());
            }
        }
        for (int i = 0; i < this.msrColEvalutorInfoList.size(); ++i) {
            Comparable<Boolean> msrValue;
            MeasureColumnResolvedFilterInfo msrColumnEvalutorInfo = this.msrColEvalutorInfoList.get(i);
            DataType dataType = msrColumnEvalutorInfo.getType();
            DataType msrType = dataType == DataTypes.BOOLEAN ? DataTypes.BOOLEAN : (dataType == DataTypes.SHORT ? DataTypes.SHORT : (dataType == DataTypes.INT ? DataTypes.INT : (dataType == DataTypes.LONG ? DataTypes.LONG : (DataTypes.isDecimal(dataType) ? DataTypes.createDefaultDecimalType() : DataTypes.DOUBLE))));
            if (!this.isMeasurePresentInCurrentBlock[i]) {
                byte[] defaultValue = msrColumnEvalutorInfo.getCarbonColumn().getDefaultValue();
                record[msrColumnEvalutorInfo.getRowIndex()] = RestructureUtil.getMeasureDefaultValue(msrColumnEvalutorInfo.getCarbonColumn().getColumnSchema(), defaultValue);
                continue;
            }
            ColumnPage columnPage = blockChunkHolder.getMeasureRawColumnChunks()[this.msrColEvalutorInfoList.get(0).getColumnIndex()].decodeColumnPage(pageIndex);
            if (msrType == DataTypes.BOOLEAN) {
                msrValue = columnPage.getBoolean(index);
            } else if (msrType == DataTypes.SHORT) {
                msrValue = (short)columnPage.getLong(index);
            } else if (msrType == DataTypes.INT) {
                msrValue = (int)columnPage.getLong(index);
            } else if (msrType == DataTypes.LONG) {
                msrValue = columnPage.getLong(index);
            } else if (DataTypes.isDecimal(msrType)) {
                BigDecimal bigDecimalValue = columnPage.getDecimal(index);
                if (null != bigDecimalValue && msrColumnEvalutorInfo.getCarbonColumn().getColumnSchema().getScale() > bigDecimalValue.scale()) {
                    bigDecimalValue = bigDecimalValue.setScale(msrColumnEvalutorInfo.getCarbonColumn().getColumnSchema().getScale(), RoundingMode.HALF_UP);
                }
                msrValue = bigDecimalValue;
            } else {
                msrValue = columnPage.getDouble(index);
            }
            record[msrColumnEvalutorInfo.getRowIndex()] = columnPage.getNullBits().get(index) ? null : msrValue;
        }
        row.setValues(record);
    }

    private Object getDimensionDefaultValue(DimColumnResolvedFilterInfo dimColumnEvaluatorInfo) {
        CarbonDimension dimension = dimColumnEvaluatorInfo.getDimension();
        return RestructureUtil.validateAndGetDefaultValue(dimension);
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        bitSet.set(0);
        return bitSet;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        for (int i = 0; i < this.dimColEvaluatorInfoList.size(); ++i) {
            DimColumnResolvedFilterInfo dimColumnEvaluatorInfo = this.dimColEvaluatorInfoList.get(i);
            if (!dimColumnEvaluatorInfo.getDimension().getDataType().isComplexType()) {
                if (null != rawBlockletColumnChunks.getDimensionRawColumnChunks()[this.dimensionChunkIndex[i]]) continue;
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[this.dimensionChunkIndex[i]] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), this.dimensionChunkIndex[i]);
                continue;
            }
            GenericQueryType complexType = this.complexDimensionInfoMap.get(this.dimensionChunkIndex[i]);
            complexType.fillRequiredBlockData(rawBlockletColumnChunks);
        }
        for (MeasureColumnResolvedFilterInfo msrColumnEvalutorInfo : this.msrColEvalutorInfoList) {
            int chunkIndex = this.msrColEvalutorInfoList.get(0).getColumnIndex();
            if (null != rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) continue;
            rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
        }
    }
}

