/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.chunk.DimensionColumnPage;
import org.apache.carbondata.core.datastore.chunk.impl.DimensionRawColumnChunk;
import org.apache.carbondata.core.datastore.chunk.impl.MeasureRawColumnChunk;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.ExcludeFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.executer.IncludeFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.executer.RowLevelFilterExecuterImpl;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

public class RowLevelRangeLessThanEqualFilterExecuterImpl
extends RowLevelFilterExecuterImpl {
    protected byte[][] filterRangeValues;
    protected Object[] msrFilterRangeValues;
    protected SerializableComparator comparator;
    private boolean isDefaultValuePresentInFilter;

    public RowLevelRangeLessThanEqualFilterExecuterImpl(List<DimColumnResolvedFilterInfo> dimColEvaluatorInfoList, List<MeasureColumnResolvedFilterInfo> msrColEvalutorInfoList, Expression exp, AbsoluteTableIdentifier tableIdentifier, byte[][] filterRangeValues, Object[] msrFilterRangeValues, SegmentProperties segmentProperties) {
        super(dimColEvaluatorInfoList, msrColEvalutorInfoList, exp, tableIdentifier, segmentProperties, null);
        this.filterRangeValues = filterRangeValues;
        this.msrFilterRangeValues = msrFilterRangeValues;
        if (!msrColEvalutorInfoList.isEmpty()) {
            CarbonMeasure measure = ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getMeasure();
            this.comparator = Comparator.getComparatorByDataTypeForMeasure(measure.getDataType());
        }
        this.ifDefaultValueMatchesFilter();
        if (this.isDimensionPresentInCurrentBlock[0]) {
            this.isNaturalSorted = dimColEvaluatorInfoList.get(0).getDimension().isUseInvertedIndex() != false && dimColEvaluatorInfoList.get(0).getDimension().isSortColumn();
        }
    }

    private void ifDefaultValueMatchesFilter() {
        block4: {
            block5: {
                if (this.dimColEvaluatorInfoList.isEmpty() || this.isDimensionPresentInCurrentBlock[0]) break block5;
                CarbonDimension dimension = ((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension();
                byte[] defaultValue = dimension.getDefaultValue();
                if (null == defaultValue) break block4;
                for (int k = 0; k < this.filterRangeValues.length; ++k) {
                    int maxCompare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.filterRangeValues[k], defaultValue);
                    if (maxCompare < 0) continue;
                    this.isDefaultValuePresentInFilter = true;
                    break block4;
                }
                break block4;
            }
            if (!this.msrColEvalutorInfoList.isEmpty() && !this.isMeasurePresentInCurrentBlock[0]) {
                CarbonMeasure measure = ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getMeasure();
                byte[] defaultValue = measure.getDefaultValue();
                SerializableComparator comparatorTmp = Comparator.getComparatorByDataTypeForMeasure(measure.getDataType());
                if (null != defaultValue) {
                    for (int k = 0; k < this.msrFilterRangeValues.length; ++k) {
                        int maxCompare = comparatorTmp.compare(this.msrFilterRangeValues[k], RestructureUtil.getMeasureDefaultValue(measure.getColumnSchema(), measure.getDefaultValue()));
                        if (maxCompare < 0) continue;
                        this.isDefaultValuePresentInFilter = true;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        byte[] minValue = null;
        boolean isScanRequired = false;
        if (this.isMeasurePresentInCurrentBlock[0] || this.isDimensionPresentInCurrentBlock[0]) {
            if (this.isMeasurePresentInCurrentBlock[0]) {
                if (isMinMaxSet[this.measureChunkIndex[0]]) {
                    minValue = blockMinValue[this.measureChunkIndex[0]];
                    isScanRequired = this.isScanRequired(minValue, this.msrFilterRangeValues, ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getType());
                } else {
                    isScanRequired = true;
                }
            } else {
                minValue = blockMinValue[this.dimensionChunkIndex[0]];
                DataType dataType = ((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType();
                isScanRequired = DataTypeUtil.isPrimitiveColumn(dataType) && ((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() != DataTypes.DATE ? this.isScanRequired(minValue, this.filterRangeValues, dataType) : this.isScanRequired(minValue, this.filterRangeValues, isMinMaxSet[this.dimensionChunkIndex[0]]);
            }
        } else {
            isScanRequired = this.isDefaultValuePresentInFilter;
        }
        if (isScanRequired) {
            bitSet.set(0);
        }
        return bitSet;
    }

    private boolean isScanRequired(byte[] blockMinValue, byte[][] filterValues, boolean isMinMaxSet) {
        if (!isMinMaxSet) {
            return true;
        }
        boolean isScanRequired = false;
        for (int k = 0; k < filterValues.length; ++k) {
            int minCompare = ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterValues[k], blockMinValue);
            if (minCompare < 0) continue;
            isScanRequired = true;
            break;
        }
        return isScanRequired;
    }

    private boolean isScanRequired(byte[] blockMinValue, byte[][] filterValues, DataType dataType) {
        boolean isScanRequired = false;
        Object minValue = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(blockMinValue, dataType);
        for (int k = 0; k < filterValues.length; ++k) {
            if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterValues[k], CarbonCommonConstants.EMPTY_BYTE_ARRAY) == 0) {
                return true;
            }
            Object data = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(filterValues[k], dataType);
            SerializableComparator comparator = Comparator.getComparator(dataType);
            int minCompare = comparator.compare(data, minValue);
            if (minCompare < 0) continue;
            isScanRequired = true;
            break;
        }
        return isScanRequired;
    }

    private boolean isScanRequired(byte[] minValue, Object[] filterValue, DataType dataType) {
        Object value = DataTypeUtil.getMeasureObjectFromDataType(minValue, dataType);
        for (int i = 0; i < filterValue.length; ++i) {
            if (filterValue[i] == null) {
                return true;
            }
            if (this.comparator.compare(filterValue[i], value) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) throws IOException {
        if (!this.isDimensionPresentInCurrentBlock[0] && !this.isMeasurePresentInCurrentBlock[0]) {
            int numberOfRows = rawBlockletColumnChunks.getDataBlock().numRows();
            return FilterUtil.createBitSetGroupWithDefaultValue(rawBlockletColumnChunks.getDataBlock().numberOfPages(), numberOfRows, true);
        }
        if (this.isDimensionPresentInCurrentBlock[0]) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimensionChunkIndex[0]);
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            DimensionRawColumnChunk rawColumnChunk = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
            BitSetGroup bitSetGroup = new BitSetGroup(rawColumnChunk.getPagesCount());
            FilterExecuter filterExecuter = null;
            boolean isExclude = false;
            for (int i = 0; i < rawColumnChunk.getPagesCount(); ++i) {
                BitSet bitSet;
                if (rawColumnChunk.getMinValues() != null) {
                    if (!this.isScanRequired(rawColumnChunk, i)) continue;
                    DimensionColumnPage dimensionColumnPage = rawColumnChunk.decodeColumnPage(i);
                    if (null != rawColumnChunk.getLocalDictionary()) {
                        if (null == filterExecuter && (filterExecuter = FilterUtil.getFilterExecutorForRangeFilters(rawColumnChunk, this.exp, this.isNaturalSorted)) instanceof ExcludeFilterExecuterImpl) {
                            isExclude = true;
                        }
                        bitSet = !isExclude ? ((IncludeFilterExecuterImpl)filterExecuter).getFilteredIndexes(dimensionColumnPage, rawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i) : ((ExcludeFilterExecuterImpl)filterExecuter).getFilteredIndexes(dimensionColumnPage, rawColumnChunk.getRowCount()[i], useBitsetPipeLine, rawBlockletColumnChunks.getBitSetGroup(), i);
                    } else {
                        bitSet = this.getFilteredIndexes(dimensionColumnPage, rawColumnChunk.getRowCount()[i]);
                    }
                    bitSetGroup.setBitSet(bitSet, i);
                    continue;
                }
                bitSet = this.getFilteredIndexes(rawColumnChunk.decodeColumnPage(i), rawColumnChunk.getRowCount()[i]);
                bitSetGroup.setBitSet(bitSet, i);
            }
            return bitSetGroup;
        }
        if (this.isMeasurePresentInCurrentBlock[0]) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            MeasureRawColumnChunk rawColumnChunk = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
            BitSetGroup bitSetGroup = new BitSetGroup(rawColumnChunk.getPagesCount());
            for (int i = 0; i < rawColumnChunk.getPagesCount(); ++i) {
                BitSet bitSet;
                if (rawColumnChunk.getMinValues() != null) {
                    if (!this.isScanRequired(rawColumnChunk.getMinValues()[i], this.msrFilterRangeValues, ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getType())) continue;
                    bitSet = this.getFilteredIndexesForMeasures(rawColumnChunk.decodeColumnPage(i), rawColumnChunk.getRowCount()[i]);
                    bitSetGroup.setBitSet(bitSet, i);
                    continue;
                }
                bitSet = this.getFilteredIndexesForMeasures(rawColumnChunk.decodeColumnPage(i), rawColumnChunk.getRowCount()[i]);
                bitSetGroup.setBitSet(bitSet, i);
            }
            return bitSetGroup;
        }
        return null;
    }

    private boolean isScanRequired(DimensionRawColumnChunk rawColumnChunk, int i) {
        DataType dataType = ((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType();
        boolean scanRequired = DataTypeUtil.isPrimitiveColumn(dataType) && ((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() != DataTypes.DATE ? this.isScanRequired(rawColumnChunk.getMinValues()[i], this.filterRangeValues, dataType) : this.isScanRequired(rawColumnChunk.getMinValues()[i], this.filterRangeValues, rawColumnChunk.getMinMaxFlagArray()[i]);
        return scanRequired;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        if (!this.isDimensionPresentInCurrentBlock[0] && !this.isMeasurePresentInCurrentBlock[0]) {
            int numberOfPages = rawBlockletColumnChunks.getDataBlock().numberOfPages();
            BitSet bitSet = new BitSet(numberOfPages);
            bitSet.set(0, numberOfPages);
            return bitSet;
        }
        if (this.isDimensionPresentInCurrentBlock[0]) {
            int chunkIndex = this.segmentProperties.getDimensionOrdinalToChunkMapping().get(this.dimensionChunkIndex[0]);
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            DimensionRawColumnChunk rawColumnChunk = rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex];
            BitSet bitSet = new BitSet(rawColumnChunk.getPagesCount());
            for (int i = 0; i < rawColumnChunk.getPagesCount(); ++i) {
                if (rawColumnChunk.getMinValues() != null) {
                    if (!this.isScanRequired(rawColumnChunk, i)) continue;
                    bitSet.set(i);
                    continue;
                }
                bitSet.set(i);
            }
            return bitSet;
        }
        if (this.isMeasurePresentInCurrentBlock[0]) {
            int chunkIndex = this.segmentProperties.getMeasuresOrdinalToChunkMapping().get(((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getColumnIndex());
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
            MeasureRawColumnChunk rawColumnChunk = rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex];
            BitSet bitSet = new BitSet(rawColumnChunk.getPagesCount());
            for (int i = 0; i < rawColumnChunk.getPagesCount(); ++i) {
                if (rawColumnChunk.getMinValues() != null) {
                    if (!this.isScanRequired(rawColumnChunk.getMinValues()[i], this.msrFilterRangeValues, ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getType())) continue;
                    bitSet.set(i);
                    continue;
                }
                bitSet.set(i);
            }
            return bitSet;
        }
        return null;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) {
        if (this.isDimensionPresentInCurrentBlock[0]) {
            byte[] col = (byte[])value.getVal(((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getOrdinal());
            return ByteUtil.compare(this.filterRangeValues[0], col) >= 0;
        }
        if (this.isMeasurePresentInCurrentBlock[0]) {
            Object col = value.getVal(((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getMeasure().getOrdinal() + dimOrdinalMax);
            return this.comparator.compare(this.msrFilterRangeValues[0], col) >= 0;
        }
        return false;
    }

    private BitSet getFilteredIndexesForMeasures(ColumnPage columnPage, int numerOfRows) {
        BitSet bitSet = new BitSet(numerOfRows);
        Object[] filterValues = this.msrFilterRangeValues;
        DataType msrType = ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getType();
        SerializableComparator comparator = Comparator.getComparatorByDataTypeForMeasure(msrType);
        BitSet nullBitSet = columnPage.getNullBits();
        for (int i = 0; i < filterValues.length; ++i) {
            if (filterValues[i] == null) {
                int j = nullBitSet.nextSetBit(0);
                while (j >= 0) {
                    bitSet.set(j);
                    j = nullBitSet.nextSetBit(j + 1);
                }
                continue;
            }
            for (int startIndex = 0; startIndex < numerOfRows; ++startIndex) {
                Object msrValue;
                if (nullBitSet.get(startIndex) || comparator.compare(msrValue = DataTypeUtil.getMeasureObjectBasedOnDataType(columnPage, startIndex, msrType, ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getMeasure()), filterValues[i]) > 0) continue;
                bitSet.set(startIndex);
            }
        }
        return bitSet;
    }

    private BitSet getFilteredIndexes(DimensionColumnPage dimensionColumnPage, int numerOfRows) {
        byte[] defaultValue = null;
        if (((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() == DataTypes.DATE) {
            defaultValue = FilterUtil.getDefaultNullValue(((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension());
        } else if (((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() != DataTypes.STRING) {
            defaultValue = CarbonCommonConstants.EMPTY_BYTE_ARRAY;
        }
        BitSet bitSet = null;
        bitSet = dimensionColumnPage.isExplicitSorted() ? this.setFilterdIndexToBitSetWithColumnIndex(dimensionColumnPage, numerOfRows, dimensionColumnPage.isAdaptiveEncoded() ? null : defaultValue) : this.setFilterdIndexToBitSet(dimensionColumnPage, numerOfRows, dimensionColumnPage.isAdaptiveEncoded() ? null : defaultValue);
        if (((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() == DataTypes.STRING) {
            defaultValue = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
        }
        if (dimensionColumnPage.isNoDicitionaryColumn() || ((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() == DataTypes.DATE) {
            FilterUtil.removeNullValues(dimensionColumnPage, bitSet, defaultValue);
        }
        return bitSet;
    }

    private BitSet setFilterdIndexToBitSetWithColumnIndex(DimensionColumnPage dimensionColumnPage, int numerOfRows, byte[] defaultValue) {
        BitSet bitSet = new BitSet(numerOfRows);
        int start = 0;
        int last = 0;
        int skip = 0;
        int startIndex = 0;
        byte[][] filterValues = this.filterRangeValues;
        if (null != defaultValue) {
            start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, defaultValue, true);
            if (start < 0) {
                skip = -(start + 1);
                if (skip == numerOfRows) {
                    return bitSet;
                }
            } else {
                skip = start + 1;
            }
            startIndex = skip;
        }
        for (int i = 0; i < filterValues.length; ++i) {
            start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, filterValues[i], true);
            if (start < 0) {
                if ((start = -(start + 1)) >= numerOfRows) {
                    --start;
                }
                if (ByteUtil.compare(filterValues[i], dimensionColumnPage.getChunkData(dimensionColumnPage.getInvertedIndex(start))) < 0) {
                    // empty if block
                }
            }
            last = --start;
            for (int j = start; j >= skip; --j) {
                bitSet.set(dimensionColumnPage.getInvertedIndex(j));
                --last;
            }
            startIndex = last;
            if (startIndex <= 0) break;
        }
        return bitSet;
    }

    private BitSet setFilterdIndexToBitSet(DimensionColumnPage dimensionColumnPage, int numerOfRows, byte[] defaultValue) {
        BitSet bitSet = new BitSet(numerOfRows);
        byte[][] filterValues = this.filterRangeValues;
        if (this.isNaturalSorted && dimensionColumnPage.isExplicitSorted()) {
            int start = 0;
            int last = 0;
            int startIndex = 0;
            int skip = 0;
            if (null != defaultValue) {
                start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, defaultValue, true);
                if (start < 0) {
                    skip = -(start + 1);
                    if (skip == numerOfRows) {
                        return bitSet;
                    }
                } else {
                    skip = start + 1;
                }
                startIndex = skip;
            }
            for (int k = 0; k < filterValues.length; ++k) {
                start = CarbonUtil.getFirstIndexUsingBinarySearch(dimensionColumnPage, startIndex, numerOfRows - 1, filterValues[k], true);
                if (start < 0) {
                    if ((start = -(start + 1)) >= numerOfRows) {
                        --start;
                    }
                    if (ByteUtil.compare(filterValues[k], dimensionColumnPage.getChunkData(start)) < 0) {
                        // empty if block
                    }
                }
                last = --start;
                for (int j = start; j >= skip; --j) {
                    bitSet.set(j);
                    --last;
                }
                startIndex = last;
                if (startIndex > 0) {
                    continue;
                }
                break;
            }
        } else {
            for (int k = 0; k < filterValues.length; ++k) {
                for (int i = 0; i < numerOfRows; ++i) {
                    if (ByteUtil.compare(dimensionColumnPage.getChunkData(i), filterValues[k]) > 0) continue;
                    bitSet.set(i);
                }
            }
        }
        return bitSet;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) throws IOException {
        if (this.isDimensionPresentInCurrentBlock[0]) {
            if (((DimColumnResolvedFilterInfo)this.dimColEvaluatorInfoList.get(0)).getDimension().getDataType() != DataTypes.DATE) {
                super.readColumnChunks(rawBlockletColumnChunks);
            }
            int chunkIndex = this.dimensionChunkIndex[0];
            if (null == rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getDimensionRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readDimensionChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        } else if (this.isMeasurePresentInCurrentBlock[0]) {
            int chunkIndex = ((MeasureColumnResolvedFilterInfo)this.msrColEvalutorInfoList.get(0)).getColumnIndex();
            if (null == rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex]) {
                rawBlockletColumnChunks.getMeasureRawColumnChunks()[chunkIndex] = rawBlockletColumnChunks.getDataBlock().readMeasureChunk(rawBlockletColumnChunks.getFileReader(), chunkIndex);
            }
        }
    }
}

