/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.executer;

import java.util.BitSet;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.util.BitSetGroup;

public class TrueFilterExecutor
implements FilterExecuter {
    @Override
    public BitSetGroup applyFilter(RawBlockletColumnChunks rawBlockletColumnChunks, boolean useBitsetPipeLine) {
        int numberOfPages = rawBlockletColumnChunks.getDataBlock().numberOfPages();
        BitSetGroup group = new BitSetGroup(numberOfPages);
        for (int i = 0; i < numberOfPages; ++i) {
            BitSet set = new BitSet();
            set.flip(0, rawBlockletColumnChunks.getDataBlock().getPageRowCount(i));
            group.setBitSet(set, i);
        }
        return group;
    }

    @Override
    public BitSet prunePages(RawBlockletColumnChunks rawBlockletColumnChunks) {
        int numberOfPages = rawBlockletColumnChunks.getDataBlock().numberOfPages();
        BitSet set = new BitSet(numberOfPages);
        set.set(0, numberOfPages);
        return set;
    }

    @Override
    public boolean applyFilter(RowIntf value, int dimOrdinalMax) {
        return true;
    }

    @Override
    public BitSet isScanRequired(byte[][] blockMaxValue, byte[][] blockMinValue, boolean[] isMinMaxSet) {
        BitSet bitSet = new BitSet(1);
        bitSet.flip(0, 1);
        return bitSet;
    }

    @Override
    public void readColumnChunks(RawBlockletColumnChunks rawBlockletColumnChunks) {
    }
}

