/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver;

import java.util.List;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.conditional.ConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.expression.logical.RangeExpression;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.filter.resolver.metadata.FilterResolverMetadata;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.FilterInfoTypeVisitorFactory;

public class ConditionalFilterResolverImpl
implements FilterResolverIntf {
    private static final long serialVersionUID = 1838955268462201691L;
    protected Expression exp;
    protected boolean isExpressionResolve;
    protected boolean isIncludeFilter;
    private DimColumnResolvedFilterInfo dimColResolvedFilterInfo;
    private MeasureColumnResolvedFilterInfo msrColResolvedFilterInfo;

    public ConditionalFilterResolverImpl(Expression exp, boolean isExpressionResolve, boolean isIncludeFilter, boolean isMeasure) {
        this.exp = exp;
        this.isExpressionResolve = isExpressionResolve;
        this.isIncludeFilter = isIncludeFilter;
        if (!isMeasure) {
            this.dimColResolvedFilterInfo = new DimColumnResolvedFilterInfo();
        } else {
            this.msrColResolvedFilterInfo = new MeasureColumnResolvedFilterInfo();
        }
    }

    @Override
    public void resolve() throws FilterUnsupportedException {
        FilterResolverMetadata metadata = new FilterResolverMetadata();
        if (!this.isExpressionResolve && this.exp instanceof BinaryConditionalExpression) {
            BinaryConditionalExpression binaryConditionalExpression = (BinaryConditionalExpression)this.exp;
            Expression leftExp = binaryConditionalExpression.getLeft();
            Expression rightExp = binaryConditionalExpression.getRight();
            if (leftExp instanceof ColumnExpression) {
                ColumnExpression columnExpression = (ColumnExpression)leftExp;
                metadata.setColumnExpression(columnExpression);
                metadata.setExpression(rightExp);
                metadata.setIncludeFilter(this.isIncludeFilter);
                if (FilterUtil.checkIfExpressionContainsColumn(rightExp)) {
                    this.isExpressionResolve = true;
                } else if (columnExpression.isMeasure()) {
                    this.msrColResolvedFilterInfo.setMeasure(columnExpression.getMeasure());
                    this.msrColResolvedFilterInfo.populateFilterInfoBasedOnColumnType(FilterInfoTypeVisitorFactory.getResolvedFilterInfoVisitor(columnExpression, this.exp), metadata);
                } else {
                    this.dimColResolvedFilterInfo.populateFilterInfoBasedOnColumnType(FilterInfoTypeVisitorFactory.getResolvedFilterInfoVisitor(columnExpression, this.exp), metadata);
                }
            } else if (rightExp instanceof ColumnExpression) {
                ColumnExpression columnExpression = (ColumnExpression)rightExp;
                metadata.setColumnExpression(columnExpression);
                metadata.setExpression(leftExp);
                metadata.setIncludeFilter(this.isIncludeFilter);
                if (columnExpression.getDataType().equals(DataTypes.TIMESTAMP) || columnExpression.getDataType().equals(DataTypes.DATE)) {
                    this.isExpressionResolve = true;
                } else if (FilterUtil.checkIfExpressionContainsColumn(leftExp)) {
                    this.isExpressionResolve = true;
                } else if (columnExpression.isMeasure()) {
                    this.msrColResolvedFilterInfo.populateFilterInfoBasedOnColumnType(FilterInfoTypeVisitorFactory.getResolvedFilterInfoVisitor(columnExpression, this.exp), metadata);
                } else {
                    this.dimColResolvedFilterInfo.populateFilterInfoBasedOnColumnType(FilterInfoTypeVisitorFactory.getResolvedFilterInfoVisitor(columnExpression, this.exp), metadata);
                }
            } else {
                this.isExpressionResolve = true;
            }
        }
        if (this.isExpressionResolve && this.exp instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)((Object)this.exp);
            List<ColumnExpression> columnList = conditionalExpression.getColumnList();
            metadata.setColumnExpression(columnList.get(0));
            metadata.setExpression(this.exp);
            metadata.setIncludeFilter(this.isIncludeFilter);
            if (null != columnList.get(0).getDimension() || this.exp instanceof RangeExpression) {
                this.dimColResolvedFilterInfo.populateFilterInfoBasedOnColumnType(FilterInfoTypeVisitorFactory.getResolvedFilterInfoVisitor(columnList.get(0), this.exp), metadata);
            } else if (columnList.get(0).isMeasure()) {
                this.msrColResolvedFilterInfo.setMeasure(columnList.get(0).getMeasure());
                this.msrColResolvedFilterInfo.populateFilterInfoBasedOnColumnType(FilterInfoTypeVisitorFactory.getResolvedFilterInfoVisitor(columnList.get(0), this.exp), metadata);
                this.msrColResolvedFilterInfo.setCarbonColumn(columnList.get(0).getCarbonColumn());
                this.msrColResolvedFilterInfo.setColumnIndex(columnList.get(0).getCarbonColumn().getOrdinal());
                this.msrColResolvedFilterInfo.setType(columnList.get(0).getCarbonColumn().getDataType());
            }
        }
    }

    @Override
    public FilterResolverIntf getLeft() {
        return null;
    }

    @Override
    public FilterResolverIntf getRight() {
        return null;
    }

    @Override
    public DimColumnResolvedFilterInfo getDimColResolvedFilterInfo() {
        return this.dimColResolvedFilterInfo;
    }

    @Override
    public MeasureColumnResolvedFilterInfo getMsrColResolvedFilterInfo() {
        return this.msrColResolvedFilterInfo;
    }

    @Override
    public FilterExecuterType getFilterExecuterType() {
        switch (this.exp.getFilterExpressionType()) {
            case NOT_EQUALS: 
            case NOT_IN: {
                return FilterExecuterType.EXCLUDE;
            }
            case RANGE: {
                return FilterExecuterType.RANGE;
            }
        }
        return FilterExecuterType.INCLUDE;
    }

    public byte[][] getFilterRangeValues(SegmentProperties segmentProperties) {
        if (null != this.dimColResolvedFilterInfo.getFilterValues() && this.dimColResolvedFilterInfo.getDimension().getDataType() != DataTypes.DATE) {
            List<byte[]> noDictFilterValuesList = this.dimColResolvedFilterInfo.getFilterValues().getNoDictionaryFilterValuesList();
            return (byte[][])noDictFilterValuesList.toArray((T[])new byte[noDictFilterValuesList.size()][]);
        }
        if (null != this.dimColResolvedFilterInfo.getFilterValues() && this.dimColResolvedFilterInfo.getDimension().getDataType() == DataTypes.DATE) {
            return FilterUtil.getKeyArray(this.dimColResolvedFilterInfo.getFilterValues(), this.dimColResolvedFilterInfo.getDimension(), segmentProperties, false, false);
        }
        return null;
    }

    @Override
    public Expression getFilterExpression() {
        return this.exp;
    }
}

