/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.conditional.ConditionalExpression;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;
import org.apache.carbondata.core.scan.filter.resolver.ConditionalFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;

public class RowLevelFilterResolverImpl
extends ConditionalFilterResolverImpl {
    private static final long serialVersionUID = 176122729713729929L;
    private List<DimColumnResolvedFilterInfo> dimColEvaluatorInfoList = new ArrayList<DimColumnResolvedFilterInfo>(16);
    private List<MeasureColumnResolvedFilterInfo> msrColEvalutorInfoList = new ArrayList<MeasureColumnResolvedFilterInfo>(16);
    private AbsoluteTableIdentifier tableIdentifier;

    public RowLevelFilterResolverImpl(Expression exp, boolean isExpressionResolve, boolean isIncludeFilter, AbsoluteTableIdentifier tableIdentifier) {
        super(exp, isExpressionResolve, isIncludeFilter, false);
        this.tableIdentifier = tableIdentifier;
    }

    @Override
    public void resolve() {
        DimColumnResolvedFilterInfo dimColumnEvaluatorInfo = null;
        MeasureColumnResolvedFilterInfo msrColumnEvalutorInfo = null;
        int index = 0;
        if (this.exp instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)((Object)this.exp);
            List<ColumnExpression> columnList = conditionalExpression.getColumnList();
            for (ColumnExpression columnExpression : columnList) {
                if (columnExpression.isDimension()) {
                    dimColumnEvaluatorInfo = new DimColumnResolvedFilterInfo();
                    dimColumnEvaluatorInfo.setColumnIndex(columnExpression.getCarbonColumn().getOrdinal());
                    dimColumnEvaluatorInfo.setRowIndex(index++);
                    dimColumnEvaluatorInfo.setDimension(columnExpression.getDimension());
                    dimColumnEvaluatorInfo.setDimensionExistsInCurrentSilce(false);
                    this.dimColEvaluatorInfoList.add(dimColumnEvaluatorInfo);
                    continue;
                }
                msrColumnEvalutorInfo = new MeasureColumnResolvedFilterInfo();
                msrColumnEvalutorInfo.setCarbonColumn(columnExpression.getCarbonColumn());
                msrColumnEvalutorInfo.setRowIndex(index++);
                msrColumnEvalutorInfo.setColumnIndex(columnExpression.getCarbonColumn().getOrdinal());
                msrColumnEvalutorInfo.setMeasure(columnExpression.getMeasure());
                msrColumnEvalutorInfo.setType(columnExpression.getCarbonColumn().getDataType());
                this.msrColEvalutorInfoList.add(msrColumnEvalutorInfo);
            }
        }
    }

    @Override
    public FilterExecuterType getFilterExecuterType() {
        return FilterExecuterType.ROWLEVEL;
    }

    public Expression getFilterExpresion() {
        return this.exp;
    }

    public List<DimColumnResolvedFilterInfo> getDimColEvaluatorInfoList() {
        return this.dimColEvaluatorInfoList;
    }

    public List<MeasureColumnResolvedFilterInfo> getMsrColEvalutorInfoList() {
        return this.msrColEvalutorInfoList;
    }

    public AbsoluteTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }
}

