/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.conditional.BinaryConditionalExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.expression.logical.BinaryLogicalExpression;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.intf.FilterExecuterType;
import org.apache.carbondata.core.scan.filter.resolver.ConditionalFilterResolverImpl;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.MeasureColumnResolvedFilterInfo;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.DataTypeUtil;

public class RowLevelRangeFilterResolverImpl
extends ConditionalFilterResolverImpl {
    private static final long serialVersionUID = 6629319265336666789L;
    private List<DimColumnResolvedFilterInfo> dimColEvaluatorInfoList = new ArrayList<DimColumnResolvedFilterInfo>(16);
    private List<MeasureColumnResolvedFilterInfo> msrColEvalutorInfoList = new ArrayList<MeasureColumnResolvedFilterInfo>(16);
    private AbsoluteTableIdentifier tableIdentifier;

    public RowLevelRangeFilterResolverImpl(Expression exp, boolean isExpressionResolve, boolean isIncludeFilter, AbsoluteTableIdentifier tableIdentifier) {
        super(exp, isExpressionResolve, isIncludeFilter, false);
        this.tableIdentifier = tableIdentifier;
    }

    @Override
    public byte[][] getFilterRangeValues(SegmentProperties segmentProperties) {
        if (this.dimColEvaluatorInfoList.size() > 0 && null != this.dimColEvaluatorInfoList.get(0).getFilterValues() && this.dimColEvaluatorInfoList.get(0).getDimension().getDataType() != DataTypes.DATE) {
            List<byte[]> noDictFilterValuesList = this.dimColEvaluatorInfoList.get(0).getFilterValues().getNoDictionaryFilterValuesList();
            return (byte[][])noDictFilterValuesList.toArray((T[])new byte[noDictFilterValuesList.size()][]);
        }
        if (this.dimColEvaluatorInfoList.size() > 0 && null != this.dimColEvaluatorInfoList.get(0).getFilterValues() && this.dimColEvaluatorInfoList.get(0).getDimension().getDataType() == DataTypes.DATE) {
            CarbonDimension dimensionFromCurrentBlock = segmentProperties.getDimensionFromCurrentBlock(this.dimColEvaluatorInfoList.get(0).getDimension());
            if (null != dimensionFromCurrentBlock) {
                return FilterUtil.getKeyArray(this.dimColEvaluatorInfoList.get(0).getFilterValues(), dimensionFromCurrentBlock, segmentProperties, false, false);
            }
            return FilterUtil.getKeyArray(this.dimColEvaluatorInfoList.get(0).getFilterValues(), false);
        }
        if (this.dimColEvaluatorInfoList.size() > 0 && null != this.dimColEvaluatorInfoList.get(0).getFilterValues() && this.dimColEvaluatorInfoList.get(0).getDimension().getDataType() == DataTypes.DATE) {
            CarbonDimension dimensionFromCurrentBlock = segmentProperties.getDimensionFromCurrentBlock(this.dimColEvaluatorInfoList.get(0).getDimension());
            if (null != dimensionFromCurrentBlock) {
                return FilterUtil.getKeyArray(this.dimColEvaluatorInfoList.get(0).getFilterValues(), dimensionFromCurrentBlock, segmentProperties, false, true);
            }
            return FilterUtil.getKeyArray(this.dimColEvaluatorInfoList.get(0).getFilterValues(), false);
        }
        return null;
    }

    public Object[] getMeasureFilterRangeValues() {
        if (this.msrColEvalutorInfoList.size() > 0 && null != this.msrColEvalutorInfoList.get(0).getFilterValues()) {
            List<Object> measureFilterValuesList = this.msrColEvalutorInfoList.get(0).getFilterValues().getMeasuresFilterValuesList();
            return measureFilterValuesList.toArray(new Object[measureFilterValuesList.size()]);
        }
        return null;
    }

    private List<byte[]> getNoDictionaryRangeValues() {
        List<Object> listOfExpressionResults = new ArrayList(20);
        if (this.getFilterExpression() instanceof BinaryConditionalExpression) {
            listOfExpressionResults = ((BinaryConditionalExpression)this.getFilterExpression()).getLiterals();
        }
        ArrayList<byte[]> filterValuesList = new ArrayList<byte[]>(20);
        boolean invalidRowsPresent = false;
        String timeFormat = CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        for (ExpressionResult expressionResult : listOfExpressionResults) {
            try {
                if (expressionResult.getString() == null) {
                    if (expressionResult.getDataType() == DataTypes.STRING) {
                        filterValuesList.add(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY);
                        continue;
                    }
                    filterValuesList.add(CarbonCommonConstants.EMPTY_BYTE_ARRAY);
                    continue;
                }
                filterValuesList.add(DataTypeUtil.getBytesBasedOnDataTypeForNoDictionaryColumn(expressionResult.getString(), expressionResult.getDataType(), timeFormat));
            }
            catch (FilterIllegalMemberException e) {
                FilterUtil.logError(e, invalidRowsPresent);
            }
        }
        Comparator<byte[]> filterNoDictValueComaparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] filterMember1, byte[] filterMember2) {
                return ByteUtil.UnsafeComparer.INSTANCE.compareTo(filterMember1, filterMember2);
            }
        };
        Collections.sort(filterValuesList, filterNoDictValueComaparator);
        return filterValuesList;
    }

    private List<Object> getMeasureRangeValues(CarbonMeasure carbonMeasure) {
        List<Object> listOfExpressionResults = new ArrayList(20);
        if (this.getFilterExpression() instanceof BinaryConditionalExpression) {
            listOfExpressionResults = ((BinaryConditionalExpression)this.getFilterExpression()).getLiterals();
        }
        ArrayList<Object> filterValuesList = new ArrayList<Object>(20);
        boolean invalidRowsPresent = false;
        for (ExpressionResult expressionResult : listOfExpressionResults) {
            try {
                if (expressionResult.getString() == null) {
                    filterValuesList.add(null);
                    continue;
                }
                filterValuesList.add(DataTypeUtil.getMeasureValueBasedOnDataType(expressionResult.getString(), expressionResult.getDataType(), carbonMeasure.getScale(), carbonMeasure.getPrecision()));
            }
            catch (FilterIllegalMemberException e) {
                FilterUtil.logError(e, invalidRowsPresent);
            }
        }
        Collections.sort(filterValuesList, org.apache.carbondata.core.util.comparator.Comparator.getComparatorByDataTypeForMeasure(carbonMeasure.getDataType()));
        return filterValuesList;
    }

    @Override
    public void resolve() throws FilterUnsupportedException {
        DimColumnResolvedFilterInfo dimColumnEvaluatorInfo = null;
        MeasureColumnResolvedFilterInfo msrColumnEvalutorInfo = null;
        int index = 0;
        if (this.exp instanceof BinaryLogicalExpression) {
            BinaryLogicalExpression conditionalExpression = (BinaryLogicalExpression)this.exp;
            List<ColumnExpression> columnList = conditionalExpression.getColumnList();
            for (ColumnExpression columnExpression : columnList) {
                ColumnFilterInfo filterInfo;
                if (columnExpression.isDimension()) {
                    dimColumnEvaluatorInfo = new DimColumnResolvedFilterInfo();
                    filterInfo = new ColumnFilterInfo();
                    dimColumnEvaluatorInfo.setColumnIndex(columnExpression.getCarbonColumn().getOrdinal());
                    dimColumnEvaluatorInfo.setRowIndex(index++);
                    dimColumnEvaluatorInfo.setDimension(columnExpression.getDimension());
                    dimColumnEvaluatorInfo.setDimensionExistsInCurrentSilce(false);
                    if (columnExpression.getDimension().getDataType() == DataTypes.DATE) {
                        if (!this.isIncludeFilter) {
                            filterInfo.setExcludeFilterList(this.getDirectSurrogateValues(columnExpression));
                        } else {
                            filterInfo.setFilterList(this.getDirectSurrogateValues(columnExpression));
                        }
                    } else {
                        filterInfo.setFilterListForNoDictionaryCols(this.getNoDictionaryRangeValues());
                    }
                    filterInfo.setIncludeFilter(this.isIncludeFilter);
                    dimColumnEvaluatorInfo.setFilterValues(filterInfo);
                    dimColumnEvaluatorInfo.addDimensionResolvedFilterInstance(columnExpression.getDimension(), filterInfo);
                    this.dimColEvaluatorInfoList.add(dimColumnEvaluatorInfo);
                    continue;
                }
                msrColumnEvalutorInfo = new MeasureColumnResolvedFilterInfo();
                filterInfo = new ColumnFilterInfo();
                msrColumnEvalutorInfo.setMeasure(columnExpression.getMeasure());
                msrColumnEvalutorInfo.setRowIndex(index++);
                msrColumnEvalutorInfo.setCarbonColumn(columnExpression.getCarbonColumn());
                msrColumnEvalutorInfo.setColumnIndex(columnExpression.getCarbonColumn().getOrdinal());
                msrColumnEvalutorInfo.setType(columnExpression.getCarbonColumn().getDataType());
                msrColumnEvalutorInfo.setMeasureExistsInCurrentSilce(false);
                filterInfo.setMeasuresFilterValuesList(this.getMeasureRangeValues(columnExpression.getMeasure()));
                filterInfo.setIncludeFilter(this.isIncludeFilter);
                msrColumnEvalutorInfo.setFilterValues(filterInfo);
                msrColumnEvalutorInfo.addMeasureResolvedFilterInstance(columnExpression.getMeasure(), filterInfo);
                this.msrColEvalutorInfoList.add(msrColumnEvalutorInfo);
            }
        }
    }

    private List<Integer> getDirectSurrogateValues(ColumnExpression columnExpression) throws FilterUnsupportedException {
        List<Object> listOfExpressionResults = new ArrayList(20);
        DirectDictionaryGenerator directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(columnExpression.getDimension().getDataType());
        if (this.getFilterExpression() instanceof BinaryConditionalExpression) {
            listOfExpressionResults = ((BinaryConditionalExpression)this.getFilterExpression()).getLiterals();
        }
        ArrayList<Integer> filterValuesList = new ArrayList<Integer>(20);
        try {
            for (ExpressionResult expressionResult : listOfExpressionResults) {
                filterValuesList.add(directDictionaryGenerator.generateDirectSurrogateKey(expressionResult.getString(), "yyyy-MM-dd HH:mm:ss"));
            }
        }
        catch (FilterIllegalMemberException e) {
            throw new FilterUnsupportedException(e);
        }
        return filterValuesList;
    }

    private List<Integer> getSurrogateValues() throws FilterUnsupportedException {
        List<Object> listOfExpressionResults = new ArrayList(20);
        if (this.getFilterExpression() instanceof BinaryConditionalExpression) {
            listOfExpressionResults = ((BinaryConditionalExpression)this.getFilterExpression()).getLiterals();
        }
        ArrayList<Integer> filterValuesList = new ArrayList<Integer>(20);
        try {
            for (ExpressionResult expressionResult : listOfExpressionResults) {
                filterValuesList.add(expressionResult.getInt());
            }
        }
        catch (FilterIllegalMemberException e) {
            throw new FilterUnsupportedException(e);
        }
        return filterValuesList;
    }

    public List<DimColumnResolvedFilterInfo> getDimColEvaluatorInfoList() {
        return this.dimColEvaluatorInfoList;
    }

    public List<MeasureColumnResolvedFilterInfo> getMsrColEvalutorInfoList() {
        return this.msrColEvalutorInfoList;
    }

    public AbsoluteTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public Expression getFilterExpression() {
        return this.exp;
    }

    @Override
    public FilterExecuterType getFilterExecuterType() {
        switch (this.exp.getFilterExpressionType()) {
            case GREATERTHAN: {
                return FilterExecuterType.ROWLEVEL_GREATERTHAN;
            }
            case GREATERTHAN_EQUALTO: {
                return FilterExecuterType.ROWLEVEL_GREATERTHAN_EQUALTO;
            }
            case LESSTHAN: {
                return FilterExecuterType.ROWLEVEL_LESSTHAN;
            }
            case LESSTHAN_EQUALTO: {
                return FilterExecuterType.ROWLEVEL_LESSTHAN_EQUALTO;
            }
        }
        return FilterExecuterType.ROWLEVEL;
    }
}

