/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver.resolverinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.metadata.FilterResolverMetadata;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.ColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.ResolvedFilterInfoVisitorIntf;

public class DimColumnResolvedFilterInfo
extends ColumnResolvedFilterInfo
implements Serializable {
    private static final long serialVersionUID = 3428115141211084114L;
    private int rowIndex = -1;
    private boolean isDimensionExistsInCurrentSilce = true;
    private CarbonDimension dimension;
    private ColumnFilterInfo resolvedFilterValueObj;
    private Map<CarbonDimension, List<ColumnFilterInfo>> dimensionResolvedFilter = new HashMap<CarbonDimension, List<ColumnFilterInfo>>(20);

    public void addDimensionResolvedFilterInstance(CarbonDimension dimension, ColumnFilterInfo filterResolvedObj) {
        List<ColumnFilterInfo> currentVals = this.dimensionResolvedFilter.get(dimension);
        if (null == currentVals) {
            currentVals = new ArrayList<ColumnFilterInfo>(20);
            currentVals.add(filterResolvedObj);
            this.dimensionResolvedFilter.put(dimension, currentVals);
        } else {
            currentVals.add(filterResolvedObj);
        }
    }

    public Map<CarbonDimension, List<ColumnFilterInfo>> getDimensionResolvedFilterInstance() {
        return this.dimensionResolvedFilter;
    }

    @Override
    public CarbonDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(CarbonDimension dimension) {
        this.dimension = dimension;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public ColumnFilterInfo getFilterValues() {
        return this.resolvedFilterValueObj;
    }

    public void setFilterValues(ColumnFilterInfo resolvedFilterValueObj) {
        this.resolvedFilterValueObj = resolvedFilterValueObj;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public boolean isDimensionExistsInCurrentSilce() {
        return this.isDimensionExistsInCurrentSilce;
    }

    public void setDimensionExistsInCurrentSilce(boolean isDimensionExistsInCurrentSilce) {
        this.isDimensionExistsInCurrentSilce = isDimensionExistsInCurrentSilce;
    }

    public void populateFilterInfoBasedOnColumnType(ResolvedFilterInfoVisitorIntf visitor, FilterResolverMetadata metadata) throws FilterUnsupportedException {
        if (null != visitor) {
            visitor.populateFilterResolvedInfo(this, metadata);
            this.addDimensionResolvedFilterInstance(metadata.getColumnExpression().getDimension(), this.getFilterValues());
            this.setDimension(metadata.getColumnExpression().getDimension());
            this.setColumnIndex(metadata.getColumnExpression().getDimension().getOrdinal());
        }
    }

    public DimColumnResolvedFilterInfo getCopyObject() {
        DimColumnResolvedFilterInfo dimColumnResolvedFilterInfo = new DimColumnResolvedFilterInfo();
        dimColumnResolvedFilterInfo.resolvedFilterValueObj = this.resolvedFilterValueObj;
        dimColumnResolvedFilterInfo.rowIndex = this.rowIndex;
        dimColumnResolvedFilterInfo.dimensionResolvedFilter = this.dimensionResolvedFilter;
        dimColumnResolvedFilterInfo.isDimensionExistsInCurrentSilce = this.isDimensionExistsInCurrentSilce;
        dimColumnResolvedFilterInfo.columnIndexInMinMaxByteArray = this.columnIndexInMinMaxByteArray;
        return dimColumnResolvedFilterInfo;
    }

    @Override
    public CarbonMeasure getMeasure() {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

