/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver.resolverinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.metadata.FilterResolverMetadata;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.ColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.ResolvedFilterInfoVisitorIntf;

public class MeasureColumnResolvedFilterInfo
extends ColumnResolvedFilterInfo
implements Serializable {
    private static final long serialVersionUID = 4222568289115151561L;
    private int rowIndex = -1;
    private boolean isMeasureExistsInCurrentSilce = true;
    private CarbonColumn carbonColumn;
    private CarbonMeasure carbonMeasure;
    private ColumnFilterInfo resolvedFilterValueObj;
    private Map<CarbonMeasure, List<ColumnFilterInfo>> measureResolvedFilter = new HashMap<CarbonMeasure, List<ColumnFilterInfo>>(20);
    private DataType type;

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void addMeasureResolvedFilterInstance(CarbonMeasure measures, ColumnFilterInfo filterResolvedObj) {
        List<ColumnFilterInfo> currentVals = this.measureResolvedFilter.get(measures);
        if (null == currentVals) {
            currentVals = new ArrayList<ColumnFilterInfo>(20);
            currentVals.add(filterResolvedObj);
            this.measureResolvedFilter.put(measures, currentVals);
        } else {
            currentVals.add(filterResolvedObj);
        }
    }

    public ColumnFilterInfo getFilterValues() {
        return this.resolvedFilterValueObj;
    }

    public void setFilterValues(ColumnFilterInfo resolvedFilterValueObj) {
        this.resolvedFilterValueObj = resolvedFilterValueObj;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType dataType) {
        this.type = DataTypes.valueOf(dataType.getId());
    }

    public CarbonColumn getCarbonColumn() {
        return this.carbonColumn;
    }

    public void setCarbonColumn(CarbonColumn carbonColumn) {
        this.carbonColumn = carbonColumn;
    }

    @Override
    public CarbonMeasure getMeasure() {
        return this.carbonMeasure;
    }

    @Override
    public CarbonDimension getDimension() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void setMeasureExistsInCurrentSilce(boolean measureExistsInCurrentSilce) {
        this.isMeasureExistsInCurrentSilce = measureExistsInCurrentSilce;
    }

    public void setMeasure(CarbonMeasure carbonMeasure) {
        this.carbonMeasure = carbonMeasure;
    }

    public void populateFilterInfoBasedOnColumnType(ResolvedFilterInfoVisitorIntf visitor, FilterResolverMetadata metadata) throws FilterUnsupportedException {
        if (null != visitor) {
            visitor.populateFilterResolvedInfo(this, metadata);
            this.addMeasureResolvedFilterInstance(metadata.getColumnExpression().getMeasure(), this.getFilterValues());
            this.setMeasure(metadata.getColumnExpression().getMeasure());
            this.setColumnIndex(metadata.getColumnExpression().getMeasure().getOrdinal());
        }
    }

    public MeasureColumnResolvedFilterInfo getCopyObject() {
        MeasureColumnResolvedFilterInfo msrColumnResolvedFilterInfo = new MeasureColumnResolvedFilterInfo();
        msrColumnResolvedFilterInfo.resolvedFilterValueObj = this.resolvedFilterValueObj;
        msrColumnResolvedFilterInfo.rowIndex = this.rowIndex;
        msrColumnResolvedFilterInfo.measureResolvedFilter = this.measureResolvedFilter;
        msrColumnResolvedFilterInfo.setMeasureExistsInCurrentSilce(this.isMeasureExistsInCurrentSilce);
        msrColumnResolvedFilterInfo.columnIndexInMinMaxByteArray = this.columnIndexInMinMaxByteArray;
        return msrColumnResolvedFilterInfo;
    }
}

