/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.metadata.FilterResolverMetadata;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.ColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.ResolvedFilterInfoVisitorIntf;
import org.apache.carbondata.core.util.CarbonProperties;

public class CustomTypeDictionaryVisitor
implements ResolvedFilterInfoVisitorIntf {
    @Override
    public void populateFilterResolvedInfo(ColumnResolvedFilterInfo visitableObj, FilterResolverMetadata metadata) throws FilterUnsupportedException {
        ColumnFilterInfo resolvedFilterObject = null;
        if (visitableObj instanceof DimColumnResolvedFilterInfo) {
            List<String> evaluateResultListFinal;
            DimColumnResolvedFilterInfo resolveDimension = (DimColumnResolvedFilterInfo)visitableObj;
            try {
                evaluateResultListFinal = metadata.getExpression().evaluate(null).getListAsString();
            }
            catch (FilterIllegalMemberException e) {
                throw new FilterUnsupportedException(e);
            }
            resolvedFilterObject = this.getDirectDictionaryValKeyMemberForFilter(metadata.getColumnExpression(), evaluateResultListFinal, metadata.isIncludeFilter(), metadata.getColumnExpression().getDimension().getDataType());
            if (!metadata.isIncludeFilter() && null != resolvedFilterObject && !resolvedFilterObject.getExcludeFilterList().contains(1)) {
                resolvedFilterObject.getExcludeFilterList().add(1);
                Collections.sort(resolvedFilterObject.getExcludeFilterList());
            }
            resolveDimension.setFilterValues(resolvedFilterObject);
        }
    }

    protected ColumnFilterInfo getDirectDictionaryValKeyMemberForFilter(ColumnExpression columnExpression, List<String> evaluateResultListFinal, boolean isIncludeFilter, DataType dataType) {
        ArrayList<Integer> surrogates = new ArrayList<Integer>(20);
        DirectDictionaryGenerator directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(columnExpression.getDimension().getDataType());
        this.getSurrogateValuesForDictionary(evaluateResultListFinal, surrogates, directDictionaryGenerator, dataType);
        Collections.sort(surrogates);
        ColumnFilterInfo columnFilterInfo = null;
        if (surrogates.size() > 0) {
            columnFilterInfo = new ColumnFilterInfo();
            columnFilterInfo.setIncludeFilter(isIncludeFilter);
            if (!isIncludeFilter) {
                columnFilterInfo.setExcludeFilterList(surrogates);
            } else {
                columnFilterInfo.setFilterList(surrogates);
            }
        }
        return columnFilterInfo;
    }

    private void getSurrogateValuesForDictionary(List<String> evaluateResultListFinal, List<Integer> surrogates, DirectDictionaryGenerator directDictionaryGenerator, DataType dataType) {
        String timeFormat = null;
        timeFormat = dataType == DataTypes.DATE ? CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd") : CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        for (String filterMember : evaluateResultListFinal) {
            surrogates.add(directDictionaryGenerator.generateDirectSurrogateKey(filterMember, timeFormat));
        }
    }
}

