/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor;

import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.logical.RangeExpression;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.CustomTypeDictionaryVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.ImplicitColumnVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.MeasureColumnVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.NoDictionaryTypeVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.RangeDirectDictionaryVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.RangeNoDictionaryTypeVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.ResolvedFilterInfoVisitorIntf;

public class FilterInfoTypeVisitorFactory {
    public static ResolvedFilterInfoVisitorIntf getResolvedFilterInfoVisitor(ColumnExpression columnExpression, Expression exp) {
        if (exp instanceof RangeExpression) {
            if (columnExpression.getDimension().getDataType() == DataTypes.DATE) {
                return new RangeDirectDictionaryVisitor();
            }
            if (columnExpression.getDimension().hasEncoding(Encoding.IMPLICIT)) {
                return new ImplicitColumnVisitor();
            }
            if (columnExpression.getDimension().getDataType() != DataTypes.DATE) {
                return new RangeNoDictionaryTypeVisitor();
            }
        } else if (null != columnExpression.getDimension()) {
            if (columnExpression.getDimension().getDataType() == DataTypes.DATE) {
                return new CustomTypeDictionaryVisitor();
            }
            if (columnExpression.getDimension().hasEncoding(Encoding.IMPLICIT)) {
                return new ImplicitColumnVisitor();
            }
            if (columnExpression.getDimension().getDataType() != DataTypes.DATE) {
                return new NoDictionaryTypeVisitor();
            }
        } else if (columnExpression.getMeasure().isMeasure().booleanValue()) {
            return new MeasureColumnVisitor();
        }
        return null;
    }
}

