/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.exception.FilterIllegalMemberException;
import org.apache.carbondata.core.scan.expression.exception.FilterUnsupportedException;
import org.apache.carbondata.core.scan.expression.logical.RangeExpression;
import org.apache.carbondata.core.scan.filter.ColumnFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.metadata.FilterResolverMetadata;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.ColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.DimColumnResolvedFilterInfo;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.CustomTypeDictionaryVisitor;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.visitor.ResolvedFilterInfoVisitorIntf;

public class RangeDirectDictionaryVisitor
extends CustomTypeDictionaryVisitor
implements ResolvedFilterInfoVisitorIntf {
    @Override
    public void populateFilterResolvedInfo(ColumnResolvedFilterInfo visitableObj, FilterResolverMetadata metadata) throws FilterUnsupportedException {
        if (visitableObj instanceof DimColumnResolvedFilterInfo) {
            DimColumnResolvedFilterInfo resolveDimension = (DimColumnResolvedFilterInfo)visitableObj;
            ColumnFilterInfo resolvedFilterObject = null;
            List<ExpressionResult> listOfExpressionResults = null;
            ArrayList<String> evaluateResultListFinal = new ArrayList<String>();
            try {
                listOfExpressionResults = ((RangeExpression)metadata.getExpression()).getLiterals();
                for (ExpressionResult result : listOfExpressionResults) {
                    if (result.getString() == null) {
                        evaluateResultListFinal.add("@NU#LL$!");
                        continue;
                    }
                    evaluateResultListFinal.add(result.getString());
                }
            }
            catch (FilterIllegalMemberException e) {
                throw new FilterUnsupportedException(e);
            }
            resolvedFilterObject = this.getDirectDictionaryValKeyMemberForFilter(metadata.getColumnExpression(), evaluateResultListFinal, metadata.isIncludeFilter(), metadata.getColumnExpression().getDimension().getDataType());
            if (!metadata.isIncludeFilter() && null != resolvedFilterObject && !resolvedFilterObject.getExcludeFilterList().contains(1)) {
                resolvedFilterObject.getExcludeFilterList().add(1);
                Collections.sort(resolvedFilterObject.getExcludeFilterList());
            }
            resolveDimension.setFilterValues(resolvedFilterObject);
        }
    }
}

