/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.UnknownExpression;
import org.apache.carbondata.core.scan.expression.conditional.ConditionalExpression;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryProjection;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverter;

public class QueryModel {
    private QueryProjection projection;
    private String queryId;
    private IndexFilter indexFilter;
    private List<TableBlockInfo> tableBlockInfos = new ArrayList<TableBlockInfo>();
    private boolean forcedDetailRawQuery;
    private CarbonTable table;
    private QueryStatisticsRecorder statisticsRecorder;
    private boolean vectorReader;
    private DataTypeConverter converter;
    private boolean[] isFilterDimensions;
    private boolean[] isFilterMeasures;
    private boolean readPageByPage;
    private boolean requiredRowId;
    private boolean isFG;
    private boolean freeUnsafeMemory = true;
    private boolean preFetchData;
    private boolean isDirectVectorFill;
    private boolean readOnlyDelta;

    private QueryModel(CarbonTable carbonTable) {
        this.table = carbonTable;
        this.queryId = String.valueOf(System.nanoTime());
        this.preFetchData = CarbonProperties.getQueryPrefetchEnable();
    }

    public static QueryModel newInstance(CarbonTable carbonTable) {
        return new QueryModel(carbonTable);
    }

    public static void processFilterExpression(FilterProcessVO processVO, Expression filterExpression, boolean[] isFilterDimensions, boolean[] isFilterMeasures, CarbonTable carbonTable) {
        if (null != filterExpression) {
            if (null != filterExpression.getChildren() && filterExpression.getChildren().size() == 0 && filterExpression instanceof ConditionalExpression) {
                List<ColumnExpression> listOfCol = ((ConditionalExpression)((Object)filterExpression)).getColumnList();
                for (ColumnExpression expression : listOfCol) {
                    QueryModel.setDimAndMsrColumnNode(processVO, expression, isFilterDimensions, isFilterMeasures, carbonTable);
                }
            }
            for (Expression expression : filterExpression.getChildren()) {
                if (expression instanceof ColumnExpression) {
                    QueryModel.setDimAndMsrColumnNode(processVO, (ColumnExpression)expression, isFilterDimensions, isFilterMeasures, carbonTable);
                    continue;
                }
                if (expression instanceof UnknownExpression) {
                    UnknownExpression exp = (UnknownExpression)expression;
                    List<ColumnExpression> listOfColExpression = exp.getAllColumnList();
                    for (ColumnExpression col : listOfColExpression) {
                        QueryModel.setDimAndMsrColumnNode(processVO, col, isFilterDimensions, isFilterMeasures, carbonTable);
                    }
                    continue;
                }
                QueryModel.processFilterExpression(processVO, expression, isFilterDimensions, isFilterMeasures, carbonTable);
            }
        }
    }

    private static CarbonMeasure getCarbonMetadataMeasure(String name, List<CarbonMeasure> measures) {
        for (CarbonMeasure measure : measures) {
            if (!measure.getColName().equalsIgnoreCase(name)) continue;
            return measure;
        }
        return null;
    }

    private static void setDimAndMsrColumnNode(FilterProcessVO processVO, ColumnExpression col, boolean[] isFilterDimensions, boolean[] isFilterMeasures, CarbonTable table) {
        String columnName = col.getColumnName();
        col.reset();
        CarbonDimension dim = CarbonUtil.findDimension(processVO.getCarbonDimensions(), columnName);
        CarbonMeasure msr = QueryModel.getCarbonMetadataMeasure(columnName, processVO.getCarbonMeasures());
        if (null != dim) {
            col.setCarbonColumn(dim);
            col.setDimension(dim);
            col.setDimension(true);
            if (null != isFilterDimensions) {
                isFilterDimensions[dim.getOrdinal()] = true;
            }
        } else if (msr != null) {
            col.setCarbonColumn(msr);
            col.setMeasure(msr);
            col.setMeasure(true);
            if (null != isFilterMeasures) {
                isFilterMeasures[msr.getOrdinal()] = true;
            }
        } else if (null != CarbonUtil.findDimension(processVO.getImplicitDimensions(), columnName)) {
            dim = CarbonUtil.findDimension(processVO.getImplicitDimensions(), columnName);
            col.setCarbonColumn(dim);
            col.setDimension(dim);
            col.setDimension(true);
        } else {
            CarbonDimension dimension = table.getDimensionByName(col.getColumnName());
            CarbonMeasure measure = table.getMeasureByName(col.getColumnName());
            col.setDimension(dimension);
            col.setMeasure(measure);
            col.setCarbonColumn(dimension == null ? measure : dimension);
            col.setDimension(null != dimension);
            col.setMeasure(null != measure);
        }
    }

    public CarbonColumn[] getProjectionColumns() {
        CarbonColumn[] carbonColumns = new CarbonColumn[this.getProjectionDimensions().size() + this.getProjectionMeasures().size()];
        for (ProjectionDimension dimension : this.getProjectionDimensions()) {
            carbonColumns[dimension.getOrdinal()] = dimension.getDimension();
        }
        for (ProjectionMeasure msr : this.getProjectionMeasures()) {
            carbonColumns[msr.getOrdinal()] = msr.getMeasure();
        }
        return carbonColumns;
    }

    public void setProjection(QueryProjection projection) {
        this.projection = projection;
    }

    public List<ProjectionDimension> getProjectionDimensions() {
        return this.projection.getDimensions();
    }

    public List<ProjectionMeasure> getProjectionMeasures() {
        return this.projection.getMeasures();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public List<TableBlockInfo> getTableBlockInfos() {
        return this.tableBlockInfos;
    }

    public void setTableBlockInfos(List<TableBlockInfo> tableBlockInfos) {
        this.tableBlockInfos = tableBlockInfos;
    }

    public IndexFilter getIndexFilter() {
        return this.indexFilter;
    }

    public void setIndexFilter(IndexFilter indexFilter) {
        this.indexFilter = indexFilter;
    }

    public AbsoluteTableIdentifier getAbsoluteTableIdentifier() {
        return this.table.getAbsoluteTableIdentifier();
    }

    public CarbonTable getTable() {
        return this.table;
    }

    public boolean isForcedDetailRawQuery() {
        return this.forcedDetailRawQuery;
    }

    public void setForcedDetailRawQuery(boolean forcedDetailRawQuery) {
        this.forcedDetailRawQuery = forcedDetailRawQuery;
    }

    public QueryStatisticsRecorder getStatisticsRecorder() {
        return this.statisticsRecorder;
    }

    public void setStatisticsRecorder(QueryStatisticsRecorder statisticsRecorder) {
        this.statisticsRecorder = statisticsRecorder;
    }

    public boolean isVectorReader() {
        return this.vectorReader;
    }

    public void setVectorReader(boolean vectorReader) {
        this.vectorReader = vectorReader;
    }

    public DataTypeConverter getConverter() {
        return this.converter;
    }

    public void setConverter(DataTypeConverter converter) {
        this.converter = converter;
    }

    public boolean[] getIsFilterDimensions() {
        return this.isFilterDimensions;
    }

    public void setIsFilterDimensions(boolean[] isFilterDimensions) {
        this.isFilterDimensions = isFilterDimensions;
    }

    public boolean[] getIsFilterMeasures() {
        return this.isFilterMeasures;
    }

    public void setIsFilterMeasures(boolean[] isFilterMeasures) {
        this.isFilterMeasures = isFilterMeasures;
    }

    public boolean isReadPageByPage() {
        return this.readPageByPage;
    }

    public void setReadPageByPage(boolean readPageByPage) {
        this.readPageByPage = readPageByPage;
    }

    public boolean isRequiredRowId() {
        return this.requiredRowId;
    }

    public void setRequiredRowId(boolean requiredRowId) {
        this.requiredRowId = requiredRowId;
    }

    public boolean isFG() {
        return this.isFG;
    }

    public void setFG(boolean FG) {
        this.isFG = FG;
    }

    public boolean isPreFetchData() {
        return this.preFetchData;
    }

    public void setPreFetchData(boolean preFetchData) {
        this.preFetchData = preFetchData;
    }

    public boolean isDirectVectorFill() {
        return this.isDirectVectorFill;
    }

    public void setDirectVectorFill(boolean directVectorFill) {
        this.isDirectVectorFill = directVectorFill;
    }

    public boolean isReadOnlyDelta() {
        return this.readOnlyDelta;
    }

    public void setReadOnlyDelta(boolean readOnlyDelta) {
        this.readOnlyDelta = readOnlyDelta;
    }

    public String toString() {
        return String.format("scan on table %s.%s, %d projection columns with filter (%s)", this.table.getDatabaseName(), this.table.getTableName(), this.projection.getDimensions().size() + this.projection.getMeasures().size(), this.indexFilter.getExpression().toString());
    }

    public boolean isFreeUnsafeMemory() {
        return this.freeUnsafeMemory;
    }

    public void setFreeUnsafeMemory(boolean freeUnsafeMemory) {
        this.freeUnsafeMemory = freeUnsafeMemory;
    }

    public static class FilterProcessVO {
        private List<CarbonDimension> carbonDimensions;
        private List<CarbonMeasure> carbonMeasures;
        private List<CarbonDimension> implicitDimensions;

        public FilterProcessVO(List<CarbonDimension> carbonDimensions, List<CarbonMeasure> carbonMeasures, List<CarbonDimension> implicitDimensions) {
            this.carbonDimensions = carbonDimensions;
            this.carbonMeasures = carbonMeasures;
            this.implicitDimensions = implicitDimensions;
        }

        public List<CarbonDimension> getCarbonDimensions() {
            return this.carbonDimensions;
        }

        public List<CarbonMeasure> getCarbonMeasures() {
            return this.carbonMeasures;
        }

        public List<CarbonDimension> getImplicitDimensions() {
            return this.implicitDimensions;
        }
    }
}

