/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.model.QueryProjection;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.log4j.Logger;

public class QueryModelBuilder {
    private CarbonTable table;
    private QueryProjection projection;
    private IndexFilter indexFilter;
    private DataTypeConverter dataTypeConverter;
    private boolean forcedDetailRawQuery;
    private boolean readPageByPage;
    private boolean convertToRangeFilter = true;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)QueryModelBuilder.class.getName());

    public QueryModelBuilder(CarbonTable table) {
        this.table = table;
    }

    public QueryModelBuilder projectColumns(String[] projectionColumns) {
        Objects.requireNonNull(projectionColumns);
        String factTableName = this.table.getTableName();
        QueryProjection projection = new QueryProjection();
        int i = 0;
        for (String projectionColumnName : projectionColumns) {
            CarbonDimension dimension = this.table.getDimensionByName(projectionColumnName);
            if (dimension != null) {
                CarbonDimension complexParentDimension = dimension.getComplexParentDimension();
                if (null != complexParentDimension && dimension.getDataType() == DataTypes.DATE) {
                    if (this.isAlreadyExists(complexParentDimension, projection.getDimensions())) continue;
                    projection.addDimension(complexParentDimension, i);
                    ++i;
                    continue;
                }
                projection.addDimension(dimension, i);
                ++i;
                continue;
            }
            CarbonMeasure measure = this.table.getMeasureByName(projectionColumnName);
            if (measure == null) {
                throw new RuntimeException(projectionColumnName + " column not found in the table " + factTableName);
            }
            projection.addMeasure(measure, i);
            ++i;
        }
        projection = this.optimizeProjectionForComplexColumns(projection, projectionColumns, factTableName);
        ArrayList<String> projectionDimensionAndMeasures = new ArrayList<String>();
        this.projection = projection;
        for (ProjectionDimension projectionDimension : projection.getDimensions()) {
            projectionDimensionAndMeasures.add(projectionDimension.getColumnName());
        }
        for (ProjectionMeasure projectionMeasure : projection.getMeasures()) {
            projectionDimensionAndMeasures.add(projectionMeasure.getColumnName());
        }
        LOGGER.info((Object)("Projection Columns: " + projectionDimensionAndMeasures));
        return this;
    }

    private boolean isAlreadyExists(CarbonDimension dimension, List<ProjectionDimension> projectionDimensions) {
        boolean exists = false;
        for (ProjectionDimension projectionDimension : projectionDimensions) {
            if (!dimension.getColName().equals(projectionDimension.getColumnName())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private QueryProjection optimizeProjectionForComplexColumns(QueryProjection projection, String[] projectionColumns, String factTableName) {
        HashMap complexColumnMap = new HashMap();
        List<ProjectionDimension> carbonDimensions = projection.getDimensions();
        ArrayList<CarbonDimension> projectionDimenesionToBeMerged = new ArrayList<CarbonDimension>();
        for (ProjectionDimension projectionDimension : carbonDimensions) {
            CarbonDimension complexParentDimension = projectionDimension.getDimension().getComplexParentDimension();
            if (null == complexParentDimension || !this.isAlreadyExists(complexParentDimension, carbonDimensions)) continue;
            projectionDimenesionToBeMerged.add(projectionDimension.getDimension());
        }
        if (projectionDimenesionToBeMerged.size() != 0) {
            projection = this.removeMergedDimensions(projectionDimenesionToBeMerged, projectionColumns, factTableName);
            carbonDimensions = projection.getDimensions();
        }
        for (ProjectionDimension projectionDimension : carbonDimensions) {
            List<Integer> childColumns;
            if (null == projectionDimension.getDimension().getComplexParentDimension()) continue;
            if (complexColumnMap.get(projectionDimension.getDimension().getComplexParentDimension().getOrdinal()) != null) {
                childColumns = (List)complexColumnMap.get(projectionDimension.getDimension().getComplexParentDimension().getOrdinal());
                childColumns.add(projectionDimension.getDimension().getOrdinal());
                complexColumnMap.put(projectionDimension.getDimension().getComplexParentDimension().getOrdinal(), childColumns);
                continue;
            }
            childColumns = new ArrayList<Integer>();
            childColumns.add(projectionDimension.getDimension().getOrdinal());
            complexColumnMap.put(projectionDimension.getDimension().getComplexParentDimension().getOrdinal(), childColumns);
        }
        for (Map.Entry entry : complexColumnMap.entrySet()) {
            List childOrdinals = (List)entry.getValue();
            if (childOrdinals.size() <= 1) continue;
            Collections.sort(childOrdinals);
            List<CarbonDimension> mergedDimensions = this.mergeChildColumns(childOrdinals);
            if (mergedDimensions.size() <= 0) continue;
            projection = this.removeMergedDimensions(mergedDimensions, projectionColumns, factTableName);
        }
        return projection;
    }

    private QueryProjection removeMergedDimensions(List<CarbonDimension> mergedDimensions, String[] projectionColumns, String factTableName) {
        QueryProjection queryProjection = new QueryProjection();
        int i = 0;
        for (String projectionColumnName : projectionColumns) {
            CarbonDimension dimension = this.table.getDimensionByName(projectionColumnName);
            if (dimension != null) {
                if (mergedDimensions.contains(dimension) || this.isAlreadyExists(dimension, queryProjection.getDimensions())) continue;
                queryProjection.addDimension(dimension, i);
                ++i;
                continue;
            }
            CarbonMeasure measure = this.table.getMeasureByName(projectionColumnName);
            if (measure == null) {
                throw new RuntimeException(projectionColumnName + " column not found in the table " + factTableName);
            }
            queryProjection.addMeasure(measure, i);
            ++i;
        }
        return queryProjection;
    }

    private List<CarbonDimension> mergeChildColumns(List<Integer> childOrdinals) {
        ArrayList<CarbonDimension> mergedChild = new ArrayList<CarbonDimension>();
        List<CarbonDimension> dimList = this.table.getVisibleDimensions();
        for (int i = 0; i < childOrdinals.size(); ++i) {
            for (int j = i; j < childOrdinals.size(); ++j) {
                CarbonDimension parentDimension = this.getDimensionBasedOnOrdinal(dimList, childOrdinals.get(i));
                CarbonDimension childDimension = this.getDimensionBasedOnOrdinal(dimList, childOrdinals.get(j));
                if (mergedChild.contains(childOrdinals.get(j)) || !this.checkChildsInSamePath(parentDimension, childDimension)) continue;
                mergedChild.add(childDimension);
            }
        }
        return mergedChild;
    }

    private boolean checkChildsInSamePath(CarbonDimension parentDimension, CarbonDimension childDimension) {
        if (parentDimension.getColName().equals(childDimension.getColName())) {
            return false;
        }
        return this.checkForChildColumns(parentDimension, childDimension);
    }

    private boolean checkForChildColumns(CarbonDimension parentDimension, CarbonDimension childDimension) {
        boolean output = false;
        if (parentDimension.getOrdinal() == childDimension.getOrdinal()) {
            output = true;
        } else if (parentDimension.getNumberOfChild() > 0) {
            for (int i = 0; i < parentDimension.getNumberOfChild() && !output; ++i) {
                output = this.checkForChildColumns(parentDimension.getListOfChildDimensions().get(i), childDimension);
            }
        } else {
            output = false;
        }
        return output;
    }

    private CarbonDimension getDimensionBasedOnOrdinal(List<CarbonDimension> dimList, Integer ordinal) {
        for (CarbonDimension dims : dimList) {
            CarbonDimension dimensionBasedOnOrdinal;
            if (dims.getOrdinal() == ordinal.intValue()) {
                return dims;
            }
            if (dims.getNumberOfChild() <= 0 || null == (dimensionBasedOnOrdinal = this.getDimensionBasedOnOrdinal(dims.getListOfChildDimensions(), ordinal))) continue;
            return dimensionBasedOnOrdinal;
        }
        return null;
    }

    public QueryModelBuilder projectAllColumns() {
        QueryProjection projection = new QueryProjection();
        List<CarbonDimension> dimensions = this.table.getVisibleDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            projection.addDimension(dimensions.get(i), i);
        }
        List<CarbonMeasure> measures = this.table.getVisibleMeasures();
        for (int i = 0; i < measures.size(); ++i) {
            projection.addMeasure(measures.get(i), i);
        }
        this.projection = projection;
        return this;
    }

    public QueryModelBuilder filterExpression(IndexFilter filterExpression) {
        this.indexFilter = filterExpression;
        return this;
    }

    public QueryModelBuilder dataConverter(DataTypeConverter dataTypeConverter) {
        this.dataTypeConverter = dataTypeConverter;
        return this;
    }

    public QueryModelBuilder enableForcedDetailRawQuery() {
        this.forcedDetailRawQuery = true;
        return this;
    }

    public QueryModelBuilder convertToRangeFilter(boolean convertToRangeFilter) {
        this.convertToRangeFilter = convertToRangeFilter;
        return this;
    }

    public boolean isConvertToRangeFilter() {
        return this.convertToRangeFilter;
    }

    public void enableReadPageByPage() {
        this.readPageByPage = true;
    }

    public QueryModel build() {
        QueryModel queryModel = QueryModel.newInstance(this.table);
        queryModel.setConverter(this.dataTypeConverter);
        queryModel.setForcedDetailRawQuery(this.forcedDetailRawQuery);
        queryModel.setReadPageByPage(this.readPageByPage);
        queryModel.setProjection(this.projection);
        if (this.table.isTransactionalTable() && !this.table.hasColumnDrift()) {
            boolean[] isFilterDimensions = new boolean[this.table.getDimensionOrdinalMax()];
            boolean[] isFilterMeasures = new boolean[this.table.getAllMeasures().size()];
            queryModel.setIsFilterDimensions(isFilterDimensions);
            queryModel.setIsFilterMeasures(isFilterMeasures);
            if (this.indexFilter != null) {
                if (this.isConvertToRangeFilter()) {
                    this.indexFilter.processFilterExpression(isFilterDimensions, isFilterMeasures);
                } else {
                    this.indexFilter.processFilterExpressionWithoutRange(isFilterDimensions, isFilterMeasures);
                }
            }
        }
        queryModel.setIndexFilter(this.indexFilter);
        return queryModel;
    }
}

