/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.scan.collector.ResultCollectorFactory;
import org.apache.carbondata.core.scan.collector.ScannedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.processor.BlockletIterator;
import org.apache.carbondata.core.scan.processor.RawBlockletColumnChunks;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.scan.scanner.BlockletScanner;
import org.apache.carbondata.core.scan.scanner.impl.BlockletFilterScanner;
import org.apache.carbondata.core.scan.scanner.impl.BlockletFullScanner;
import org.apache.carbondata.core.stats.QueryStatisticsModel;
import org.apache.carbondata.core.util.TaskMetricsMap;

public class DataBlockIterator
extends CarbonIterator<List<Object[]>> {
    private BlockletIterator blockletIterator;
    private ScannedResultCollector scannerResultAggregator;
    private BlockletScanner blockletScanner;
    private int batchSize;
    private ExecutorService executorService;
    private Future<BlockletScannedResult> future;
    private Future<RawBlockletColumnChunks> futureIo;
    private BlockletScannedResult scannedResult;
    private BlockExecutionInfo blockExecutionInfo;
    private FileReader fileReader;
    private AtomicBoolean nextBlock;
    private AtomicBoolean nextRead;

    public DataBlockIterator(BlockExecutionInfo blockExecutionInfo, FileReader fileReader, int batchSize, QueryStatisticsModel queryStatisticsModel, ExecutorService executorService) {
        this.blockExecutionInfo = blockExecutionInfo;
        this.blockExecutionInfo.setQueryStatisticsModel(queryStatisticsModel);
        this.fileReader = fileReader;
        this.blockletIterator = new BlockletIterator(blockExecutionInfo.getFirstDataBlock(), blockExecutionInfo.getNumberOfBlockToScan());
        this.blockletScanner = blockExecutionInfo.getFilterExecuterTree() != null ? new BlockletFilterScanner(blockExecutionInfo, queryStatisticsModel) : new BlockletFullScanner(blockExecutionInfo, queryStatisticsModel);
        this.scannerResultAggregator = ResultCollectorFactory.getScannedResultCollector(blockExecutionInfo);
        this.batchSize = batchSize;
        this.executorService = executorService;
        this.nextBlock = new AtomicBoolean(false);
        this.nextRead = new AtomicBoolean(false);
    }

    public List<Object[]> next() {
        List<Object[]> collectedResult = null;
        if (this.updateScanner()) {
            collectedResult = this.scannerResultAggregator.collectResultInRow(this.scannedResult, this.batchSize);
            while (collectedResult.size() < this.batchSize && this.updateScanner()) {
                List<Object[]> data = this.scannerResultAggregator.collectResultInRow(this.scannedResult, this.batchSize - collectedResult.size());
                collectedResult.addAll(data);
            }
        } else {
            collectedResult = new ArrayList<Object[]>();
        }
        return collectedResult;
    }

    public boolean hasNext() {
        if (this.scannedResult != null && this.scannedResult.hasNext()) {
            return true;
        }
        if (null != this.scannedResult) {
            this.scannedResult.freeMemory();
        }
        return this.blockletIterator.hasNext() || this.nextBlock.get() || this.nextRead.get();
    }

    private boolean updateScanner() {
        try {
            if (this.scannedResult != null && this.scannedResult.hasNext()) {
                return true;
            }
            this.scannedResult = this.processNextBlocklet();
            while (this.scannedResult != null) {
                if (this.scannedResult.hasNext()) {
                    return true;
                }
                this.scannedResult = this.processNextBlocklet();
            }
            this.nextBlock.set(false);
            this.nextRead.set(false);
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private BlockletScannedResult processNextBlocklet() throws Exception {
        RawBlockletColumnChunks rawChunks;
        BlockletScannedResult result = null;
        if (this.blockExecutionInfo.isPrefetchBlocklet()) {
            if (this.blockletIterator.hasNext() || this.nextBlock.get() || this.nextRead.get()) {
                if (this.future == null) {
                    this.future = this.scanNextBlockletAsync();
                }
                result = this.future.get();
                this.nextBlock.set(false);
                if (this.blockletIterator.hasNext() || this.nextRead.get()) {
                    this.nextBlock.set(true);
                    this.future = this.scanNextBlockletAsync();
                }
            }
        } else if (this.blockletIterator.hasNext() && (rawChunks = this.readNextBlockletColumnChunks()) != null) {
            result = this.blockletScanner.scanBlocklet(rawChunks);
        }
        return result;
    }

    private RawBlockletColumnChunks readNextBlockletColumnChunks() throws IOException {
        RawBlockletColumnChunks rawBlockletColumnChunks = this.getNextBlockletColumnChunks();
        if (rawBlockletColumnChunks != null) {
            this.blockletScanner.readBlocklet(rawBlockletColumnChunks);
            return rawBlockletColumnChunks;
        }
        return null;
    }

    private RawBlockletColumnChunks getNextBlockletColumnChunks() {
        RawBlockletColumnChunks rawBlockletColumnChunks = null;
        do {
            DataRefNode dataBlock;
            if ((dataBlock = this.blockletIterator.next()).getColumnsMaxValue() != null && !this.blockletScanner.isScanRequired(dataBlock)) continue;
            rawBlockletColumnChunks = RawBlockletColumnChunks.newInstance(this.blockExecutionInfo.getTotalNumberDimensionToRead(), this.blockExecutionInfo.getTotalNumberOfMeasureToRead(), this.fileReader, dataBlock);
        } while (rawBlockletColumnChunks == null && this.blockletIterator.hasNext());
        return rawBlockletColumnChunks;
    }

    private Future<BlockletScannedResult> scanNextBlockletAsync() {
        return this.executorService.submit(new Callable<BlockletScannedResult>(){

            @Override
            public BlockletScannedResult call() throws Exception {
                if (DataBlockIterator.this.futureIo == null) {
                    DataBlockIterator.this.futureIo = DataBlockIterator.this.readNextBlockletAsync();
                }
                RawBlockletColumnChunks rawBlockletColumnChunks = (RawBlockletColumnChunks)DataBlockIterator.this.futureIo.get();
                DataBlockIterator.this.futureIo = null;
                DataBlockIterator.this.nextRead.set(false);
                if (rawBlockletColumnChunks != null) {
                    if (DataBlockIterator.this.blockletIterator.hasNext()) {
                        DataBlockIterator.this.nextRead.set(true);
                        DataBlockIterator.this.futureIo = DataBlockIterator.this.readNextBlockletAsync();
                    }
                    return DataBlockIterator.this.blockletScanner.scanBlocklet(rawBlockletColumnChunks);
                }
                return null;
            }
        });
    }

    private Future<RawBlockletColumnChunks> readNextBlockletAsync() {
        return this.executorService.submit(new Callable<RawBlockletColumnChunks>(){

            @Override
            public RawBlockletColumnChunks call() throws Exception {
                try {
                    TaskMetricsMap.getInstance().registerThreadCallback();
                    if (DataBlockIterator.this.blockletIterator.hasNext()) {
                        RawBlockletColumnChunks rawBlockletColumnChunks = DataBlockIterator.this.readNextBlockletColumnChunks();
                        return rawBlockletColumnChunks;
                    }
                    RawBlockletColumnChunks rawBlockletColumnChunks = null;
                    return rawBlockletColumnChunks;
                }
                finally {
                    TaskMetricsMap.getInstance().updateReadBytes(Thread.currentThread().getId());
                }
            }
        });
    }

    public void processNextBatch(CarbonColumnarBatch columnarBatch) {
        if (this.updateScanner()) {
            this.scannerResultAggregator.collectResultInColumnarBatch(this.scannedResult, columnarBatch);
        }
    }

    public void close() {
        if (null != this.scannedResult && !this.scannedResult.hasNext()) {
            this.scannedResult.freeMemory();
        }
        if (null != this.future) {
            try {
                BlockletScannedResult blockletScannedResult = this.future.get();
                if (blockletScannedResult != null) {
                    blockletScannedResult.freeMemory();
                }
                this.future = null;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

